/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.layout.template.json.resolver;

import java.nio.charset.Charset;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.lookup.StrSubstitutor;
import org.apache.logging.log4j.layout.template.json.JsonTemplateLayout;
import org.apache.logging.log4j.layout.template.json.resolver.EventResolverFactories;
import org.apache.logging.log4j.layout.template.json.resolver.StackTraceObjectResolver;
import org.apache.logging.log4j.layout.template.json.resolver.TemplateResolver;
import org.apache.logging.log4j.layout.template.json.resolver.TemplateResolverContext;
import org.apache.logging.log4j.layout.template.json.resolver.TemplateResolverFactory;
import org.apache.logging.log4j.layout.template.json.util.JsonWriter;
import org.apache.logging.log4j.layout.template.json.util.RecyclerFactory;

public final class EventResolverContext
implements TemplateResolverContext<LogEvent, EventResolverContext> {
    private final Configuration configuration;
    private final StrSubstitutor substitutor;
    private final Charset charset;
    private final JsonWriter jsonWriter;
    private final RecyclerFactory recyclerFactory;
    private final int maxStringByteCount;
    private final boolean locationInfoEnabled;
    private final boolean stackTraceEnabled;
    private final TemplateResolver<Throwable> stackTraceObjectResolver;
    private final JsonTemplateLayout.EventTemplateAdditionalField[] additionalFields;

    private EventResolverContext(Builder builder) {
        this.configuration = builder.configuration;
        this.substitutor = builder.substitutor;
        this.charset = builder.charset;
        this.jsonWriter = builder.jsonWriter;
        this.recyclerFactory = builder.recyclerFactory;
        this.maxStringByteCount = builder.maxStringByteCount;
        this.locationInfoEnabled = builder.locationInfoEnabled;
        this.stackTraceEnabled = builder.stackTraceEnabled;
        this.stackTraceObjectResolver = this.stackTraceEnabled ? new StackTraceObjectResolver(builder.stackTraceElementObjectResolver) : null;
        this.additionalFields = builder.eventTemplateAdditionalFields;
    }

    @Override
    public Class<EventResolverContext> getContextClass() {
        return EventResolverContext.class;
    }

    @Override
    public Map<String, TemplateResolverFactory<LogEvent, EventResolverContext, ? extends TemplateResolver<LogEvent>>> getResolverFactoryByName() {
        return EventResolverFactories.getResolverFactoryByName();
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public StrSubstitutor getSubstitutor() {
        return this.substitutor;
    }

    public Charset getCharset() {
        return this.charset;
    }

    @Override
    public JsonWriter getJsonWriter() {
        return this.jsonWriter;
    }

    RecyclerFactory getRecyclerFactory() {
        return this.recyclerFactory;
    }

    int getMaxStringByteCount() {
        return this.maxStringByteCount;
    }

    boolean isLocationInfoEnabled() {
        return this.locationInfoEnabled;
    }

    boolean isStackTraceEnabled() {
        return this.stackTraceEnabled;
    }

    TemplateResolver<Throwable> getStackTraceObjectResolver() {
        return this.stackTraceObjectResolver;
    }

    JsonTemplateLayout.EventTemplateAdditionalField[] getAdditionalFields() {
        return this.additionalFields;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private Configuration configuration;
        private StrSubstitutor substitutor;
        private Charset charset;
        private JsonWriter jsonWriter;
        private RecyclerFactory recyclerFactory;
        private int maxStringByteCount;
        private boolean locationInfoEnabled;
        private boolean stackTraceEnabled;
        private TemplateResolver<StackTraceElement> stackTraceElementObjectResolver;
        private JsonTemplateLayout.EventTemplateAdditionalField[] eventTemplateAdditionalFields;

        private Builder() {
        }

        public Builder setConfiguration(Configuration configuration) {
            this.configuration = configuration;
            return this;
        }

        public Builder setSubstitutor(StrSubstitutor substitutor) {
            this.substitutor = substitutor;
            return this;
        }

        public Builder setCharset(Charset charset) {
            this.charset = charset;
            return this;
        }

        public Builder setJsonWriter(JsonWriter jsonWriter) {
            this.jsonWriter = jsonWriter;
            return this;
        }

        public Builder setRecyclerFactory(RecyclerFactory recyclerFactory) {
            this.recyclerFactory = recyclerFactory;
            return this;
        }

        public Builder setMaxStringByteCount(int maxStringByteCount) {
            this.maxStringByteCount = maxStringByteCount;
            return this;
        }

        public Builder setLocationInfoEnabled(boolean locationInfoEnabled) {
            this.locationInfoEnabled = locationInfoEnabled;
            return this;
        }

        public Builder setStackTraceEnabled(boolean stackTraceEnabled) {
            this.stackTraceEnabled = stackTraceEnabled;
            return this;
        }

        public Builder setStackTraceElementObjectResolver(TemplateResolver<StackTraceElement> stackTraceElementObjectResolver) {
            this.stackTraceElementObjectResolver = stackTraceElementObjectResolver;
            return this;
        }

        public Builder setEventTemplateAdditionalFields(JsonTemplateLayout.EventTemplateAdditionalField[] eventTemplateAdditionalFields) {
            this.eventTemplateAdditionalFields = eventTemplateAdditionalFields;
            return this;
        }

        public EventResolverContext build() {
            this.validate();
            return new EventResolverContext(this);
        }

        private void validate() {
            Objects.requireNonNull(this.configuration, "configuration");
            Objects.requireNonNull(this.substitutor, "substitutor");
            Objects.requireNonNull(this.charset, "charset");
            Objects.requireNonNull(this.jsonWriter, "jsonWriter");
            Objects.requireNonNull(this.recyclerFactory, "recyclerFactory");
            if (this.maxStringByteCount <= 0) {
                throw new IllegalArgumentException("was expecting maxStringByteCount > 0: " + this.maxStringByteCount);
            }
            if (this.stackTraceEnabled) {
                Objects.requireNonNull(this.stackTraceElementObjectResolver, "stackTraceElementObjectResolver");
            }
        }
    }
}

