/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.layout.template.json.resolver;

import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.util.Throwables;
import org.apache.logging.log4j.layout.template.json.resolver.EventResolver;
import org.apache.logging.log4j.layout.template.json.resolver.EventResolverContext;
import org.apache.logging.log4j.layout.template.json.resolver.ExceptionInternalResolverFactory;
import org.apache.logging.log4j.layout.template.json.resolver.StackTraceStringResolver;
import org.apache.logging.log4j.layout.template.json.resolver.TemplateResolverConfig;
import org.apache.logging.log4j.layout.template.json.util.JsonWriter;

final class ExceptionRootCauseResolver
implements EventResolver {
    private static final ExceptionInternalResolverFactory INTERNAL_RESOLVER_FACTORY = new ExceptionInternalResolverFactory(){

        @Override
        EventResolver createClassNameResolver() {
            return (logEvent, jsonWriter) -> {
                Throwable exception = logEvent.getThrown();
                if (exception == null) {
                    jsonWriter.writeNull();
                } else {
                    Throwable rootCause = Throwables.getRootCause((Throwable)exception);
                    String rootCauseClassName = rootCause.getClass().getCanonicalName();
                    jsonWriter.writeString(rootCauseClassName);
                }
            };
        }

        @Override
        EventResolver createMessageResolver(EventResolverContext context) {
            return (logEvent, jsonWriter) -> {
                Throwable exception = logEvent.getThrown();
                if (exception == null) {
                    jsonWriter.writeNull();
                } else {
                    Throwable rootCause = Throwables.getRootCause((Throwable)exception);
                    String rootCauseMessage = rootCause.getMessage();
                    jsonWriter.writeString(rootCauseMessage);
                }
            };
        }

        @Override
        EventResolver createStackTraceStringResolver(EventResolverContext context) {
            StackTraceStringResolver stackTraceStringResolver = new StackTraceStringResolver(context);
            return (logEvent, jsonWriter) -> {
                Throwable exception = logEvent.getThrown();
                if (exception == null) {
                    jsonWriter.writeNull();
                } else {
                    Throwable rootCause = Throwables.getRootCause((Throwable)exception);
                    stackTraceStringResolver.resolve(rootCause, jsonWriter);
                }
            };
        }

        @Override
        EventResolver createStackTraceObjectResolver(EventResolverContext context) {
            return (logEvent, jsonWriter) -> {
                Throwable exception = logEvent.getThrown();
                if (exception == null) {
                    jsonWriter.writeNull();
                } else {
                    Throwable rootCause = Throwables.getRootCause((Throwable)exception);
                    context.getStackTraceObjectResolver().resolve(rootCause, jsonWriter);
                }
            };
        }
    };
    private final boolean stackTraceEnabled;
    private final EventResolver internalResolver;

    ExceptionRootCauseResolver(EventResolverContext context, TemplateResolverConfig config) {
        this.stackTraceEnabled = context.isStackTraceEnabled();
        this.internalResolver = INTERNAL_RESOLVER_FACTORY.createInternalResolver(context, config);
    }

    static String getName() {
        return "exceptionRootCause";
    }

    @Override
    public boolean isResolvable() {
        return this.stackTraceEnabled;
    }

    @Override
    public boolean isResolvable(LogEvent logEvent) {
        return this.stackTraceEnabled && logEvent.getThrown() != null;
    }

    @Override
    public void resolve(LogEvent logEvent, JsonWriter jsonWriter) {
        this.internalResolver.resolve(logEvent, jsonWriter);
    }
}

