/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.layout.template.json.resolver;

import java.util.Map;
import java.util.regex.Pattern;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.layout.template.json.resolver.EventResolver;
import org.apache.logging.log4j.layout.template.json.resolver.EventResolverContext;
import org.apache.logging.log4j.layout.template.json.resolver.TemplateResolverConfig;
import org.apache.logging.log4j.layout.template.json.util.JsonWriter;
import org.apache.logging.log4j.layout.template.json.util.Recycler;
import org.apache.logging.log4j.layout.template.json.util.RecyclerFactory;
import org.apache.logging.log4j.util.ReadOnlyStringMap;
import org.apache.logging.log4j.util.TriConsumer;

final class ThreadContextDataResolver
implements EventResolver {
    private final EventResolver internalResolver;

    ThreadContextDataResolver(EventResolverContext context, TemplateResolverConfig config) {
        this.internalResolver = ThreadContextDataResolver.createResolver(context, config);
    }

    private static EventResolver createResolver(EventResolverContext context, TemplateResolverConfig config) {
        boolean flatten;
        Object flattenObject = config.getObject("flatten");
        if (flattenObject == null) {
            flatten = false;
        } else if (flattenObject instanceof Boolean) {
            flatten = (Boolean)flattenObject;
        } else if (flattenObject instanceof Map) {
            flatten = true;
        } else {
            throw new IllegalArgumentException("invalid flatten option: " + config);
        }
        String key = config.getString("key");
        String prefix = config.getString(new String[]{"flatten", "prefix"});
        String pattern = config.getString("pattern");
        boolean stringified = config.getBoolean("stringified", false);
        if (key != null) {
            if (flatten) {
                throw new IllegalArgumentException("both key and flatten options cannot be supplied: " + config);
            }
            return ThreadContextDataResolver.createKeyResolver(key, stringified);
        }
        RecyclerFactory recyclerFactory = context.getRecyclerFactory();
        return ThreadContextDataResolver.createResolver(recyclerFactory, flatten, prefix, pattern, stringified);
    }

    private static EventResolver createKeyResolver(final String key, final boolean stringified) {
        return new EventResolver(){

            @Override
            public boolean isResolvable(LogEvent logEvent) {
                ReadOnlyStringMap contextData = logEvent.getContextData();
                return contextData != null && contextData.containsKey(key);
            }

            @Override
            public void resolve(LogEvent logEvent, JsonWriter jsonWriter) {
                Object value;
                ReadOnlyStringMap contextData = logEvent.getContextData();
                Object object = value = contextData == null ? null : contextData.getValue(key);
                if (stringified) {
                    String valueString = String.valueOf(value);
                    jsonWriter.writeString(valueString);
                } else {
                    jsonWriter.writeValue(value);
                }
            }
        };
    }

    private static EventResolver createResolver(RecyclerFactory recyclerFactory, boolean flatten, String prefix, String pattern, boolean stringified) {
        Pattern compiledPattern = pattern == null ? null : Pattern.compile(pattern);
        Recycler<LoopContext> loopContextRecycler = recyclerFactory.create(() -> {
            LoopContext loopContext = new LoopContext();
            if (prefix != null) {
                loopContext.prefix = prefix;
                loopContext.prefixedKey = new StringBuilder(prefix);
            }
            loopContext.pattern = compiledPattern;
            loopContext.stringified = stringified;
            return loopContext;
        });
        return ThreadContextDataResolver.createResolver(flatten, loopContextRecycler);
    }

    private static EventResolver createResolver(final boolean flatten, final Recycler<LoopContext> loopContextRecycler) {
        return new EventResolver(){

            @Override
            public boolean isFlattening() {
                return flatten;
            }

            @Override
            public boolean isResolvable(LogEvent logEvent) {
                ReadOnlyStringMap contextData = logEvent.getContextData();
                return contextData != null && !contextData.isEmpty();
            }

            @Override
            public void resolve(LogEvent value, JsonWriter jsonWriter) {
                throw new UnsupportedOperationException();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void resolve(LogEvent logEvent, JsonWriter jsonWriter, boolean succeedingEntry) {
                ReadOnlyStringMap contextData = logEvent.getContextData();
                if (contextData == null || contextData.isEmpty()) {
                    if (!flatten) {
                        jsonWriter.writeNull();
                    }
                    return;
                }
                if (!flatten) {
                    jsonWriter.writeObjectStart();
                }
                LoopContext loopContext = (LoopContext)loopContextRecycler.acquire();
                loopContext.jsonWriter = jsonWriter;
                loopContext.initJsonWriterStringBuilderLength = jsonWriter.getStringBuilder().length();
                loopContext.succeedingEntry = flatten && succeedingEntry;
                try {
                    contextData.forEach((TriConsumer)LoopMethod.INSTANCE, (Object)loopContext);
                }
                finally {
                    loopContextRecycler.release(loopContext);
                }
                if (!flatten) {
                    jsonWriter.writeObjectEnd();
                }
            }
        };
    }

    static String getName() {
        return "mdc";
    }

    @Override
    public boolean isFlattening() {
        return this.internalResolver.isFlattening();
    }

    @Override
    public boolean isResolvable(LogEvent logEvent) {
        ReadOnlyStringMap contextData = logEvent.getContextData();
        return contextData != null && !contextData.isEmpty();
    }

    @Override
    public void resolve(LogEvent logEvent, JsonWriter jsonWriter) {
        this.internalResolver.resolve(logEvent, jsonWriter);
    }

    @Override
    public void resolve(LogEvent logEvent, JsonWriter jsonWriter, boolean succeedingEntry) {
        this.internalResolver.resolve(logEvent, jsonWriter, succeedingEntry);
    }

    private static final class LoopMethod
    implements TriConsumer<String, Object, LoopContext> {
        private static final LoopMethod INSTANCE = new LoopMethod();

        private LoopMethod() {
        }

        public void accept(String key, Object value, LoopContext loopContext) {
            boolean keyMatched;
            boolean bl = keyMatched = loopContext.pattern == null || loopContext.pattern.matcher(key).matches();
            if (keyMatched) {
                boolean succeedingEntry;
                boolean bl2 = succeedingEntry = loopContext.succeedingEntry || loopContext.initJsonWriterStringBuilderLength < loopContext.jsonWriter.getStringBuilder().length();
                if (succeedingEntry) {
                    loopContext.jsonWriter.writeSeparator();
                }
                if (loopContext.prefix == null) {
                    loopContext.jsonWriter.writeObjectKey(key);
                } else {
                    loopContext.prefixedKey.setLength(loopContext.prefix.length());
                    loopContext.prefixedKey.append(key);
                    loopContext.jsonWriter.writeObjectKey(loopContext.prefixedKey);
                }
                if (loopContext.stringified && !(value instanceof String)) {
                    String valueString = String.valueOf(value);
                    loopContext.jsonWriter.writeString(valueString);
                } else {
                    loopContext.jsonWriter.writeValue(value);
                }
            }
        }
    }

    private static final class LoopContext {
        private String prefix;
        private StringBuilder prefixedKey;
        private Pattern pattern;
        private boolean stringified;
        private JsonWriter jsonWriter;
        private int initJsonWriterStringBuilderLength;
        private boolean succeedingEntry;

        private LoopContext() {
        }
    }
}

