/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.layout.template.json.resolver;

import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.layout.template.json.resolver.EventResolver;
import org.apache.logging.log4j.layout.template.json.resolver.TemplateResolver;
import org.apache.logging.log4j.layout.template.json.resolver.TemplateResolverConfig;
import org.apache.logging.log4j.layout.template.json.util.JsonWriter;

public final class MarkerResolver
implements EventResolver {
    private static final TemplateResolver<LogEvent> NAME_RESOLVER = (logEvent, jsonWriter) -> {
        Marker marker = logEvent.getMarker();
        if (marker == null) {
            jsonWriter.writeNull();
        } else {
            jsonWriter.writeString(marker.getName());
        }
    };
    private final TemplateResolver<LogEvent> internalResolver;

    MarkerResolver(TemplateResolverConfig config) {
        this.internalResolver = this.createInternalResolver(config);
    }

    private TemplateResolver<LogEvent> createInternalResolver(TemplateResolverConfig config) {
        String fieldName = config.getString("field");
        if ("name".equals(fieldName)) {
            return NAME_RESOLVER;
        }
        throw new IllegalArgumentException("unknown field: " + config);
    }

    static String getName() {
        return "marker";
    }

    @Override
    public boolean isResolvable(LogEvent logEvent) {
        return logEvent.getMarker() != null;
    }

    @Override
    public void resolve(LogEvent logEvent, JsonWriter jsonWriter) {
        this.internalResolver.resolve(logEvent, jsonWriter);
    }
}

