/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.layout.template.json.resolver;

import java.util.Map;
import org.apache.logging.log4j.layout.template.json.JsonTemplateLayout;
import org.apache.logging.log4j.layout.template.json.resolver.EventResolverContext;
import org.apache.logging.log4j.layout.template.json.resolver.EventResolverInterceptor;
import org.apache.logging.log4j.plugins.Namespace;
import org.apache.logging.log4j.plugins.Plugin;
import org.apache.logging.log4j.plugins.PluginFactory;
import org.apache.logging.log4j.util.JsonReader;

@Namespace(value="JsonTemplateResolverInterceptor")
@Plugin(value="EventAdditionalFieldInterceptor")
public class EventAdditionalFieldInterceptor
implements EventResolverInterceptor {
    private static final EventAdditionalFieldInterceptor INSTANCE = new EventAdditionalFieldInterceptor();

    private EventAdditionalFieldInterceptor() {
    }

    @PluginFactory
    public static EventAdditionalFieldInterceptor getInstance() {
        return INSTANCE;
    }

    @Override
    public Object processTemplateBeforeResolverInjection(EventResolverContext context, Object node) {
        Map objectNode;
        JsonTemplateLayout.EventTemplateAdditionalField[] additionalFields = context.getEventTemplateAdditionalFields();
        if (additionalFields.length == 0) {
            return node;
        }
        try {
            Map map;
            objectNode = map = (Map)node;
        }
        catch (ClassCastException error) {
            String message = String.format("was expecting an object to merge additional fields: %s", node.getClass().getName());
            throw new IllegalArgumentException(message);
        }
        for (JsonTemplateLayout.EventTemplateAdditionalField additionalField : additionalFields) {
            Object additionalFieldValue;
            String additionalFieldKey = additionalField.getKey();
            JsonTemplateLayout.EventTemplateAdditionalField.Format additionalFieldFormat = additionalField.getFormat();
            if (JsonTemplateLayout.EventTemplateAdditionalField.Format.STRING.equals((Object)additionalFieldFormat)) {
                additionalFieldValue = additionalField.getValue();
            } else if (JsonTemplateLayout.EventTemplateAdditionalField.Format.JSON.equals((Object)additionalFieldFormat)) {
                try {
                    additionalFieldValue = JsonReader.read((String)additionalField.getValue());
                }
                catch (Exception error) {
                    String message = String.format("failed reading JSON provided by additional field: %s", additionalFieldKey);
                    throw new IllegalArgumentException(message, error);
                }
            } else {
                String message = String.format("unknown format %s for additional field: %s", new Object[]{additionalFieldKey, additionalFieldFormat});
                throw new IllegalArgumentException(message);
            }
            objectNode.put(additionalFieldKey, additionalFieldValue);
        }
        return node;
    }
}

