/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.plugins.di;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.apache.logging.log4j.plugins.Namespace;
import org.apache.logging.log4j.plugins.di.Key;
import org.apache.logging.log4j.plugins.internal.util.BeanUtils;
import org.apache.logging.log4j.plugins.name.AliasesProvider;
import org.apache.logging.log4j.plugins.name.AnnotatedElementAliasesProvider;
import org.apache.logging.log4j.plugins.name.NameProvider;
import org.apache.logging.log4j.plugins.util.AnnotationUtil;
import org.apache.logging.log4j.util.Cast;
import org.apache.logging.log4j.util.ReflectionUtil;

public final class Keys {
    public static final String SUBSTITUTOR_NAME = "StringSubstitutor";
    public static final Key<Function<String, String>> SUBSTITUTOR_KEY = new Key<Function<String, String>>(){};

    private Keys() {
        throw new IllegalStateException("Utility class");
    }

    public static String getNamespace(AnnotatedElement element) {
        return Optional.ofNullable(AnnotationUtil.getLogicalAnnotation(element, Namespace.class)).map(Namespace::value).orElse("");
    }

    public static boolean hasName(AnnotatedElement element) {
        return AnnotationUtil.isMetaAnnotationPresent(element, NameProvider.class);
    }

    public static String getName(Field field) {
        return Keys.hasName(field) ? Keys.getSpecifiedName(field).orElseGet(field::getName) : "";
    }

    public static String getName(Parameter parameter) {
        return Keys.hasName(parameter) ? Keys.getSpecifiedName(parameter).orElseGet(parameter::getName) : "";
    }

    public static String getName(Method method) {
        return Keys.hasName(method) ? Keys.getSpecifiedName(method).orElseGet(() -> {
            String methodName = method.getName();
            if (methodName.startsWith("is")) {
                return BeanUtils.decapitalize(methodName.substring(2));
            }
            if (methodName.startsWith("set") || methodName.startsWith("get")) {
                return BeanUtils.decapitalize(methodName.substring(3));
            }
            if (methodName.startsWith("with")) {
                return BeanUtils.decapitalize(methodName.substring(4));
            }
            return methodName;
        }) : "";
    }

    public static String getName(AnnotatedType annotatedType) {
        return Keys.hasName(annotatedType) ? Keys.getSpecifiedName(annotatedType).orElse("") : "";
    }

    public static String getName(Class<?> type) {
        return Keys.hasName(type) ? Keys.getSpecifiedName(type).orElseGet(type::getSimpleName) : "";
    }

    private static Optional<String> getSpecifiedName(AnnotatedElement element) {
        for (Annotation annotation : element.getAnnotations()) {
            Optional<String> name = Keys.getSpecifiedNameForAnnotation(annotation);
            if (!name.isPresent()) continue;
            return name;
        }
        return Optional.empty();
    }

    private static <A extends Annotation> Optional<String> getSpecifiedNameForAnnotation(A annotation) {
        return Optional.ofNullable(annotation.annotationType().getAnnotation(NameProvider.class)).map(NameProvider::value).map(Cast::cast).map(ReflectionUtil::instantiate).flatMap(provider -> provider.getSpecifiedName(annotation));
    }

    public static Collection<String> getAliases(AnnotatedElement element) {
        for (Annotation annotation : element.getAnnotations()) {
            if (!annotation.annotationType().isAnnotationPresent(AliasesProvider.class)) continue;
            return Keys.getAliasesForAnnotation(annotation);
        }
        return List.of();
    }

    private static <A extends Annotation> Collection<String> getAliasesForAnnotation(A annotation) {
        Class<? extends AnnotatedElementAliasesProvider<? extends Annotation>> providerType = annotation.annotationType().getAnnotation(AliasesProvider.class).value();
        AnnotatedElementAliasesProvider provider = (AnnotatedElementAliasesProvider)ReflectionUtil.instantiate(providerType);
        return provider.getAliases(annotation);
    }
}

