/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.spring.boot;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.LoggerContextAware;
import org.apache.logging.log4j.core.lookup.Lookup;
import org.apache.logging.log4j.core.lookup.StrLookup;
import org.apache.logging.log4j.plugins.Plugin;
import org.apache.logging.log4j.status.StatusLogger;
import org.springframework.core.env.Environment;

@Lookup
@Plugin(value="spring")
public class SpringLookup
implements LoggerContextAware,
StrLookup {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private static final String ACTIVE = "profiles.active";
    private static final String DEFAULT = "profiles.default";
    private static final String PATTERN = "\\[(\\d+?)\\]";
    private static final Pattern ACTIVE_PATTERN = Pattern.compile("profiles.active\\[(\\d+?)\\]");
    private static final Pattern DEFAULT_PATTERN = Pattern.compile("profiles.default\\[(\\d+?)\\]");
    private Environment environment = null;

    public String lookup(String key) {
        if (this.environment != null) {
            String lowerKey = key.toLowerCase();
            if (lowerKey.startsWith(ACTIVE)) {
                switch (this.environment.getActiveProfiles().length) {
                    case 0: {
                        return null;
                    }
                    case 1: {
                        return this.environment.getActiveProfiles()[0];
                    }
                }
                Matcher matcher = ACTIVE_PATTERN.matcher(key);
                if (matcher.matches()) {
                    try {
                        int index = Integer.parseInt(matcher.group(1));
                        if (index < this.environment.getActiveProfiles().length) {
                            return this.environment.getActiveProfiles()[index];
                        }
                        LOGGER.warn("Index out of bounds for Spring active profiles: {}", (Object)index);
                        return null;
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Unable to parse {} as integer value", (Object)matcher.group(1));
                        return null;
                    }
                }
                StringBuilder sb = new StringBuilder();
                for (String profile : this.environment.getActiveProfiles()) {
                    if (sb.length() > 0) {
                        sb.append(",");
                    }
                    sb.append(profile);
                }
                return sb.toString();
            }
            if (lowerKey.startsWith(DEFAULT)) {
                switch (this.environment.getDefaultProfiles().length) {
                    case 0: {
                        return null;
                    }
                    case 1: {
                        return this.environment.getDefaultProfiles()[0];
                    }
                }
                Matcher matcher = DEFAULT_PATTERN.matcher(key);
                if (matcher.matches()) {
                    try {
                        int index = Integer.parseInt(matcher.group(1));
                        if (index < this.environment.getDefaultProfiles().length) {
                            return this.environment.getDefaultProfiles()[index];
                        }
                        LOGGER.warn("Index out of bounds for Spring default profiles: {}", (Object)index);
                        return null;
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Unable to parse {} as integer value", (Object)matcher.group(1));
                        return null;
                    }
                }
                StringBuilder sb = new StringBuilder();
                for (String profile : this.environment.getDefaultProfiles()) {
                    if (sb.length() > 0) {
                        sb.append(",");
                    }
                    sb.append(profile);
                }
                return sb.toString();
            }
            return this.environment.getProperty(key);
        }
        return null;
    }

    public String lookup(LogEvent event, String key) {
        return this.lookup(key);
    }

    public void setLoggerContext(LoggerContext loggerContext) {
        if (loggerContext != null) {
            this.environment = (Environment)loggerContext.getObject("SpringEnvironment");
        } else {
            LOGGER.warn("Attempt to set LoggerContext reference to null in SpringLookup");
        }
    }
}

