/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ja;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.ja.completion.CharSequenceUtils;
import org.apache.lucene.analysis.ja.completion.KatakanaRomanizer;
import org.apache.lucene.analysis.ja.tokenattributes.ReadingAttribute;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.util.CharsRef;
import org.apache.lucene.util.CharsRefBuilder;
import org.apache.lucene.util.IgnoreRandomChains;

@IgnoreRandomChains(reason="LUCENE-10363: fails with incorrect offsets")
public final class JapaneseCompletionFilter
extends TokenFilter {
    public static final Mode DEFAULT_MODE = Mode.INDEX;
    private final CharTermAttribute termAttr = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private final ReadingAttribute readingAttr = (ReadingAttribute)this.addAttribute(ReadingAttribute.class);
    private final PositionIncrementAttribute posIncAtt = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);
    private final OffsetAttribute offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
    private final CompletionTokenGenerator tokenGenerator;
    private boolean inputStreamConsumed = false;

    public JapaneseCompletionFilter(TokenStream input) {
        this(input, DEFAULT_MODE);
    }

    public JapaneseCompletionFilter(TokenStream input, Mode mode) {
        super(input);
        this.tokenGenerator = new CompletionTokenGenerator(mode);
    }

    public void reset() throws IOException {
        super.reset();
        this.tokenGenerator.reset();
        this.inputStreamConsumed = false;
    }

    public boolean incrementToken() throws IOException {
        this.mayIncrementToken();
        if (this.tokenGenerator.hasNext()) {
            this.clearAttributes();
            CompletionToken token = this.tokenGenerator.next();
            this.termAttr.setEmpty().append(token.term);
            if (token.isFirst) {
                this.posIncAtt.setPositionIncrement(1);
            } else {
                this.posIncAtt.setPositionIncrement(0);
            }
            this.offsetAtt.setOffset(token.startOffset, token.endOffset);
            return true;
        }
        return false;
    }

    private void mayIncrementToken() throws IOException {
        while (!this.tokenGenerator.hasNext()) {
            if (!this.inputStreamConsumed && this.input.incrementToken()) {
                String surface = this.termAttr.toString();
                String reading = this.readingAttr.getReading();
                int startOffset = this.offsetAtt.startOffset();
                int endOffset = this.offsetAtt.endOffset();
                if (reading == null && CharSequenceUtils.isKana(surface)) {
                    reading = CharSequenceUtils.toKatakana(surface);
                }
                this.tokenGenerator.addToken(surface, reading, startOffset, endOffset);
                continue;
            }
            this.inputStreamConsumed = true;
            if (!this.tokenGenerator.hasPendingToken()) break;
            this.tokenGenerator.finish();
        }
    }

    public static enum Mode {
        INDEX,
        QUERY;

    }

    private static class CompletionTokenGenerator
    implements Iterator<CompletionToken> {
        private final Mode mode;
        private List<CompletionToken> outputs;
        private CharsRefBuilder pdgSurface;
        private CharsRefBuilder pdgReading;
        private int pdgStartOffset;
        private int pdgEndOffset;

        CompletionTokenGenerator(Mode mode) {
            this.mode = mode;
            this.outputs = new ArrayList<CompletionToken>();
        }

        public void reset() {
            this.clearPendingToken();
            this.outputs.clear();
        }

        @Override
        public boolean hasNext() {
            return this.outputs.size() > 0;
        }

        @Override
        public CompletionToken next() {
            return this.outputs.remove(0);
        }

        void addToken(String surface, String reading, int startOffset, int endOffset) {
            assert (surface != null) : "surface must not be null.";
            if (this.hasPendingToken()) {
                if (this.mode == Mode.QUERY && this.pdgReading != null && !CharSequenceUtils.isLowercaseAlphabets((CharSequence)this.pdgSurface.get()) && CharSequenceUtils.isLowercaseAlphabets(surface)) {
                    this.pdgSurface.append((CharSequence)surface);
                    this.pdgReading.append((CharSequence)surface);
                    this.pdgEndOffset = endOffset;
                    this.generateOutputs();
                    this.clearPendingToken();
                } else if (this.mode == Mode.QUERY && CharSequenceUtils.isKana((CharSequence)this.pdgSurface.get()) && CharSequenceUtils.isKana(surface)) {
                    this.pdgSurface.append((CharSequence)surface);
                    this.pdgReading.append((CharSequence)reading);
                    this.pdgEndOffset = endOffset;
                } else {
                    this.generateOutputs();
                    this.resetPendingToken(surface, reading, startOffset, endOffset);
                }
            } else {
                this.resetPendingToken(surface, reading, startOffset, endOffset);
            }
        }

        void finish() {
            this.generateOutputs();
            this.clearPendingToken();
        }

        private void generateOutputs() {
            this.outputs.add(new CompletionToken(this.pdgSurface.toString(), true, this.pdgStartOffset, this.pdgEndOffset));
            if (this.pdgReading == null || this.pdgReading.length() == 0 || !CharSequenceUtils.isKatakanaOrHWAlphabets((CharSequence)this.pdgReading.get())) {
                return;
            }
            List<CharsRef> romaji = KatakanaRomanizer.getInstance().romanize(this.pdgReading.get());
            for (CharsRef ref : romaji) {
                this.outputs.add(new CompletionToken(ref.toString(), false, this.pdgStartOffset, this.pdgEndOffset));
            }
        }

        boolean hasPendingToken() {
            return this.pdgSurface != null;
        }

        void resetPendingToken(CharSequence surface, CharSequence reading, int startOffset, int endOffset) {
            if (this.pdgSurface == null) {
                this.pdgSurface = new CharsRefBuilder();
            } else {
                this.pdgSurface.clear();
            }
            this.pdgSurface.append(surface);
            if (this.pdgReading == null) {
                this.pdgReading = new CharsRefBuilder();
            } else {
                this.pdgReading.clear();
            }
            this.pdgReading.append(reading);
            this.pdgStartOffset = startOffset;
            this.pdgEndOffset = endOffset;
        }

        void clearPendingToken() {
            this.pdgSurface = null;
            this.pdgReading = null;
            this.pdgStartOffset = 0;
            this.pdgEndOffset = 0;
        }
    }

    private static class CompletionToken {
        final String term;
        final boolean isFirst;
        final int startOffset;
        final int endOffset;

        CompletionToken(String term, boolean isFirst, int startOffset, int endOffset) {
            this.term = term;
            this.isFirst = isFirst;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
        }
    }
}

