/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.cjk;

import java.util.Map;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.cjk.CJKBigramFilter;
import org.apache.lucene.analysis.util.TokenFilterFactory;

public class CJKBigramFilterFactory
extends TokenFilterFactory {
    int flags;
    boolean outputUnigrams;

    @Override
    public void init(Map<String, String> args) {
        super.init(args);
        this.flags = 0;
        if (this.getBoolean("han", true)) {
            this.flags |= 1;
        }
        if (this.getBoolean("hiragana", true)) {
            this.flags |= 2;
        }
        if (this.getBoolean("katakana", true)) {
            this.flags |= 4;
        }
        if (this.getBoolean("hangul", true)) {
            this.flags |= 8;
        }
        this.outputUnigrams = this.getBoolean("outputUnigrams", false);
    }

    @Override
    public TokenStream create(TokenStream input) {
        return new CJKBigramFilter(input, this.flags, this.outputUnigrams);
    }
}

