/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.snowball;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.miscellaneous.KeywordMarkerFilter;
import org.apache.lucene.analysis.snowball.SnowballFilter;
import org.apache.lucene.analysis.util.CharArraySet;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.apache.lucene.analysis.util.ResourceLoaderAware;
import org.apache.lucene.analysis.util.TokenFilterFactory;
import org.tartarus.snowball.SnowballProgram;

public class SnowballPorterFilterFactory
extends TokenFilterFactory
implements ResourceLoaderAware {
    public static final String PROTECTED_TOKENS = "protected";
    private String language = "English";
    private Class<?> stemClass;
    private CharArraySet protectedWords = null;

    @Override
    public void inform(ResourceLoader loader) throws IOException {
        String wordFiles = (String)this.args.get(PROTECTED_TOKENS);
        if (wordFiles != null) {
            this.protectedWords = this.getWordSet(loader, wordFiles, false);
        }
    }

    @Override
    public void init(Map<String, String> args) {
        super.init(args);
        String cfgLanguage = args.get("language");
        if (cfgLanguage != null) {
            this.language = cfgLanguage;
        }
        try {
            this.stemClass = Class.forName("org.tartarus.snowball.ext." + this.language + "Stemmer");
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Can't find class for stemmer language " + this.language, e);
        }
    }

    public TokenFilter create(TokenStream input) {
        SnowballProgram program;
        try {
            program = (SnowballProgram)this.stemClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Error instantiating stemmer for language " + this.language + "from class " + this.stemClass, e);
        }
        if (this.protectedWords != null) {
            input = new KeywordMarkerFilter((TokenStream)input, this.protectedWords);
        }
        return new SnowballFilter((TokenStream)input, program);
    }
}

