/* The following code was generated by JFlex 1.5.0-SNAPSHOT on 9/19/12 7:40 PM */

package org.apache.lucene.analysis.standard;

/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;

/**
 * This class implements Word Break rules from the Unicode Text Segmentation 
 * algorithm, as specified in 
 * <a href="http://unicode.org/reports/tr29/">Unicode Standard Annex #29</a>. 
 * <p/>
 * Tokens produced are of the following types:
 * <ul>
 *   <li>&lt;ALPHANUM&gt;: A sequence of alphabetic and numeric characters</li>
 *   <li>&lt;NUM&gt;: A number</li>
 *   <li>&lt;SOUTHEAST_ASIAN&gt;: A sequence of characters from South and Southeast
 *       Asian languages, including Thai, Lao, Myanmar, and Khmer</li>
 *   <li>&lt;IDEOGRAPHIC&gt;: A single CJKV ideographic character</li>
 *   <li>&lt;HIRAGANA&gt;: A single hiragana character</li>
 * </ul>
 */

public final class StandardTokenizerImpl implements StandardTokenizerInterface {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 4096;

  /** lexical states */
  public static final int YYINITIAL = 0;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = { 
     0, 0
  };

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\47\0\1\202\4\0\1\201\1\0\1\202\1\0\12\176\1\200\1\201"+
    "\5\0\32\174\4\0\1\203\1\0\32\174\57\0\1\174\2\0\1\175"+
    "\7\0\1\174\1\0\1\200\2\0\1\174\5\0\27\174\1\0\37\174"+
    "\1\0\u01ca\174\4\0\14\174\16\0\5\174\7\0\1\174\1\0\1\174"+
    "\21\0\160\175\5\174\1\0\2\174\2\0\4\174\1\201\7\0\1\174"+
    "\1\200\3\174\1\0\1\174\1\0\24\174\1\0\123\174\1\0\213\174"+
    "\1\0\7\175\236\174\11\0\46\174\2\0\1\174\7\0\47\174\1\0"+
    "\1\201\7\0\55\175\1\0\1\175\1\0\2\175\1\0\2\175\1\0"+
    "\1\175\10\0\33\174\5\0\4\174\1\200\13\0\5\175\7\0\2\201"+
    "\2\0\13\175\5\0\53\174\25\175\12\176\1\0\1\176\1\201\1\0"+
    "\2\174\1\175\143\174\1\0\1\174\7\175\1\175\1\0\6\175\2\174"+
    "\2\175\1\0\4\175\2\174\12\176\3\174\2\0\1\174\17\0\1\175"+
    "\1\174\1\175\36\174\33\175\2\0\131\174\13\175\1\174\16\0\12\176"+
    "\41\174\11\175\2\174\2\0\1\201\1\0\1\174\5\0\26\174\4\175"+
    "\1\174\11\175\1\174\3\175\1\174\5\175\22\0\31\174\3\175\104\0"+
    "\1\174\1\0\13\174\67\0\33\175\1\0\4\175\66\174\3\175\1\174"+
    "\22\175\1\174\7\175\12\174\2\175\2\0\12\176\1\0\7\174\1\0"+
    "\7\174\1\0\3\175\1\0\10\174\2\0\2\174\2\0\26\174\1\0"+
    "\7\174\1\0\1\174\3\0\4\174\2\0\1\175\1\174\7\175\2\0"+
    "\2\175\2\0\3\175\1\174\10\0\1\175\4\0\2\174\1\0\3\174"+
    "\2\175\2\0\12\176\2\174\17\0\3\175\1\0\6\174\4\0\2\174"+
    "\2\0\26\174\1\0\7\174\1\0\2\174\1\0\2\174\1\0\2\174"+
    "\2\0\1\175\1\0\5\175\4\0\2\175\2\0\3\175\3\0\1\175"+
    "\7\0\4\174\1\0\1\174\7\0\12\176\2\175\3\174\1\175\13\0"+
    "\3\175\1\0\11\174\1\0\3\174\1\0\26\174\1\0\7\174\1\0"+
    "\2\174\1\0\5\174\2\0\1\175\1\174\10\175\1\0\3\175\1\0"+
    "\3\175\2\0\1\174\17\0\2\174\2\175\2\0\12\176\21\0\3\175"+
    "\1\0\10\174\2\0\2\174\2\0\26\174\1\0\7\174\1\0\2\174"+
    "\1\0\5\174\2\0\1\175\1\174\7\175\2\0\2\175\2\0\3\175"+
    "\10\0\2\175\4\0\2\174\1\0\3\174\2\175\2\0\12\176\1\0"+
    "\1\174\20\0\1\175\1\174\1\0\6\174\3\0\3\174\1\0\4\174"+
    "\3\0\2\174\1\0\1\174\1\0\2\174\3\0\2\174\3\0\3\174"+
    "\3\0\14\174\4\0\5\175\3\0\3\175\1\0\4\175\2\0\1\174"+
    "\6\0\1\175\16\0\12\176\21\0\3\175\1\0\10\174\1\0\3\174"+
    "\1\0\27\174\1\0\12\174\1\0\5\174\3\0\1\174\7\175\1\0"+
    "\3\175\1\0\4\175\7\0\2\175\1\0\2\174\6\0\2\174\2\175"+
    "\2\0\12\176\22\0\2\175\1\0\10\174\1\0\3\174\1\0\27\174"+
    "\1\0\12\174\1\0\5\174\2\0\1\175\1\174\7\175\1\0\3\175"+
    "\1\0\4\175\7\0\2\175\7\0\1\174\1\0\2\174\2\175\2\0"+
    "\12\176\1\0\2\174\17\0\2\175\1\0\10\174\1\0\3\174\1\0"+
    "\51\174\2\0\1\174\7\175\1\0\3\175\1\0\4\175\1\174\10\0"+
    "\1\175\10\0\2\174\2\175\2\0\12\176\12\0\6\174\2\0\2\175"+
    "\1\0\22\174\3\0\30\174\1\0\11\174\1\0\1\174\2\0\7\174"+
    "\3\0\1\175\4\0\6\175\1\0\1\175\1\0\10\175\22\0\2\175"+
    "\15\0\60\204\1\205\2\204\7\205\5\0\7\204\10\205\1\0\12\176"+
    "\47\0\2\204\1\0\1\204\2\0\2\204\1\0\1\204\2\0\1\204"+
    "\6\0\4\204\1\0\7\204\1\0\3\204\1\0\1\204\1\0\1\204"+
    "\2\0\2\204\1\0\4\204\1\205\2\204\6\205\1\0\2\205\1\204"+
    "\2\0\5\204\1\0\1\204\1\0\6\205\2\0\12\176\2\0\4\204"+
    "\40\0\1\174\27\0\2\175\6\0\12\176\13\0\1\175\1\0\1\175"+
    "\1\0\1\175\4\0\2\175\10\174\1\0\44\174\4\0\24\175\1\0"+
    "\2\175\5\174\13\175\1\0\44\175\11\0\1\175\71\0\53\204\24\205"+
    "\1\204\12\176\6\0\6\204\4\205\4\204\3\205\1\204\3\205\2\204"+
    "\7\205\3\204\4\205\15\204\14\205\1\204\1\205\12\176\4\205\2\204"+
    "\46\174\1\0\1\174\5\0\1\174\2\0\53\174\1\0\4\174\u0100\210"+
    "\111\174\1\0\4\174\2\0\7\174\1\0\1\174\1\0\4\174\2\0"+
    "\51\174\1\0\4\174\2\0\41\174\1\0\4\174\2\0\7\174\1\0"+
    "\1\174\1\0\4\174\2\0\17\174\1\0\71\174\1\0\4\174\2\0"+
    "\103\174\2\0\3\175\40\0\20\174\20\0\125\174\14\0\u026c\174\2\0"+
    "\21\174\1\0\32\174\5\0\113\174\3\0\3\174\17\0\15\174\1\0"+
    "\4\174\3\175\13\0\22\174\3\175\13\0\22\174\2\175\14\0\15\174"+
    "\1\0\3\174\1\0\2\175\14\0\64\204\40\205\3\0\1\204\4\0"+
    "\1\204\1\205\2\0\12\176\41\0\3\175\2\0\12\176\6\0\130\174"+
    "\10\0\51\174\1\175\1\174\5\0\106\174\12\0\35\174\3\0\14\175"+
    "\4\0\14\175\12\0\12\176\36\204\2\0\5\204\13\0\54\204\4\0"+
    "\21\205\7\204\2\205\6\0\12\176\1\204\3\0\2\204\40\0\27\174"+
    "\5\175\4\0\65\204\12\205\1\0\35\205\2\0\1\175\12\176\6\0"+
    "\12\176\6\0\16\204\122\0\5\175\57\174\21\175\7\174\4\0\12\176"+
    "\21\0\11\175\14\0\3\175\36\174\15\175\2\174\12\176\54\174\16\175"+
    "\14\0\44\174\24\175\10\0\12\176\3\0\3\174\12\176\44\174\122\0"+
    "\3\175\1\0\25\175\4\174\1\175\4\174\3\175\2\174\11\0\300\174"+
    "\47\175\25\0\4\175\u0116\174\2\0\6\174\2\0\46\174\2\0\6\174"+
    "\2\0\10\174\1\0\1\174\1\0\1\174\1\0\1\174\1\0\37\174"+
    "\2\0\65\174\1\0\7\174\1\0\1\174\3\0\3\174\1\0\7\174"+
    "\3\0\4\174\2\0\6\174\4\0\15\174\5\0\3\174\1\0\7\174"+
    "\17\0\2\175\2\175\10\0\2\202\12\0\1\202\2\0\1\200\2\0"+
    "\5\175\20\0\2\203\3\0\1\201\17\0\1\203\13\0\5\175\5\0"+
    "\6\175\1\0\1\174\15\0\1\174\20\0\15\174\63\0\41\175\21\0"+
    "\1\174\4\0\1\174\2\0\12\174\1\0\1\174\3\0\5\174\6\0"+
    "\1\174\1\0\1\174\1\0\1\174\1\0\4\174\1\0\13\174\2\0"+
    "\4\174\5\0\5\174\4\0\1\174\21\0\51\174\u032d\0\64\174\u0716\0"+
    "\57\174\1\0\57\174\1\0\205\174\6\0\4\174\3\175\2\174\14\0"+
    "\46\174\1\0\1\174\5\0\1\174\2\0\70\174\7\0\1\174\17\0"+
    "\1\175\27\174\11\0\7\174\1\0\7\174\1\0\7\174\1\0\7\174"+
    "\1\0\7\174\1\0\7\174\1\0\7\174\1\0\7\174\1\0\40\175"+
    "\57\0\1\174\120\0\32\206\1\0\131\206\14\0\326\206\57\0\1\174"+
    "\1\0\1\206\31\0\11\206\4\175\2\175\1\0\5\177\2\0\3\206"+
    "\1\174\1\174\4\0\126\207\2\0\2\175\2\177\3\207\133\177\1\0"+
    "\4\177\5\0\51\174\3\0\136\210\21\0\33\174\65\0\20\177\37\0"+
    "\101\0\37\0\121\0\57\177\1\0\130\177\250\0\u19b6\206\112\0\u51cd\206"+
    "\63\0\u048d\174\103\0\56\174\2\0\u010d\174\3\0\20\174\12\176\2\174"+
    "\24\0\57\174\4\175\1\0\12\175\1\0\31\174\7\0\1\175\120\174"+
    "\2\175\45\0\11\174\2\0\147\174\2\0\4\174\1\0\4\174\14\0"+
    "\13\174\115\0\12\174\1\175\3\174\1\175\4\174\1\175\27\174\5\175"+
    "\30\0\64\174\14\0\2\175\62\174\21\175\13\0\12\176\6\0\22\175"+
    "\6\174\3\0\1\174\4\0\12\176\34\174\10\175\2\0\27\174\15\175"+
    "\14\0\35\210\3\0\4\175\57\174\16\175\16\0\1\174\12\176\46\0"+
    "\51\174\16\175\11\0\3\174\1\175\10\174\2\175\2\0\12\176\6\0"+
    "\33\204\1\205\4\0\60\204\1\205\1\204\3\205\2\204\2\205\5\204"+
    "\2\205\1\204\1\205\1\204\30\0\5\204\13\174\5\175\2\0\3\174"+
    "\2\175\12\0\6\174\2\0\6\174\2\0\6\174\11\0\7\174\1\0"+
    "\7\174\221\0\43\174\10\175\1\0\2\175\2\0\12\176\6\0\u2ba4\210"+
    "\14\0\27\210\4\0\61\210\4\0\1\44\1\40\1\67\1\64\1\33"+
    "\1\30\2\0\1\24\1\21\2\0\1\17\1\15\14\0\1\3\1\6"+
    "\20\0\1\156\7\0\1\111\1\10\5\0\1\1\1\172\3\0\1\163"+
    "\1\163\1\163\1\163\1\163\1\163\1\163\1\163\1\163\1\163\1\163"+
    "\1\163\1\163\1\163\1\163\1\163\1\163\1\163\1\163\1\163\1\163"+
    "\1\163\1\163\1\163\1\163\1\163\1\163\1\163\1\163\1\163\1\163"+
    "\1\163\1\163\1\163\1\163\1\163\1\163\1\163\1\163\1\163\1\163"+
    "\1\164\1\163\1\163\1\163\1\170\1\166\17\0\1\160\u02c1\0\1\114"+
    "\277\0\1\157\1\115\1\16\3\167\2\62\1\167\1\62\2\167\1\36"+
    "\21\167\2\106\7\117\1\116\7\117\7\102\1\37\1\102\1\130\2\66"+
    "\1\65\1\130\1\66\1\65\10\130\2\107\5\103\2\75\5\103\1\22"+
    "\10\53\5\23\3\41\12\147\20\41\3\63\32\43\1\42\2\61\2\154"+
    "\1\155\2\154\2\155\2\154\1\155\3\61\1\60\2\61\12\110\1\126"+
    "\1\50\1\45\1\110\6\50\1\45\13\50\31\61\7\50\12\150\1\50"+
    "\5\13\3\127\3\101\1\100\4\101\2\100\10\101\1\100\7\35\1\34"+
    "\2\35\7\101\16\127\1\141\4\152\1\4\4\151\1\4\5\140\1\137"+
    "\1\140\3\137\7\140\1\137\23\140\5\113\3\140\6\113\2\113\6\112"+
    "\5\112\3\134\2\101\7\133\36\101\4\133\5\101\5\127\6\125\2\127"+
    "\1\125\4\35\13\136\12\151\26\136\15\13\1\135\2\13\1\173\3\142"+
    "\1\13\2\142\5\161\4\142\4\162\1\161\3\162\1\161\5\162\2\70"+
    "\1\73\2\70\1\73\1\70\2\73\1\70\1\73\12\70\1\73\4\5"+
    "\1\144\1\143\1\145\1\12\3\165\1\145\2\165\1\131\2\132\2\165"+
    "\1\12\1\165\1\12\1\165\1\12\1\165\3\12\1\165\2\12\1\165"+
    "\1\12\2\165\1\12\1\165\1\12\1\165\1\12\1\165\1\12\1\165"+
    "\1\12\1\76\2\72\1\76\1\72\2\76\4\72\1\76\7\72\1\76"+
    "\4\72\1\76\4\72\1\165\1\12\1\165\12\31\1\57\21\31\1\57"+
    "\3\32\1\57\3\31\1\57\1\31\2\2\2\31\1\57\15\124\4\47"+
    "\4\54\1\146\1\56\10\146\7\54\6\165\4\25\1\27\37\25\1\27"+
    "\4\25\25\105\1\171\11\105\21\26\5\105\1\7\12\55\5\105\6\104"+
    "\4\76\1\77\1\26\5\123\12\121\17\123\1\74\3\71\14\120\1\11"+
    "\11\46\1\52\5\46\4\122\13\51\2\14\11\46\1\52\31\46\1\52"+
    "\4\11\4\46\2\52\2\153\1\20\5\153\52\20\u1900\0\u016e\206\2\0"+
    "\152\206\46\0\7\174\14\0\5\174\5\0\1\174\1\175\12\174\1\0"+
    "\15\174\1\0\5\174\1\0\1\174\1\0\2\174\1\0\2\174\1\0"+
    "\154\174\41\0\u016b\174\22\0\100\174\2\0\66\174\50\0\14\174\4\0"+
    "\20\175\1\201\2\0\1\200\1\201\13\0\7\175\14\0\2\203\30\0"+
    "\3\203\1\201\1\0\1\202\1\0\1\201\1\200\32\0\5\174\1\0"+
    "\207\174\2\0\1\175\7\0\1\202\4\0\1\201\1\0\1\202\1\0"+
    "\12\176\1\200\1\201\5\0\32\174\4\0\1\203\1\0\32\174\13\0"+
    "\70\177\2\175\37\210\3\0\6\210\2\0\6\210\2\0\6\210\2\0"+
    "\3\210\34\0\3\175\4\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\1\0\26\1\1\2\1\3\1\4\1\1\1\5\1\6"+
    "\1\7\1\10\20\0\1\2\1\0\1\2\12\0\1\3"+
    "\21\0\1\2\115\0";

  private static int [] zzUnpackAction() {
    int [] result = new int[156];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** 
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\211\0\u0112\0\u019b\0\u0224\0\u02ad\0\u0336\0\u03bf"+
    "\0\u0448\0\u04d1\0\u055a\0\u05e3\0\u066c\0\u06f5\0\u077e\0\u0807"+
    "\0\u0890\0\u0919\0\u09a2\0\u0a2b\0\u0ab4\0\u0b3d\0\u0bc6\0\u0c4f"+
    "\0\u0cd8\0\u0d61\0\u0dea\0\u0e73\0\u0efc\0\u0f85\0\u100e\0\u0112"+
    "\0\u019b\0\u1097\0\u1120\0\u0336\0\u03bf\0\u0448\0\u04d1\0\u11a9"+
    "\0\u1232\0\u12bb\0\u1344\0\u077e\0\u13cd\0\u1456\0\u14df\0\u1568"+
    "\0\u15f1\0\u167a\0\u1703\0\u02ad\0\u178c\0\u1815\0\u066c\0\u189e"+
    "\0\u1927\0\u19b0\0\u1a39\0\u1ac2\0\u1b4b\0\u1bd4\0\u1c5d\0\u1ce6"+
    "\0\u1d6f\0\u1df8\0\u1e81\0\u1f0a\0\u1f93\0\u201c\0\u20a5\0\u212e"+
    "\0\u21b7\0\u2240\0\u22c9\0\u2352\0\u23db\0\u0dea\0\u2464\0\u24ed"+
    "\0\u2576\0\u25ff\0\u2688\0\u2711\0\u279a\0\u2823\0\u28ac\0\u2935"+
    "\0\u29be\0\u2a47\0\u2ad0\0\u2b59\0\u2be2\0\u2c6b\0\u2cf4\0\u2d7d"+
    "\0\u2e06\0\u2e8f\0\u2f18\0\u2fa1\0\u302a\0\u30b3\0\u313c\0\u31c5"+
    "\0\u324e\0\u32d7\0\u3360\0\u33e9\0\u3472\0\u34fb\0\u3584\0\u360d"+
    "\0\u3696\0\u371f\0\u37a8\0\u3831\0\u38ba\0\u3943\0\u39cc\0\u3a55"+
    "\0\u3ade\0\u3b67\0\u3bf0\0\u3c79\0\u3d02\0\u3d8b\0\u3e14\0\u3e9d"+
    "\0\u3f26\0\u3faf\0\u4038\0\u40c1\0\u414a\0\u41d3\0\u425c\0\u42e5"+
    "\0\u436e\0\u43f7\0\u4480\0\u4509\0\u4592\0\u461b\0\u46a4\0\u472d"+
    "\0\u47b6\0\u483f\0\u48c8\0\u4951\0\u49da\0\u4a63\0\u4aec\0\u4b75"+
    "\0\u4bfe\0\u4c87\0\u4d10\0\u4d99";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[156];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /** 
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\2\1\3\1\2\1\4\2\2\1\5\1\2\1\6"+
    "\4\2\1\7\1\2\1\10\1\2\1\11\2\2\1\12"+
    "\3\2\1\13\2\2\1\14\4\2\1\15\3\2\1\16"+
    "\17\2\1\17\2\2\1\20\66\2\1\21\1\2\1\22"+
    "\2\2\1\23\1\24\1\2\1\25\1\2\1\26\1\2"+
    "\1\27\1\2\1\30\1\2\1\31\1\32\3\2\1\33"+
    "\2\34\1\35\1\36\1\37\213\0\1\30\2\0\1\30"+
    "\4\0\1\30\16\0\1\30\15\0\1\30\20\0\1\30"+
    "\1\0\1\30\31\0\1\30\4\0\1\30\10\0\2\30"+
    "\15\0\2\30\10\0\1\30\21\0\2\30\5\0\1\30"+
    "\2\0\1\30\3\0\2\30\10\0\4\30\1\0\3\30"+
    "\1\0\1\30\2\0\1\30\2\0\1\30\4\0\4\30"+
    "\1\0\2\30\1\0\1\30\2\0\1\30\1\0\1\30"+
    "\2\0\4\30\2\0\3\30\1\0\2\30\1\0\3\30"+
    "\5\0\4\30\2\0\10\30\1\0\1\30\2\0\4\30"+
    "\1\0\2\30\1\0\1\30\1\0\2\30\4\0\1\30"+
    "\3\0\1\30\24\0\1\30\4\0\1\30\11\0\1\30"+
    "\22\0\1\30\3\0\1\30\27\0\1\30\63\0\1\30"+
    "\24\0\1\30\3\0\4\30\1\0\1\30\1\0\1\31"+
    "\2\0\1\30\1\0\2\30\2\0\2\30\2\0\3\30"+
    "\1\0\1\30\1\0\1\30\2\0\4\30\1\0\3\30"+
    "\1\0\1\30\1\0\3\30\1\0\2\30\1\0\4\30"+
    "\1\0\2\30\2\0\10\30\1\0\2\30\1\0\11\30"+
    "\1\0\10\30\1\0\13\30\1\31\1\0\1\30\1\0"+
    "\1\30\1\0\2\30\2\0\1\30\1\0\1\30\3\0"+
    "\1\30\33\0\1\30\17\0\1\30\23\0\1\30\23\0"+
    "\1\30\6\0\3\30\37\0\1\30\7\0\1\30\23\0"+
    "\1\30\1\0\2\30\1\0\1\30\1\0\4\30\1\0"+
    "\1\30\1\0\1\30\1\0\2\30\1\0\3\30\1\0"+
    "\2\30\1\0\4\30\1\0\3\30\1\0\17\30\1\0"+
    "\2\30\1\0\21\30\1\0\2\30\1\0\41\30\1\0"+
    "\1\30\1\0\2\30\2\0\1\30\1\0\1\30\1\0"+
    "\1\30\1\0\1\30\33\0\1\30\3\0\2\30\12\0"+
    "\2\30\13\0\1\30\6\0\1\30\2\0\2\30\6\0"+
    "\1\30\4\0\2\30\2\0\2\30\5\0\3\30\10\0"+
    "\1\30\26\0\1\30\7\0\1\30\23\0\1\30\1\0"+
    "\2\30\1\0\1\30\2\0\2\30\2\0\1\30\3\0"+
    "\2\30\1\0\3\30\1\0\2\30\1\0\4\30\1\0"+
    "\3\30\1\0\1\30\1\0\2\30\2\0\11\30\1\0"+
    "\2\30\1\0\1\30\1\0\2\30\1\0\14\30\1\0"+
    "\2\30\1\0\3\30\1\0\1\30\1\0\30\30\1\0"+
    "\2\30\1\0\1\30\1\0\2\30\2\0\1\30\1\0"+
    "\1\30\1\0\1\30\1\0\1\30\17\0\1\30\26\0"+
    "\2\30\23\0\1\31\1\30\66\0\1\31\46\0\1\31"+
    "\27\0\4\30\2\0\2\30\14\0\3\30\15\0\3\30"+
    "\3\0\1\30\7\0\2\30\13\0\1\30\13\0\4\31"+
    "\1\0\2\30\11\0\1\30\37\0\1\30\3\0\2\30"+
    "\12\0\2\30\1\0\3\30\7\0\1\30\6\0\2\30"+
    "\1\0\2\30\6\0\1\30\4\0\2\30\2\0\2\30"+
    "\5\0\3\30\10\0\1\30\16\0\1\30\4\0\2\31"+
    "\1\0\1\30\7\0\1\30\23\0\1\30\4\0\1\30"+
    "\6\0\1\30\3\0\1\30\6\0\1\30\5\0\1\30"+
    "\2\0\2\30\1\0\17\30\2\0\1\30\13\0\7\30"+
    "\2\0\1\30\1\0\1\30\1\0\1\30\2\0\1\30"+
    "\1\0\1\30\1\0\1\30\1\0\1\30\6\0\2\30"+
    "\5\0\1\30\1\0\1\30\2\0\3\30\1\0\1\30"+
    "\7\0\1\30\1\0\1\30\35\0\1\30\17\0\2\30"+
    "\22\0\1\30\2\0\2\30\13\0\1\30\3\0\2\30"+
    "\5\0\3\30\10\0\1\30\26\0\1\30\7\0\1\30"+
    "\30\0\1\30\6\0\1\30\3\0\1\30\3\0\1\30"+
    "\7\0\1\30\31\0\20\30\5\0\3\30\3\0\1\30"+
    "\3\0\2\30\2\0\2\30\4\0\1\30\10\0\1\30"+
    "\4\0\1\30\2\0\1\30\4\0\1\30\1\0\1\30"+
    "\1\0\1\30\132\0\1\36\41\0\1\32\35\0\1\35"+
    "\6\0\1\35\2\0\1\35\3\0\2\35\10\0\4\35"+
    "\1\0\3\35\1\0\1\35\2\0\1\35\2\0\1\35"+
    "\4\0\4\35\1\0\2\35\6\0\1\35\2\0\4\35"+
    "\2\0\3\35\1\0\2\35\1\0\3\35\5\0\4\35"+
    "\2\0\10\35\4\0\4\35\1\0\2\35\1\0\1\35"+
    "\1\0\2\35\4\0\1\35\3\0\1\35\17\0\1\35"+
    "\1\0\2\35\1\0\1\35\1\0\4\35\1\0\1\35"+
    "\1\0\1\35\1\0\2\35\1\0\3\35\1\0\2\35"+
    "\1\0\4\35\1\0\3\35\1\0\17\35\1\0\2\35"+
    "\1\0\21\35\1\0\2\35\1\0\41\35\1\0\1\35"+
    "\1\0\2\35\2\0\1\35\1\0\1\35\1\0\1\35"+
    "\1\0\1\35\17\0\1\35\1\0\2\35\1\0\1\35"+
    "\1\0\4\35\1\0\1\35\1\0\1\35\1\0\2\35"+
    "\2\0\1\35\2\0\2\35\1\0\4\35\1\0\3\35"+
    "\1\0\17\35\1\0\2\35\1\0\21\35\1\0\2\35"+
    "\1\0\41\35\1\0\1\35\1\0\2\35\2\0\1\35"+
    "\1\0\1\35\1\0\1\35\1\0\1\35\33\0\1\35"+
    "\17\0\1\35\23\0\1\35\32\0\1\35\41\0\1\35"+
    "\7\0\1\35\23\0\1\35\1\0\2\35\3\0\4\35"+
    "\1\0\1\35\1\0\1\35\1\0\2\35\1\0\3\35"+
    "\1\0\2\35\1\0\4\35\1\0\3\35\1\0\10\35"+
    "\1\0\6\35\1\0\2\35\1\0\21\35\1\0\2\35"+
    "\1\0\41\35\1\0\1\35\1\0\2\35\2\0\1\35"+
    "\1\0\1\35\1\0\1\35\1\0\1\35\210\0\1\36"+
    "\16\0\1\40\1\0\1\41\2\0\1\42\1\0\1\43"+
    "\4\0\1\44\1\0\1\45\1\0\1\46\2\0\1\47"+
    "\3\0\1\50\2\0\1\51\4\0\1\52\3\0\1\53"+
    "\17\0\1\54\2\0\1\55\21\0\1\56\2\0\1\57"+
    "\57\0\2\30\1\60\1\0\1\61\1\0\1\61\1\62"+
    "\1\0\1\30\2\0\1\30\1\0\1\40\1\0\1\41"+
    "\2\0\1\63\1\0\1\64\4\0\1\44\1\0\1\45"+
    "\1\0\1\46\2\0\1\47\3\0\1\65\2\0\1\66"+
    "\4\0\1\67\3\0\1\70\17\0\1\54\2\0\1\71"+
    "\21\0\1\72\2\0\1\73\57\0\1\30\2\31\2\0"+
    "\2\74\1\75\1\0\1\31\2\0\1\30\6\0\1\76"+
    "\21\0\1\77\2\0\1\100\10\0\1\101\22\0\1\102"+
    "\21\0\1\103\2\0\1\104\41\0\1\105\16\0\1\32"+
    "\1\0\1\32\3\0\1\62\1\0\1\32\4\0\1\40"+
    "\1\0\1\41\2\0\1\106\1\0\1\64\4\0\1\44"+
    "\1\0\1\45\1\0\1\46\2\0\1\47\3\0\1\107"+
    "\2\0\1\110\4\0\1\67\3\0\1\111\17\0\1\54"+
    "\2\0\1\112\21\0\1\113\2\0\1\114\41\0\1\115"+
    "\15\0\1\30\1\116\1\31\1\117\3\0\1\116\1\0"+
    "\1\116\2\0\1\30\204\0\2\34\11\0\1\120\21\0"+
    "\1\121\2\0\1\122\10\0\1\123\22\0\1\124\21\0"+
    "\1\125\2\0\1\126\60\0\1\35\7\0\1\35\11\0"+
    "\1\127\21\0\1\130\2\0\1\131\10\0\1\132\22\0"+
    "\1\133\21\0\1\134\2\0\1\135\60\0\1\36\7\0"+
    "\1\36\4\0\1\40\1\0\1\41\2\0\1\136\1\0"+
    "\1\43\4\0\1\44\1\0\1\45\1\0\1\46\2\0"+
    "\1\47\3\0\1\137\2\0\1\140\4\0\1\52\3\0"+
    "\1\141\17\0\1\54\2\0\1\142\21\0\1\143\2\0"+
    "\1\144\57\0\1\30\1\37\1\60\1\0\1\61\1\0"+
    "\1\61\1\62\1\0\1\37\2\0\1\37\7\0\1\30"+
    "\4\0\1\30\11\0\1\30\22\0\1\30\3\0\1\30"+
    "\13\0\1\30\2\0\1\30\10\0\1\30\12\0\4\30"+
    "\45\0\1\30\24\0\1\30\3\0\4\30\1\0\1\30"+
    "\1\0\1\60\2\0\1\30\1\0\2\30\2\0\2\30"+
    "\2\0\3\30\1\0\1\30\1\0\1\30\2\0\4\30"+
    "\1\0\3\30\1\0\1\30\1\0\3\30\1\0\2\30"+
    "\1\0\4\30\1\0\2\30\2\0\10\30\1\0\2\30"+
    "\1\0\11\30\1\0\10\30\1\0\13\30\1\60\1\0"+
    "\1\30\1\0\1\30\1\0\2\30\2\0\1\30\1\0"+
    "\1\30\3\0\1\30\17\0\1\30\26\0\2\30\23\0"+
    "\1\60\1\30\44\0\1\30\21\0\1\60\46\0\1\60"+
    "\11\0\1\30\15\0\4\30\2\0\2\30\14\0\4\30"+
    "\1\0\2\30\11\0\3\30\3\0\1\30\1\0\1\30"+
    "\4\0\3\30\5\0\4\30\2\0\2\30\12\0\4\60"+
    "\1\0\2\30\1\0\1\30\7\0\1\30\37\0\1\30"+
    "\3\0\2\30\12\0\2\30\1\0\3\30\7\0\1\30"+
    "\6\0\2\30\1\0\2\30\6\0\1\30\4\0\2\30"+
    "\2\0\2\30\5\0\3\30\10\0\1\30\16\0\1\30"+
    "\4\0\2\60\1\0\1\30\7\0\1\30\23\0\1\30"+
    "\4\0\1\30\6\0\1\30\3\0\1\30\6\0\1\30"+
    "\5\0\1\30\2\0\2\30\1\0\17\30\2\0\1\30"+
    "\13\0\7\30\2\0\1\30\1\0\1\30\1\0\1\30"+
    "\2\0\1\30\1\0\1\30\1\0\1\30\1\0\1\30"+
    "\4\0\1\30\1\0\2\30\5\0\1\30\1\0\1\30"+
    "\2\0\3\30\1\0\1\30\7\0\1\30\1\0\1\30"+
    "\26\0\1\30\6\0\1\30\3\0\1\30\3\0\1\30"+
    "\7\0\1\30\31\0\20\30\5\0\3\30\3\0\1\30"+
    "\3\0\2\30\2\0\2\30\4\0\5\30\4\0\1\30"+
    "\4\0\1\30\2\0\1\30\4\0\1\30\1\0\1\30"+
    "\1\0\1\30\127\0\2\30\15\0\4\30\60\0\1\30"+
    "\15\0\2\30\10\0\2\30\1\0\1\30\1\0\1\30"+
    "\11\0\1\30\11\0\2\30\6\0\1\30\2\0\4\30"+
    "\3\0\1\30\2\0\2\30\1\0\3\30\5\0\1\30"+
    "\1\0\2\30\2\0\2\30\1\0\4\30\5\0\1\30"+
    "\1\0\2\30\37\0\1\40\1\0\1\41\2\0\1\145"+
    "\1\0\1\43\4\0\1\44\1\0\1\45\1\0\1\46"+
    "\2\0\1\47\3\0\1\146\2\0\1\147\4\0\1\52"+
    "\3\0\1\150\17\0\1\54\2\0\1\151\21\0\1\152"+
    "\2\0\1\153\57\0\1\30\2\60\2\0\2\154\1\62"+
    "\1\0\1\60\2\0\1\30\1\0\1\40\1\0\1\41"+
    "\2\0\1\155\1\0\1\156\4\0\1\44\1\0\1\45"+
    "\1\0\1\46\2\0\1\47\3\0\1\157\2\0\1\160"+
    "\4\0\1\161\3\0\1\162\17\0\1\54\2\0\1\163"+
    "\21\0\1\164\2\0\1\165\57\0\1\30\1\61\7\0"+
    "\1\61\2\0\1\30\1\0\1\40\1\0\1\41\2\0"+
    "\1\166\1\0\1\43\4\0\1\44\1\0\1\45\1\0"+
    "\1\46\2\0\1\47\3\0\1\167\2\0\1\170\4\0"+
    "\1\52\3\0\1\171\17\0\1\54\2\0\1\172\21\0"+
    "\1\173\2\0\1\174\41\0\1\115\15\0\1\30\1\62"+
    "\1\60\1\117\3\0\1\62\1\0\1\62\2\0\1\30"+
    "\7\0\1\30\4\0\1\30\11\0\1\30\22\0\1\30"+
    "\3\0\1\30\13\0\1\31\2\0\1\31\10\0\1\30"+
    "\12\0\4\31\45\0\1\30\21\0\1\30\26\0\2\30"+
    "\23\0\1\31\1\30\44\0\1\31\21\0\1\31\46\0"+
    "\1\31\11\0\1\31\15\0\4\30\2\0\2\30\14\0"+
    "\3\30\1\31\1\0\2\31\11\0\3\30\3\0\1\30"+
    "\1\0\1\31\4\0\1\31\2\30\5\0\4\31\2\0"+
    "\1\30\1\31\12\0\4\31\1\0\2\30\1\0\1\31"+
    "\7\0\1\30\23\0\1\30\4\0\1\30\6\0\1\30"+
    "\3\0\1\30\6\0\1\30\5\0\1\30\2\0\2\30"+
    "\1\0\17\30\2\0\1\30\13\0\7\30\2\0\1\30"+
    "\1\0\1\30\1\0\1\30\2\0\1\30\1\0\1\30"+
    "\1\0\1\30\1\0\1\30\4\0\1\31\1\0\2\30"+
    "\5\0\1\30\1\0\1\30\2\0\3\30\1\0\1\30"+
    "\7\0\1\30\1\0\1\30\26\0\1\30\6\0\1\30"+
    "\3\0\1\30\3\0\1\30\7\0\1\30\31\0\20\30"+
    "\5\0\3\30\3\0\1\30\3\0\2\30\2\0\2\30"+
    "\4\0\1\30\4\31\4\0\1\30\4\0\1\30\2\0"+
    "\1\30\4\0\1\30\1\0\1\30\1\0\1\30\127\0"+
    "\2\31\15\0\4\31\60\0\1\31\15\0\2\31\10\0"+
    "\2\31\1\0\1\31\1\0\1\31\11\0\1\31\11\0"+
    "\2\31\6\0\1\31\2\0\4\31\3\0\1\31\2\0"+
    "\2\31\1\0\3\31\5\0\1\31\1\0\2\31\2\0"+
    "\2\31\1\0\4\31\5\0\1\31\1\0\2\31\44\0"+
    "\1\175\1\0\1\176\17\0\1\177\2\0\1\200\4\0"+
    "\1\201\3\0\1\202\22\0\1\203\21\0\1\204\2\0"+
    "\1\205\60\0\1\74\1\31\6\0\1\74\4\0\1\40"+
    "\1\0\1\41\2\0\1\206\1\0\1\64\4\0\1\44"+
    "\1\0\1\45\1\0\1\46\2\0\1\47\3\0\1\207"+
    "\2\0\1\210\4\0\1\67\3\0\1\211\17\0\1\54"+
    "\2\0\1\212\21\0\1\213\2\0\1\214\41\0\1\115"+
    "\15\0\1\30\1\75\1\31\1\117\3\0\1\75\1\0"+
    "\1\75\2\0\1\30\71\0\1\32\2\0\1\32\23\0"+
    "\4\32\211\0\1\32\102\0\1\32\44\0\1\32\1\0"+
    "\2\32\21\0\1\32\4\0\1\32\7\0\4\32\3\0"+
    "\1\32\22\0\1\32\166\0\1\32\215\0\4\32\155\0"+
    "\2\32\15\0\4\32\60\0\1\32\15\0\2\32\10\0"+
    "\2\32\1\0\1\32\1\0\1\32\11\0\1\32\11\0"+
    "\2\32\6\0\1\32\2\0\4\32\3\0\1\32\2\0"+
    "\2\32\1\0\3\32\5\0\1\32\1\0\2\32\2\0"+
    "\2\32\1\0\4\32\5\0\1\32\1\0\2\32\215\0"+
    "\1\32\40\0\1\30\4\0\1\30\11\0\1\30\22\0"+
    "\1\30\3\0\1\30\13\0\1\116\2\0\1\116\10\0"+
    "\1\30\12\0\4\116\45\0\1\30\21\0\1\30\26\0"+
    "\2\30\23\0\1\31\1\30\44\0\1\116\21\0\1\31"+
    "\46\0\1\31\11\0\1\116\15\0\4\30\2\0\2\30"+
    "\14\0\3\30\1\116\1\0\2\116\11\0\3\30\3\0"+
    "\1\30\1\0\1\116\4\0\1\116\2\30\5\0\4\116"+
    "\2\0\1\30\1\116\12\0\4\31\1\0\2\30\1\0"+
    "\1\116\7\0\1\30\23\0\1\30\4\0\1\30\6\0"+
    "\1\30\3\0\1\30\6\0\1\30\5\0\1\30\2\0"+
    "\2\30\1\0\17\30\2\0\1\30\13\0\7\30\2\0"+
    "\1\30\1\0\1\30\1\0\1\30\2\0\1\30\1\0"+
    "\1\30\1\0\1\30\1\0\1\30\4\0\1\116\1\0"+
    "\2\30\5\0\1\30\1\0\1\30\2\0\3\30\1\0"+
    "\1\30\7\0\1\30\1\0\1\30\26\0\1\30\6\0"+
    "\1\30\3\0\1\30\3\0\1\30\7\0\1\30\31\0"+
    "\20\30\5\0\3\30\3\0\1\30\3\0\2\30\2\0"+
    "\2\30\4\0\1\30\4\116\4\0\1\30\4\0\1\30"+
    "\2\0\1\30\4\0\1\30\1\0\1\30\1\0\1\30"+
    "\127\0\2\116\15\0\4\116\60\0\1\116\15\0\2\116"+
    "\10\0\2\116\1\0\1\116\1\0\1\116\11\0\1\116"+
    "\11\0\2\116\6\0\1\116\2\0\4\116\3\0\1\116"+
    "\2\0\2\116\1\0\3\116\5\0\1\116\1\0\2\116"+
    "\2\0\2\116\1\0\4\116\5\0\1\116\1\0\2\116"+
    "\215\0\1\117\37\0\1\215\21\0\1\216\2\0\1\217"+
    "\10\0\1\220\22\0\1\221\21\0\1\222\2\0\1\223"+
    "\41\0\1\115\16\0\1\117\1\0\1\117\3\0\1\62"+
    "\1\0\1\117\74\0\1\35\2\0\1\35\23\0\4\35"+
    "\211\0\1\35\102\0\1\35\44\0\1\35\1\0\2\35"+
    "\21\0\1\35\4\0\1\35\7\0\4\35\3\0\1\35"+
    "\22\0\1\35\166\0\1\35\215\0\4\35\155\0\2\35"+
    "\15\0\4\35\60\0\1\35\15\0\2\35\10\0\2\35"+
    "\1\0\1\35\1\0\1\35\11\0\1\35\11\0\2\35"+
    "\6\0\1\35\2\0\4\35\3\0\1\35\2\0\2\35"+
    "\1\0\3\35\5\0\1\35\1\0\2\35\2\0\2\35"+
    "\1\0\4\35\5\0\1\35\1\0\2\35\127\0\1\36"+
    "\2\0\1\36\23\0\4\36\211\0\1\36\102\0\1\36"+
    "\44\0\1\36\1\0\2\36\21\0\1\36\4\0\1\36"+
    "\7\0\4\36\3\0\1\36\22\0\1\36\166\0\1\36"+
    "\215\0\4\36\155\0\2\36\15\0\4\36\60\0\1\36"+
    "\15\0\2\36\10\0\2\36\1\0\1\36\1\0\1\36"+
    "\11\0\1\36\11\0\2\36\6\0\1\36\2\0\4\36"+
    "\3\0\1\36\2\0\2\36\1\0\3\36\5\0\1\36"+
    "\1\0\2\36\2\0\2\36\1\0\4\36\5\0\1\36"+
    "\1\0\2\36\45\0\1\30\4\0\1\30\11\0\1\30"+
    "\22\0\1\30\3\0\1\30\13\0\1\37\2\0\1\37"+
    "\10\0\1\30\12\0\4\37\45\0\1\30\21\0\1\30"+
    "\26\0\2\30\23\0\1\60\1\30\44\0\1\37\21\0"+
    "\1\60\46\0\1\60\11\0\1\37\15\0\4\30\2\0"+
    "\2\30\14\0\3\30\1\37\1\0\2\37\11\0\3\30"+
    "\3\0\1\30\1\0\1\37\4\0\1\37\2\30\5\0"+
    "\4\37\2\0\1\30\1\37\12\0\4\60\1\0\2\30"+
    "\1\0\1\37\7\0\1\30\23\0\1\30\4\0\1\30"+
    "\6\0\1\30\3\0\1\30\6\0\1\30\5\0\1\30"+
    "\2\0\2\30\1\0\17\30\2\0\1\30\13\0\7\30"+
    "\2\0\1\30\1\0\1\30\1\0\1\30\2\0\1\30"+
    "\1\0\1\30\1\0\1\30\1\0\1\30\4\0\1\37"+
    "\1\0\2\30\5\0\1\30\1\0\1\30\2\0\3\30"+
    "\1\0\1\30\7\0\1\30\1\0\1\30\26\0\1\30"+
    "\6\0\1\30\3\0\1\30\3\0\1\30\7\0\1\30"+
    "\31\0\20\30\5\0\3\30\3\0\1\30\3\0\2\30"+
    "\2\0\2\30\4\0\1\30\4\37\4\0\1\30\4\0"+
    "\1\30\2\0\1\30\4\0\1\30\1\0\1\30\1\0"+
    "\1\30\127\0\2\37\15\0\4\37\60\0\1\37\15\0"+
    "\2\37\10\0\2\37\1\0\1\37\1\0\1\37\11\0"+
    "\1\37\11\0\2\37\6\0\1\37\2\0\4\37\3\0"+
    "\1\37\2\0\2\37\1\0\3\37\5\0\1\37\1\0"+
    "\2\37\2\0\2\37\1\0\4\37\5\0\1\37\1\0"+
    "\2\37\45\0\1\30\4\0\1\30\11\0\1\30\22\0"+
    "\1\30\3\0\1\30\13\0\1\60\2\0\1\60\10\0"+
    "\1\30\12\0\4\60\45\0\1\30\21\0\1\30\26\0"+
    "\2\30\23\0\1\60\1\30\44\0\1\60\21\0\1\60"+
    "\46\0\1\60\11\0\1\60\15\0\4\30\2\0\2\30"+
    "\14\0\3\30\1\60\1\0\2\60\11\0\3\30\3\0"+
    "\1\30\1\0\1\60\4\0\1\60\2\30\5\0\4\60"+
    "\2\0\1\30\1\60\12\0\4\60\1\0\2\30\1\0"+
    "\1\60\7\0\1\30\23\0\1\30\4\0\1\30\6\0"+
    "\1\30\3\0\1\30\6\0\1\30\5\0\1\30\2\0"+
    "\2\30\1\0\17\30\2\0\1\30\13\0\7\30\2\0"+
    "\1\30\1\0\1\30\1\0\1\30\2\0\1\30\1\0"+
    "\1\30\1\0\1\30\1\0\1\30\4\0\1\60\1\0"+
    "\2\30\5\0\1\30\1\0\1\30\2\0\3\30\1\0"+
    "\1\30\7\0\1\30\1\0\1\30\26\0\1\30\6\0"+
    "\1\30\3\0\1\30\3\0\1\30\7\0\1\30\31\0"+
    "\20\30\5\0\3\30\3\0\1\30\3\0\2\30\2\0"+
    "\2\30\4\0\1\30\4\60\4\0\1\30\4\0\1\30"+
    "\2\0\1\30\4\0\1\30\1\0\1\30\1\0\1\30"+
    "\127\0\2\60\15\0\4\60\60\0\1\60\15\0\2\60"+
    "\10\0\2\60\1\0\1\60\1\0\1\60\11\0\1\60"+
    "\11\0\2\60\6\0\1\60\2\0\4\60\3\0\1\60"+
    "\2\0\2\60\1\0\3\60\5\0\1\60\1\0\2\60"+
    "\2\0\2\60\1\0\4\60\5\0\1\60\1\0\2\60"+
    "\44\0\1\224\1\0\1\225\17\0\1\226\2\0\1\227"+
    "\4\0\1\230\3\0\1\231\22\0\1\232\21\0\1\233"+
    "\2\0\1\234\60\0\1\154\1\60\6\0\1\154\12\0"+
    "\1\30\4\0\1\30\11\0\1\30\22\0\1\30\3\0"+
    "\1\30\13\0\1\61\2\0\1\61\10\0\1\30\12\0"+
    "\4\61\45\0\1\30\24\0\1\30\3\0\4\30\1\0"+
    "\1\30\4\0\1\30\1\0\2\30\2\0\2\30\2\0"+
    "\3\30\1\0\1\30\1\0\1\30\2\0\4\30\1\0"+
    "\3\30\1\0\1\30\1\0\3\30\1\0\2\30\1\0"+
    "\4\30\1\0\2\30\2\0\10\30\1\0\2\30\1\0"+
    "\11\30\1\0\10\30\1\0\13\30\2\0\1\30\1\0"+
    "\1\30\1\0\2\30\2\0\1\30\1\0\1\30\3\0"+
    "\1\30\17\0\1\30\26\0\2\30\24\0\1\30\44\0"+
    "\1\61\102\0\1\61\15\0\4\30\2\0\2\30\14\0"+
    "\3\30\1\61\1\0\2\61\11\0\3\30\3\0\1\30"+
    "\1\0\1\61\4\0\1\61\2\30\5\0\4\61\2\0"+
    "\1\30\1\61\17\0\2\30\1\0\1\61\7\0\1\30"+
    "\37\0\1\30\3\0\2\30\12\0\2\30\1\0\3\30"+
    "\7\0\1\30\6\0\2\30\1\0\2\30\6\0\1\30"+
    "\4\0\2\30\2\0\2\30\5\0\3\30\10\0\1\30"+
    "\16\0\1\30\7\0\1\30\7\0\1\30\23\0\1\30"+
    "\4\0\1\30\6\0\1\30\3\0\1\30\6\0\1\30"+
    "\5\0\1\30\2\0\2\30\1\0\17\30\2\0\1\30"+
    "\13\0\7\30\2\0\1\30\1\0\1\30\1\0\1\30"+
    "\2\0\1\30\1\0\1\30\1\0\1\30\1\0\1\30"+
    "\4\0\1\61\1\0\2\30\5\0\1\30\1\0\1\30"+
    "\2\0\3\30\1\0\1\30\7\0\1\30\1\0\1\30"+
    "\26\0\1\30\6\0\1\30\3\0\1\30\3\0\1\30"+
    "\7\0\1\30\31\0\20\30\5\0\3\30\3\0\1\30"+
    "\3\0\2\30\2\0\2\30\4\0\1\30\4\61\4\0"+
    "\1\30\4\0\1\30\2\0\1\30\4\0\1\30\1\0"+
    "\1\30\1\0\1\30\127\0\2\61\15\0\4\61\60\0"+
    "\1\61\15\0\2\61\10\0\2\61\1\0\1\61\1\0"+
    "\1\61\11\0\1\61\11\0\2\61\6\0\1\61\2\0"+
    "\4\61\3\0\1\61\2\0\2\61\1\0\3\61\5\0"+
    "\1\61\1\0\2\61\2\0\2\61\1\0\4\61\5\0"+
    "\1\61\1\0\2\61\45\0\1\30\4\0\1\30\11\0"+
    "\1\30\22\0\1\30\3\0\1\30\13\0\1\62\2\0"+
    "\1\62\10\0\1\30\12\0\4\62\45\0\1\30\21\0"+
    "\1\30\26\0\2\30\23\0\1\60\1\30\44\0\1\62"+
    "\21\0\1\60\46\0\1\60\11\0\1\62\15\0\4\30"+
    "\2\0\2\30\14\0\3\30\1\62\1\0\2\62\11\0"+
    "\3\30\3\0\1\30\1\0\1\62\4\0\1\62\2\30"+
    "\5\0\4\62\2\0\1\30\1\62\12\0\4\60\1\0"+
    "\2\30\1\0\1\62\7\0\1\30\23\0\1\30\4\0"+
    "\1\30\6\0\1\30\3\0\1\30\6\0\1\30\5\0"+
    "\1\30\2\0\2\30\1\0\17\30\2\0\1\30\13\0"+
    "\7\30\2\0\1\30\1\0\1\30\1\0\1\30\2\0"+
    "\1\30\1\0\1\30\1\0\1\30\1\0\1\30\4\0"+
    "\1\62\1\0\2\30\5\0\1\30\1\0\1\30\2\0"+
    "\3\30\1\0\1\30\7\0\1\30\1\0\1\30\26\0"+
    "\1\30\6\0\1\30\3\0\1\30\3\0\1\30\7\0"+
    "\1\30\31\0\20\30\5\0\3\30\3\0\1\30\3\0"+
    "\2\30\2\0\2\30\4\0\1\30\4\62\4\0\1\30"+
    "\4\0\1\30\2\0\1\30\4\0\1\30\1\0\1\30"+
    "\1\0\1\30\127\0\2\62\15\0\4\62\60\0\1\62"+
    "\15\0\2\62\10\0\2\62\1\0\1\62\1\0\1\62"+
    "\11\0\1\62\11\0\2\62\6\0\1\62\2\0\4\62"+
    "\3\0\1\62\2\0\2\62\1\0\3\62\5\0\1\62"+
    "\1\0\2\62\2\0\2\62\1\0\4\62\5\0\1\62"+
    "\1\0\2\62\127\0\1\74\2\0\1\74\23\0\4\74"+
    "\105\0\1\31\132\0\1\31\113\0\1\31\45\0\1\74"+
    "\21\0\1\31\46\0\1\31\11\0\1\74\44\0\1\74"+
    "\1\0\2\74\21\0\1\74\4\0\1\74\7\0\4\74"+
    "\3\0\1\74\12\0\4\31\4\0\1\74\205\0\2\31"+
    "\170\0\1\74\215\0\4\74\155\0\2\74\15\0\4\74"+
    "\60\0\1\74\15\0\2\74\10\0\2\74\1\0\1\74"+
    "\1\0\1\74\11\0\1\74\11\0\2\74\6\0\1\74"+
    "\2\0\4\74\3\0\1\74\2\0\2\74\1\0\3\74"+
    "\5\0\1\74\1\0\2\74\2\0\2\74\1\0\4\74"+
    "\5\0\1\74\1\0\2\74\45\0\1\30\4\0\1\30"+
    "\11\0\1\30\22\0\1\30\3\0\1\30\13\0\1\75"+
    "\2\0\1\75\10\0\1\30\12\0\4\75\45\0\1\30"+
    "\21\0\1\30\26\0\2\30\23\0\1\31\1\30\44\0"+
    "\1\75\21\0\1\31\46\0\1\31\11\0\1\75\15\0"+
    "\4\30\2\0\2\30\14\0\3\30\1\75\1\0\2\75"+
    "\11\0\3\30\3\0\1\30\1\0\1\75\4\0\1\75"+
    "\2\30\5\0\4\75\2\0\1\30\1\75\12\0\4\31"+
    "\1\0\2\30\1\0\1\75\7\0\1\30\23\0\1\30"+
    "\4\0\1\30\6\0\1\30\3\0\1\30\6\0\1\30"+
    "\5\0\1\30\2\0\2\30\1\0\17\30\2\0\1\30"+
    "\13\0\7\30\2\0\1\30\1\0\1\30\1\0\1\30"+
    "\2\0\1\30\1\0\1\30\1\0\1\30\1\0\1\30"+
    "\4\0\1\75\1\0\2\30\5\0\1\30\1\0\1\30"+
    "\2\0\3\30\1\0\1\30\7\0\1\30\1\0\1\30"+
    "\26\0\1\30\6\0\1\30\3\0\1\30\3\0\1\30"+
    "\7\0\1\30\31\0\20\30\5\0\3\30\3\0\1\30"+
    "\3\0\2\30\2\0\2\30\4\0\1\30\4\75\4\0"+
    "\1\30\4\0\1\30\2\0\1\30\4\0\1\30\1\0"+
    "\1\30\1\0\1\30\127\0\2\75\15\0\4\75\60\0"+
    "\1\75\15\0\2\75\10\0\2\75\1\0\1\75\1\0"+
    "\1\75\11\0\1\75\11\0\2\75\6\0\1\75\2\0"+
    "\4\75\3\0\1\75\2\0\2\75\1\0\3\75\5\0"+
    "\1\75\1\0\2\75\2\0\2\75\1\0\4\75\5\0"+
    "\1\75\1\0\2\75\127\0\1\117\2\0\1\117\23\0"+
    "\4\117\211\0\1\117\102\0\1\117\44\0\1\117\1\0"+
    "\2\117\21\0\1\117\4\0\1\117\7\0\4\117\3\0"+
    "\1\117\22\0\1\117\166\0\1\117\215\0\4\117\155\0"+
    "\2\117\15\0\4\117\60\0\1\117\15\0\2\117\10\0"+
    "\2\117\1\0\1\117\1\0\1\117\11\0\1\117\11\0"+
    "\2\117\6\0\1\117\2\0\4\117\3\0\1\117\2\0"+
    "\2\117\1\0\3\117\5\0\1\117\1\0\2\117\2\0"+
    "\2\117\1\0\4\117\5\0\1\117\1\0\2\117\127\0"+
    "\1\154\2\0\1\154\23\0\4\154\105\0\1\60\132\0"+
    "\1\60\113\0\1\60\45\0\1\154\21\0\1\60\46\0"+
    "\1\60\11\0\1\154\44\0\1\154\1\0\2\154\21\0"+
    "\1\154\4\0\1\154\7\0\4\154\3\0\1\154\12\0"+
    "\4\60\4\0\1\154\205\0\2\60\170\0\1\154\215\0"+
    "\4\154\155\0\2\154\15\0\4\154\60\0\1\154\15\0"+
    "\2\154\10\0\2\154\1\0\1\154\1\0\1\154\11\0"+
    "\1\154\11\0\2\154\6\0\1\154\2\0\4\154\3\0"+
    "\1\154\2\0\2\154\1\0\3\154\5\0\1\154\1\0"+
    "\2\154\2\0\2\154\1\0\4\154\5\0\1\154\1\0"+
    "\2\154\36\0";

  private static int [] zzUnpackTrans() {
    int [] result = new int[20002];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\1\0\1\11\35\1\20\0\1\1\1\0\1\1\12\0"+
    "\1\1\21\0\1\1\115\0";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[156];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  private int yycolumn;

  /** 
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /** denotes if the user-EOF-code has already been executed */
  private boolean zzEOFDone;

  /* user code: */
  /** Alphanumeric sequences */
  public static final int WORD_TYPE = StandardTokenizer.ALPHANUM;
  
  /** Numbers */
  public static final int NUMERIC_TYPE = StandardTokenizer.NUM;
  
  /**
   * Chars in class \p{Line_Break = Complex_Context} are from South East Asian
   * scripts (Thai, Lao, Myanmar, Khmer, etc.).  Sequences of these are kept 
   * together as as a single token rather than broken up, because the logic
   * required to break them at word boundaries is too complex for UAX#29.
   * <p>
   * See Unicode Line Breaking Algorithm: http://www.unicode.org/reports/tr14/#SA
   */
  public static final int SOUTH_EAST_ASIAN_TYPE = StandardTokenizer.SOUTHEAST_ASIAN;
  
  public static final int IDEOGRAPHIC_TYPE = StandardTokenizer.IDEOGRAPHIC;
  
  public static final int HIRAGANA_TYPE = StandardTokenizer.HIRAGANA;
  
  public static final int KATAKANA_TYPE = StandardTokenizer.KATAKANA;
  
  public static final int HANGUL_TYPE = StandardTokenizer.HANGUL;

  public final int yychar()
  {
    return yychar;
  }

  /**
   * Fills CharTermAttribute with the current token text.
   */
  public final void getText(CharTermAttribute t) {
    t.copyBuffer(zzBuffer, zzStartRead, zzMarkedPos-zzStartRead);
  }


  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public StandardTokenizerImpl(java.io.Reader in) {
    this.zzReader = in;
  }

  

  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 2848) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   * 
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead-zzStartRead);

      /* translate stored positions */
      zzEndRead-= zzStartRead;
      zzCurrentPos-= zzStartRead;
      zzMarkedPos-= zzStartRead;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzCurrentPos*2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
    }

    /* finally: fill the buffer with new input */
    int numRead = zzReader.read(zzBuffer, zzEndRead,
                                            zzBuffer.length-zzEndRead);

    if (numRead > 0) {
      zzEndRead+= numRead;
      return false;
    }
    // unlikely but not impossible: read 0 characters, but not at end of stream    
    if (numRead == 0) {
      int c = zzReader.read();
      if (c == -1) {
        return true;
      } else {
        zzBuffer[zzEndRead++] = (char) c;
        return false;
      }     
    }

    // numRead < 0
    return true;
  }

    
  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Resets the scanner to read from a new input stream.
   * Does not close the old reader.
   *
   * All internal variables are reset, the old input stream 
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>ZZ_INITIAL</tt>.
   *
   * Internal scan buffer is resized down to its initial length, if it has grown.
   *
   * @param reader   the new input stream 
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzAtBOL  = true;
    zzAtEOF  = false;
    zzEOFDone = false;
    zzEndRead = zzStartRead = 0;
    zzCurrentPos = zzMarkedPos = 0;
    yyline = yychar = yycolumn = 0;
    zzLexicalState = YYINITIAL;
    if (zzBuffer.length > ZZ_BUFFERSIZE)
      zzBuffer = new char[ZZ_BUFFERSIZE];
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public int getNextToken() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      yychar+= zzMarkedPosL-zzStartRead;

      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      zzState = ZZ_LEXSTATE[zzLexicalState];

      // set up zzAction for empty match case:
      int zzAttributes = zzAttrL[zzState];
      if ( (zzAttributes & 1) == 1 ) {
        zzAction = zzState;
      }


      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL)
            zzInput = zzBufferL[zzCurrentPosL++];
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = zzBufferL[zzCurrentPosL++];
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMapL[zzInput] ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 1: 
          { /* Break so we don't hit fall-through warning: */ break; /* Not numeric, word, ideographic, hiragana, or SE Asian -- ignore it. */
          }
        case 9: break;
        case 2: 
          { return WORD_TYPE;
          }
        case 10: break;
        case 3: 
          { return NUMERIC_TYPE;
          }
        case 11: break;
        case 4: 
          { return KATAKANA_TYPE;
          }
        case 12: break;
        case 5: 
          { return SOUTH_EAST_ASIAN_TYPE;
          }
        case 13: break;
        case 6: 
          { return IDEOGRAPHIC_TYPE;
          }
        case 14: break;
        case 7: 
          { return HIRAGANA_TYPE;
          }
        case 15: break;
        case 8: 
          { return HANGUL_TYPE;
          }
        case 16: break;
        default: 
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
              {
                return StandardTokenizerInterface.YYEOF;
              }
          } 
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
