/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.cn.smart;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import org.apache.lucene.util.IOUtils;

public class AnalyzerProfile {
    public static String ANALYSIS_DATA_DIR = "";

    private static void init() {
        String dirName = "analysis-data";
        String propName = "analysis.properties";
        ANALYSIS_DATA_DIR = System.getProperty("analysis.data.dir", "");
        if (ANALYSIS_DATA_DIR.length() != 0) {
            return;
        }
        File[] cadidateFiles = new File[]{new File("./" + dirName), new File("./lib/" + dirName), new File("./" + propName), new File("./lib/" + propName)};
        for (int i = 0; i < cadidateFiles.length; ++i) {
            File file = cadidateFiles[i];
            if (!file.exists()) continue;
            if (file.isDirectory()) {
                ANALYSIS_DATA_DIR = file.getAbsolutePath();
                break;
            }
            if (!file.isFile() || AnalyzerProfile.getAnalysisDataDir(file).length() == 0) break;
            ANALYSIS_DATA_DIR = AnalyzerProfile.getAnalysisDataDir(file);
            break;
        }
        if (ANALYSIS_DATA_DIR.length() == 0) {
            throw new RuntimeException("WARNING: Can not find lexical dictionary directory! This will cause unpredictable exceptions in your application! Please refer to the manual to download the dictionaries.");
        }
    }

    private static String getAnalysisDataDir(File propFile) {
        Properties prop = new Properties();
        try {
            FileInputStream input = new FileInputStream(propFile);
            prop.load(new InputStreamReader((InputStream)input, IOUtils.CHARSET_UTF_8));
            String dir = prop.getProperty("analysis.data.dir", "");
            input.close();
            return dir;
        }
        catch (IOException e) {
            return "";
        }
    }

    static {
        AnalyzerProfile.init();
    }
}

