/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ar;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.WordlistLoader;
import org.apache.lucene.analysis.ar.ArabicLetterTokenizer;
import org.apache.lucene.analysis.ar.ArabicNormalizationFilter;
import org.apache.lucene.analysis.ar.ArabicStemFilter;

public final class ArabicAnalyzer
extends Analyzer {
    public static final String DEFAULT_STOPWORD_FILE = "stopwords.txt";
    private Set stoptable = new HashSet();
    public static final String STOPWORDS_COMMENT = "#";

    public ArabicAnalyzer() {
        try {
            InputStream stream = ArabicAnalyzer.class.getResourceAsStream(DEFAULT_STOPWORD_FILE);
            InputStreamReader reader = new InputStreamReader(stream, "UTF-8");
            this.stoptable = WordlistLoader.getWordSet((Reader)reader, (String)STOPWORDS_COMMENT);
            reader.close();
            stream.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ArabicAnalyzer(String[] stopwords) {
        this.stoptable = StopFilter.makeStopSet((String[])stopwords);
    }

    public ArabicAnalyzer(Hashtable stopwords) {
        this.stoptable = new HashSet(stopwords.keySet());
    }

    public ArabicAnalyzer(File stopwords) throws IOException {
        this.stoptable = WordlistLoader.getWordSet((File)stopwords, (String)STOPWORDS_COMMENT);
    }

    public final TokenStream tokenStream(String fieldName, Reader reader) {
        Object result = new ArabicLetterTokenizer(reader);
        result = new StopFilter((TokenStream)result, this.stoptable);
        result = new LowerCaseFilter((TokenStream)result);
        result = new ArabicNormalizationFilter((TokenStream)result);
        result = new ArabicStemFilter((TokenStream)result);
        return result;
    }

    public TokenStream reusableTokenStream(String fieldName, Reader reader) throws IOException {
        SavedStreams streams = (SavedStreams)this.getPreviousTokenStream();
        if (streams == null) {
            streams = new SavedStreams();
            streams.source = new ArabicLetterTokenizer(reader);
            streams.result = new StopFilter((TokenStream)streams.source, this.stoptable);
            streams.result = new LowerCaseFilter(streams.result);
            streams.result = new ArabicNormalizationFilter(streams.result);
            streams.result = new ArabicStemFilter(streams.result);
            this.setPreviousTokenStream(streams);
        } else {
            streams.source.reset(reader);
        }
        return streams.result;
    }

    private class SavedStreams {
        Tokenizer source;
        TokenStream result;

        private SavedStreams() {
        }
    }
}

