/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.feeds;

import java.io.IOException;
import java.util.Random;
import org.apache.lucene.benchmark.byTask.feeds.FacetSource;
import org.apache.lucene.benchmark.byTask.feeds.NoMoreDataException;
import org.apache.lucene.benchmark.byTask.utils.Config;
import org.apache.lucene.facet.index.CategoryContainer;
import org.apache.lucene.facet.taxonomy.CategoryPath;

public class RandomFacetSource
extends FacetSource {
    Random random;
    private int maxDocFacets = 10;
    private int maxFacetDepth = 3;
    private int maxValue = this.maxDocFacets * this.maxFacetDepth;

    public CategoryContainer getNextFacets(CategoryContainer facets) throws NoMoreDataException, IOException {
        if (facets == null) {
            facets = new CategoryContainer();
        } else {
            facets.clear();
        }
        int numFacets = 1 + this.random.nextInt(this.maxDocFacets - 1);
        for (int i = 0; i < numFacets; ++i) {
            CategoryPath cp = new CategoryPath();
            int depth = 1 + this.random.nextInt(this.maxFacetDepth - 1);
            for (int k = 0; k < depth; ++k) {
                cp.add((CharSequence)Integer.toString(this.random.nextInt(this.maxValue)));
                this.addItem();
            }
            facets.addCategory(cp);
            this.addBytes(cp.toString().length());
        }
        return facets;
    }

    public void close() throws IOException {
    }

    public void setConfig(Config config) {
        super.setConfig(config);
        this.random = new Random(config.get("rand.seed", 13));
        this.maxDocFacets = config.get("max.doc.facets", 200);
        this.maxFacetDepth = config.get("max.facet.depth", 10);
        this.maxValue = this.maxDocFacets * this.maxFacetDepth;
    }
}

