/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.feeds;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import org.apache.lucene.benchmark.byTask.feeds.ContentSource;
import org.apache.lucene.benchmark.byTask.feeds.DocData;
import org.apache.lucene.benchmark.byTask.feeds.NoMoreDataException;
import org.apache.lucene.benchmark.byTask.utils.Config;

public class ReutersContentSource
extends ContentSource {
    private ThreadLocal<DateFormatInfo> dateFormat = new ThreadLocal();
    private File dataDir = null;
    private ArrayList<File> inputFiles = new ArrayList();
    private int nextFile = 0;
    private int iteration = 0;

    public void setConfig(Config config) {
        super.setConfig(config);
        File workDir = new File(config.get("work.dir", "work"));
        String d = config.get("docs.dir", "reuters-out");
        this.dataDir = new File(d);
        if (!this.dataDir.isAbsolute()) {
            this.dataDir = new File(workDir, d);
        }
        this.inputFiles.clear();
        this.collectFiles(this.dataDir, this.inputFiles);
        if (this.inputFiles.size() == 0) {
            throw new RuntimeException("No txt files in dataDir: " + this.dataDir.getAbsolutePath());
        }
    }

    private synchronized DateFormatInfo getDateFormatInfo() {
        DateFormatInfo dfi = this.dateFormat.get();
        if (dfi == null) {
            dfi = new DateFormatInfo();
            dfi.df = new SimpleDateFormat("dd-MMM-yyyy kk:mm:ss.SSS", Locale.US);
            dfi.df.setLenient(true);
            dfi.pos = new ParsePosition(0);
            this.dateFormat.set(dfi);
        }
        return dfi;
    }

    private Date parseDate(String dateStr) {
        DateFormatInfo dfi = this.getDateFormatInfo();
        dfi.pos.setIndex(0);
        dfi.pos.setErrorIndex(-1);
        return dfi.df.parse(dateStr.trim(), dfi.pos);
    }

    public void close() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocData getNextDocData(DocData docData) throws NoMoreDataException, IOException {
        File f = null;
        String name = null;
        ReutersContentSource reutersContentSource = this;
        synchronized (reutersContentSource) {
            if (this.nextFile >= this.inputFiles.size()) {
                if (!this.forever) {
                    throw new NoMoreDataException();
                }
                this.nextFile = 0;
                ++this.iteration;
            }
            f = this.inputFiles.get(this.nextFile++);
            name = f.getCanonicalPath() + "_" + this.iteration;
        }
        BufferedReader reader = new BufferedReader(new FileReader(f));
        try {
            String dateStr = reader.readLine();
            reader.readLine();
            String title = reader.readLine();
            reader.readLine();
            StringBuilder bodyBuf = new StringBuilder(1024);
            String line = null;
            while ((line = reader.readLine()) != null) {
                bodyBuf.append(line).append(' ');
            }
            reader.close();
            this.addBytes(f.length());
            Date date = this.parseDate(dateStr.trim());
            docData.clear();
            docData.setName(name);
            docData.setBody(bodyBuf.toString());
            docData.setTitle(title);
            docData.setDate(date);
            DocData docData2 = docData;
            return docData2;
        }
        finally {
            reader.close();
        }
    }

    public synchronized void resetInputs() throws IOException {
        super.resetInputs();
        this.nextFile = 0;
        this.iteration = 0;
    }

    private static final class DateFormatInfo {
        DateFormat df;
        ParsePosition pos;

        DateFormatInfo() {
        }
    }
}

