/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.tasks;

import org.apache.lucene.benchmark.byTask.PerfRunData;
import org.apache.lucene.benchmark.byTask.feeds.QueryMaker;
import org.apache.lucene.benchmark.byTask.tasks.SearchTask;
import org.apache.lucene.benchmark.byTask.utils.Config;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.TopScoreDocCollector;

public class SearchWithCollectorTask
extends SearchTask {
    protected String clnName;

    public SearchWithCollectorTask(PerfRunData runData) {
        super(runData);
    }

    @Override
    public void setup() throws Exception {
        super.setup();
        PerfRunData runData = this.getRunData();
        Config config = runData.getConfig();
        this.clnName = config.get("collector.class", "");
    }

    @Override
    public boolean withCollector() {
        return true;
    }

    @Override
    protected Collector createCollector() throws Exception {
        Object collector = null;
        collector = this.clnName.equalsIgnoreCase("topScoreDoc") ? TopScoreDocCollector.create((int)this.numHits()) : (this.clnName.length() > 0 ? Class.forName(this.clnName).asSubclass(Collector.class).newInstance() : super.createCollector());
        return collector;
    }

    @Override
    public QueryMaker getQueryMaker() {
        return this.getRunData().getQueryMaker(this);
    }

    @Override
    public boolean withRetrieve() {
        return false;
    }

    @Override
    public boolean withSearch() {
        return true;
    }

    @Override
    public boolean withTraverse() {
        return false;
    }

    @Override
    public boolean withWarm() {
        return false;
    }
}

