/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.simpletext;

import java.io.Closeable;
import java.io.IOException;
import java.util.BitSet;
import java.util.Collection;
import org.apache.lucene.codecs.LiveDocsFormat;
import org.apache.lucene.codecs.simpletext.SimpleTextUtil;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.CharsRefBuilder;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.StringHelper;

public class SimpleTextLiveDocsFormat
extends LiveDocsFormat {
    static final String LIVEDOCS_EXTENSION = "liv";
    static final BytesRef SIZE = new BytesRef((CharSequence)"size ");
    static final BytesRef DOC = new BytesRef((CharSequence)"  doc ");
    static final BytesRef END = new BytesRef((CharSequence)"END");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bits readLiveDocs(Directory dir, SegmentCommitInfo info, IOContext context) throws IOException {
        SimpleTextBits simpleTextBits;
        block9: {
            ChecksumIndexInput in;
            block8: {
                assert (info.hasDeletions());
                BytesRefBuilder scratch = new BytesRefBuilder();
                CharsRefBuilder scratchUTF16 = new CharsRefBuilder();
                String fileName = IndexFileNames.fileNameFromGeneration((String)info.info.name, (String)LIVEDOCS_EXTENSION, (long)info.getDelGen());
                in = null;
                boolean success = false;
                try {
                    in = dir.openChecksumInput(fileName);
                    SimpleTextUtil.readLine((DataInput)in, scratch);
                    assert (StringHelper.startsWith((BytesRef)scratch.get(), (BytesRef)SIZE));
                    int size = this.parseIntAt(scratch.get(), SimpleTextLiveDocsFormat.SIZE.length, scratchUTF16);
                    BitSet bits = new BitSet(size);
                    SimpleTextUtil.readLine((DataInput)in, scratch);
                    while (!scratch.get().equals((Object)END)) {
                        assert (StringHelper.startsWith((BytesRef)scratch.get(), (BytesRef)DOC));
                        int docid = this.parseIntAt(scratch.get(), SimpleTextLiveDocsFormat.DOC.length, scratchUTF16);
                        bits.set(docid);
                        SimpleTextUtil.readLine((DataInput)in, scratch);
                    }
                    SimpleTextUtil.checkFooter(in);
                    success = true;
                    simpleTextBits = new SimpleTextBits(bits, size);
                    if (!success) break block8;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close((Closeable[])new Closeable[]{in});
                    } else {
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{in});
                    }
                    throw throwable;
                }
                IOUtils.close((Closeable[])new Closeable[]{in});
                break block9;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{in});
        }
        return simpleTextBits;
    }

    private int parseIntAt(BytesRef bytes, int offset, CharsRefBuilder scratch) {
        scratch.copyUTF8Bytes(bytes.bytes, bytes.offset + offset, bytes.length - offset);
        return ArrayUtil.parseInt((char[])scratch.chars(), (int)0, (int)scratch.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeLiveDocs(Bits bits, Directory dir, SegmentCommitInfo info, int newDelCount, IOContext context) throws IOException {
        block6: {
            IndexOutput out;
            block5: {
                int size = bits.length();
                BytesRefBuilder scratch = new BytesRefBuilder();
                String fileName = IndexFileNames.fileNameFromGeneration((String)info.info.name, (String)LIVEDOCS_EXTENSION, (long)info.getNextDelGen());
                out = null;
                boolean success = false;
                try {
                    out = dir.createOutput(fileName, context);
                    SimpleTextUtil.write((DataOutput)out, SIZE);
                    SimpleTextUtil.write((DataOutput)out, Integer.toString(size), scratch);
                    SimpleTextUtil.writeNewline((DataOutput)out);
                    for (int i = 0; i < size; ++i) {
                        if (!bits.get(i)) continue;
                        SimpleTextUtil.write((DataOutput)out, DOC);
                        SimpleTextUtil.write((DataOutput)out, Integer.toString(i), scratch);
                        SimpleTextUtil.writeNewline((DataOutput)out);
                    }
                    SimpleTextUtil.write((DataOutput)out, END);
                    SimpleTextUtil.writeNewline((DataOutput)out);
                    SimpleTextUtil.writeChecksum(out, scratch);
                    success = true;
                    if (!success) break block5;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close((Closeable[])new Closeable[]{out});
                    } else {
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{out});
                    }
                    throw throwable;
                }
                IOUtils.close((Closeable[])new Closeable[]{out});
                break block6;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{out});
        }
    }

    public void files(SegmentCommitInfo info, Collection<String> files) throws IOException {
        if (info.hasDeletions()) {
            files.add(IndexFileNames.fileNameFromGeneration((String)info.info.name, (String)LIVEDOCS_EXTENSION, (long)info.getDelGen()));
        }
    }

    record SimpleTextBits(BitSet bits, int size) implements Bits
    {
        public boolean get(int index) {
            return this.bits.get(index);
        }

        public int length() {
            return this.size;
        }
    }
}

