/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.simpletext;

import java.io.Closeable;
import java.io.IOException;
import org.apache.lucene.codecs.DocValuesArraySource;
import org.apache.lucene.codecs.DocValuesConsumer;
import org.apache.lucene.codecs.simpletext.SimpleTextUtil;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefHash;
import org.apache.lucene.util.IOUtils;

public class SimpleTextDocValuesConsumer
extends DocValuesConsumer {
    static final BytesRef ZERO_DOUBLE = new BytesRef((CharSequence)Double.toString(0.0));
    static final BytesRef ZERO_INT = new BytesRef((CharSequence)Integer.toString(0));
    static final BytesRef HEADER = new BytesRef((CharSequence)"SimpleTextDocValues");
    static final BytesRef END = new BytesRef((CharSequence)"END");
    static final BytesRef VALUE_SIZE = new BytesRef((CharSequence)"valuesize ");
    static final BytesRef DOC = new BytesRef((CharSequence)"  doc ");
    static final BytesRef VALUE = new BytesRef((CharSequence)"    value ");
    protected BytesRef scratch = new BytesRef();
    protected int maxDocId = -1;
    protected final String segment;
    protected final Directory dir;
    protected final IOContext ctx;
    protected final DocValues.Type type;
    protected final BytesRefHash hash;
    private int[] ords;
    private int valueSize = Integer.MIN_VALUE;
    private BytesRef zeroBytes;
    private final String segmentSuffix;

    public SimpleTextDocValuesConsumer(String segment, Directory dir, IOContext ctx, DocValues.Type type, String segmentSuffix) {
        this.ctx = ctx;
        this.dir = dir;
        this.segment = segment;
        this.type = type;
        this.hash = new BytesRefHash();
        this.ords = new int[0];
        this.segmentSuffix = segmentSuffix;
    }

    public void add(int docID, IndexableField value) throws IOException {
        int ord;
        int vSize;
        assert (docID >= 0);
        switch (this.type) {
            case BYTES_FIXED_DEREF: 
            case BYTES_FIXED_SORTED: 
            case BYTES_FIXED_STRAIGHT: {
                vSize = value.binaryValue().length;
                ord = this.hash.add(value.binaryValue());
                break;
            }
            case BYTES_VAR_DEREF: 
            case BYTES_VAR_SORTED: 
            case BYTES_VAR_STRAIGHT: {
                vSize = -1;
                ord = this.hash.add(value.binaryValue());
                break;
            }
            case FIXED_INTS_16: {
                vSize = 2;
                this.scratch.grow(2);
                DocValuesArraySource.copyShort((BytesRef)this.scratch, (short)value.numericValue().shortValue());
                ord = this.hash.add(this.scratch);
                break;
            }
            case FIXED_INTS_32: {
                vSize = 4;
                this.scratch.grow(4);
                DocValuesArraySource.copyInt((BytesRef)this.scratch, (int)value.numericValue().intValue());
                ord = this.hash.add(this.scratch);
                break;
            }
            case FIXED_INTS_8: {
                vSize = 1;
                this.scratch.grow(1);
                this.scratch.bytes[this.scratch.offset] = value.numericValue().byteValue();
                this.scratch.length = 1;
                ord = this.hash.add(this.scratch);
                break;
            }
            case FIXED_INTS_64: {
                vSize = 8;
                this.scratch.grow(8);
                DocValuesArraySource.copyLong((BytesRef)this.scratch, (long)value.numericValue().longValue());
                ord = this.hash.add(this.scratch);
                break;
            }
            case VAR_INTS: {
                vSize = -1;
                this.scratch.grow(8);
                DocValuesArraySource.copyLong((BytesRef)this.scratch, (long)value.numericValue().longValue());
                ord = this.hash.add(this.scratch);
                break;
            }
            case FLOAT_32: {
                vSize = 4;
                this.scratch.grow(4);
                DocValuesArraySource.copyInt((BytesRef)this.scratch, (int)Float.floatToRawIntBits(value.numericValue().floatValue()));
                ord = this.hash.add(this.scratch);
                break;
            }
            case FLOAT_64: {
                vSize = 8;
                this.scratch.grow(8);
                DocValuesArraySource.copyLong((BytesRef)this.scratch, (long)Double.doubleToRawLongBits(value.numericValue().doubleValue()));
                ord = this.hash.add(this.scratch);
                break;
            }
            default: {
                throw new RuntimeException("should not reach this line");
            }
        }
        if (this.valueSize == Integer.MIN_VALUE) {
            assert (this.maxDocId == -1);
            this.valueSize = vSize;
        } else if (this.valueSize != vSize) {
            throw new IllegalArgumentException("value size must be " + this.valueSize + " but was: " + vSize);
        }
        this.maxDocId = Math.max(docID, this.maxDocId);
        this.ords = this.grow(this.ords, docID);
        this.ords[docID] = (ord < 0 ? -ord - 1 : ord) + 1;
    }

    protected BytesRef getHeader() {
        return HEADER;
    }

    private int[] grow(int[] array, int upto) {
        if (array.length <= upto) {
            return ArrayUtil.grow((int[])array, (int)(1 + upto));
        }
        return array;
    }

    private void prepareFlush(int docCount) {
        assert (this.ords != null);
        this.ords = this.grow(this.ords, docCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish(int docCount) throws IOException {
        String fileName = IndexFileNames.segmentFileName((String)this.segment, (String)"", (String)this.segmentSuffix);
        IndexOutput output = this.dir.createOutput(fileName, this.ctx);
        boolean success = false;
        BytesRef spare = new BytesRef();
        try {
            SimpleTextUtil.write((DataOutput)output, this.getHeader());
            SimpleTextUtil.writeNewline((DataOutput)output);
            SimpleTextUtil.write((DataOutput)output, VALUE_SIZE);
            SimpleTextUtil.write((DataOutput)output, Integer.toString(this.valueSize), this.scratch);
            SimpleTextUtil.writeNewline((DataOutput)output);
            this.prepareFlush(docCount);
            for (int i = 0; i < docCount; ++i) {
                SimpleTextUtil.write((DataOutput)output, DOC);
                SimpleTextUtil.write((DataOutput)output, Integer.toString(i), this.scratch);
                SimpleTextUtil.writeNewline((DataOutput)output);
                SimpleTextUtil.write((DataOutput)output, VALUE);
                this.writeDoc(output, i, spare);
                SimpleTextUtil.writeNewline((DataOutput)output);
            }
            SimpleTextUtil.write((DataOutput)output, END);
            SimpleTextUtil.writeNewline((DataOutput)output);
            success = true;
        }
        catch (Throwable throwable) {
            this.hash.close();
            if (success) {
                IOUtils.close((Closeable[])new Closeable[]{output});
            } else {
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{output});
                this.dir.deleteFile(fileName);
            }
            throw throwable;
        }
        this.hash.close();
        if (success) {
            IOUtils.close((Closeable[])new Closeable[]{output});
        } else {
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{output});
            this.dir.deleteFile(fileName);
        }
    }

    protected void writeDoc(IndexOutput output, int docId, BytesRef spare) throws IOException {
        int ord = this.ords[docId] - 1;
        if (ord != -1) {
            assert (ord >= 0);
            this.hash.get(ord, spare);
            switch (this.type) {
                case BYTES_FIXED_DEREF: 
                case BYTES_FIXED_SORTED: 
                case BYTES_FIXED_STRAIGHT: 
                case BYTES_VAR_DEREF: 
                case BYTES_VAR_SORTED: 
                case BYTES_VAR_STRAIGHT: {
                    SimpleTextUtil.write((DataOutput)output, spare);
                    break;
                }
                case FIXED_INTS_16: {
                    SimpleTextUtil.write((DataOutput)output, Short.toString(DocValuesArraySource.asShort((BytesRef)spare)), this.scratch);
                    break;
                }
                case FIXED_INTS_32: {
                    SimpleTextUtil.write((DataOutput)output, Integer.toString(DocValuesArraySource.asInt((BytesRef)spare)), this.scratch);
                    break;
                }
                case FIXED_INTS_64: 
                case VAR_INTS: {
                    SimpleTextUtil.write((DataOutput)output, Long.toString(DocValuesArraySource.asLong((BytesRef)spare)), this.scratch);
                    break;
                }
                case FIXED_INTS_8: {
                    assert (spare.length == 1) : spare.length;
                    SimpleTextUtil.write((DataOutput)output, Integer.toString(spare.bytes[spare.offset]), this.scratch);
                    break;
                }
                case FLOAT_32: {
                    float valueFloat = Float.intBitsToFloat(DocValuesArraySource.asInt((BytesRef)spare));
                    SimpleTextUtil.write((DataOutput)output, Float.toString(valueFloat), this.scratch);
                    break;
                }
                case FLOAT_64: {
                    double valueDouble = Double.longBitsToDouble(DocValuesArraySource.asLong((BytesRef)spare));
                    SimpleTextUtil.write((DataOutput)output, Double.toString(valueDouble), this.scratch);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unsupported type: " + this.type);
                }
            }
        } else {
            switch (this.type) {
                case BYTES_FIXED_DEREF: 
                case BYTES_FIXED_SORTED: 
                case BYTES_FIXED_STRAIGHT: {
                    if (this.zeroBytes == null) {
                        assert (this.valueSize > 0);
                        this.zeroBytes = new BytesRef(new byte[this.valueSize]);
                    }
                    SimpleTextUtil.write((DataOutput)output, this.zeroBytes);
                    break;
                }
                case BYTES_VAR_DEREF: 
                case BYTES_VAR_SORTED: 
                case BYTES_VAR_STRAIGHT: {
                    this.scratch.length = 0;
                    SimpleTextUtil.write((DataOutput)output, this.scratch);
                    break;
                }
                case FIXED_INTS_16: 
                case FIXED_INTS_32: 
                case FIXED_INTS_8: 
                case FIXED_INTS_64: 
                case VAR_INTS: {
                    SimpleTextUtil.write((DataOutput)output, ZERO_INT);
                    break;
                }
                case FLOAT_32: 
                case FLOAT_64: {
                    SimpleTextUtil.write((DataOutput)output, ZERO_DOUBLE);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unsupported type: " + this.type);
                }
            }
        }
    }

    protected DocValues.Type getType() {
        return this.type;
    }

    public int getValueSize() {
        return this.valueSize;
    }
}

