/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.simpletext;

import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.simpletext.SimpleTextFieldsWriter;
import org.apache.lucene.codecs.simpletext.SimpleTextPostingsFormat;
import org.apache.lucene.codecs.simpletext.SimpleTextUtil;
import org.apache.lucene.index.DocsAndPositionsEnum;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRef;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.OpenBitSet;
import org.apache.lucene.util.StringHelper;
import org.apache.lucene.util.UnicodeUtil;
import org.apache.lucene.util.fst.Builder;
import org.apache.lucene.util.fst.BytesRefFSTEnum;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.Outputs;
import org.apache.lucene.util.fst.PairOutputs;
import org.apache.lucene.util.fst.PositiveIntOutputs;
import org.apache.lucene.util.fst.Util;

class SimpleTextFieldsReader
extends FieldsProducer {
    private final TreeMap<String, Long> fields;
    private final IndexInput in;
    private final FieldInfos fieldInfos;
    static final BytesRef END = SimpleTextFieldsWriter.END;
    static final BytesRef FIELD = SimpleTextFieldsWriter.FIELD;
    static final BytesRef TERM = SimpleTextFieldsWriter.TERM;
    static final BytesRef DOC = SimpleTextFieldsWriter.DOC;
    static final BytesRef FREQ = SimpleTextFieldsWriter.FREQ;
    static final BytesRef POS = SimpleTextFieldsWriter.POS;
    static final BytesRef START_OFFSET = SimpleTextFieldsWriter.START_OFFSET;
    static final BytesRef END_OFFSET = SimpleTextFieldsWriter.END_OFFSET;
    static final BytesRef PAYLOAD = SimpleTextFieldsWriter.PAYLOAD;
    private final Map<String, Terms> termsCache = new HashMap<String, Terms>();

    public SimpleTextFieldsReader(SegmentReadState state) throws IOException {
        this.in = state.dir.openInput(SimpleTextPostingsFormat.getPostingsFileName(state.segmentInfo.name, state.segmentSuffix), state.context);
        this.fieldInfos = state.fieldInfos;
        this.fields = this.readFields(this.in.clone());
    }

    private TreeMap<String, Long> readFields(IndexInput in) throws IOException {
        BytesRef scratch = new BytesRef(10);
        TreeMap<String, Long> fields = new TreeMap<String, Long>();
        while (true) {
            SimpleTextUtil.readLine((DataInput)in, scratch);
            if (scratch.equals((Object)END)) {
                return fields;
            }
            if (!StringHelper.startsWith((BytesRef)scratch, (BytesRef)FIELD)) continue;
            String fieldName = new String(scratch.bytes, scratch.offset + SimpleTextFieldsReader.FIELD.length, scratch.length - SimpleTextFieldsReader.FIELD.length, "UTF-8");
            fields.put(fieldName, in.getFilePointer());
        }
    }

    public Iterator<String> iterator() {
        return Collections.unmodifiableSet(this.fields.keySet()).iterator();
    }

    public synchronized Terms terms(String field) throws IOException {
        Terms terms = this.termsCache.get(field);
        if (terms == null) {
            Long fp = this.fields.get(field);
            if (fp == null) {
                return null;
            }
            terms = new SimpleTextTerms(field, fp);
            this.termsCache.put(field, terms);
        }
        return terms;
    }

    public int size() {
        return -1;
    }

    public void close() throws IOException {
        this.in.close();
    }

    private class SimpleTextTerms
    extends Terms {
        private final long termsStart;
        private final FieldInfo fieldInfo;
        private long sumTotalTermFreq;
        private long sumDocFreq;
        private int docCount;
        private FST<PairOutputs.Pair<Long, PairOutputs.Pair<Long, Long>>> fst;
        private int termCount;
        private final BytesRef scratch = new BytesRef(10);
        private final CharsRef scratchUTF16 = new CharsRef(10);

        public SimpleTextTerms(String field, long termsStart) throws IOException {
            this.termsStart = termsStart;
            this.fieldInfo = SimpleTextFieldsReader.this.fieldInfos.fieldInfo(field);
            this.loadTerms();
        }

        private void loadTerms() throws IOException {
            PositiveIntOutputs posIntOutputs = PositiveIntOutputs.getSingleton((boolean)false);
            PairOutputs outputsInner = new PairOutputs((Outputs)posIntOutputs, (Outputs)posIntOutputs);
            PairOutputs outputs = new PairOutputs((Outputs)posIntOutputs, (Outputs)outputsInner);
            Builder b = new Builder(FST.INPUT_TYPE.BYTE1, (Outputs)outputs);
            IndexInput in = SimpleTextFieldsReader.this.in.clone();
            in.seek(this.termsStart);
            BytesRef lastTerm = new BytesRef(10);
            long lastDocsStart = -1L;
            int docFreq = 0;
            long totalTermFreq = 0L;
            OpenBitSet visitedDocs = new OpenBitSet();
            IntsRef scratchIntsRef = new IntsRef();
            while (true) {
                SimpleTextUtil.readLine((DataInput)in, this.scratch);
                if (this.scratch.equals((Object)END) || StringHelper.startsWith((BytesRef)this.scratch, (BytesRef)FIELD)) {
                    if (lastDocsStart == -1L) break;
                    b.add(Util.toIntsRef((BytesRef)lastTerm, (IntsRef)scratchIntsRef), (Object)outputs.newPair((Object)lastDocsStart, (Object)outputsInner.newPair((Object)docFreq, (Object)totalTermFreq)));
                    this.sumTotalTermFreq += totalTermFreq;
                    break;
                }
                if (StringHelper.startsWith((BytesRef)this.scratch, (BytesRef)DOC)) {
                    ++docFreq;
                    ++this.sumDocFreq;
                    UnicodeUtil.UTF8toUTF16((byte[])this.scratch.bytes, (int)(this.scratch.offset + SimpleTextFieldsReader.DOC.length), (int)(this.scratch.length - SimpleTextFieldsReader.DOC.length), (CharsRef)this.scratchUTF16);
                    int docID = ArrayUtil.parseInt((char[])this.scratchUTF16.chars, (int)0, (int)this.scratchUTF16.length);
                    visitedDocs.set((long)docID);
                    continue;
                }
                if (StringHelper.startsWith((BytesRef)this.scratch, (BytesRef)FREQ)) {
                    UnicodeUtil.UTF8toUTF16((byte[])this.scratch.bytes, (int)(this.scratch.offset + SimpleTextFieldsReader.FREQ.length), (int)(this.scratch.length - SimpleTextFieldsReader.FREQ.length), (CharsRef)this.scratchUTF16);
                    totalTermFreq += (long)ArrayUtil.parseInt((char[])this.scratchUTF16.chars, (int)0, (int)this.scratchUTF16.length);
                    continue;
                }
                if (!StringHelper.startsWith((BytesRef)this.scratch, (BytesRef)TERM)) continue;
                if (lastDocsStart != -1L) {
                    b.add(Util.toIntsRef((BytesRef)lastTerm, (IntsRef)scratchIntsRef), (Object)outputs.newPair((Object)lastDocsStart, (Object)outputsInner.newPair((Object)docFreq, (Object)totalTermFreq)));
                }
                lastDocsStart = in.getFilePointer();
                int len = this.scratch.length - SimpleTextFieldsReader.TERM.length;
                if (len > lastTerm.length) {
                    lastTerm.grow(len);
                }
                System.arraycopy(this.scratch.bytes, SimpleTextFieldsReader.TERM.length, lastTerm.bytes, 0, len);
                lastTerm.length = len;
                docFreq = 0;
                this.sumTotalTermFreq += totalTermFreq;
                totalTermFreq = 0L;
                ++this.termCount;
            }
            this.docCount = (int)visitedDocs.cardinality();
            this.fst = b.finish();
        }

        public TermsEnum iterator(TermsEnum reuse) throws IOException {
            if (this.fst != null) {
                return new SimpleTextTermsEnum(this.fst, this.fieldInfo.getIndexOptions());
            }
            return TermsEnum.EMPTY;
        }

        public Comparator<BytesRef> getComparator() {
            return BytesRef.getUTF8SortedAsUnicodeComparator();
        }

        public long size() {
            return this.termCount;
        }

        public long getSumTotalTermFreq() {
            return this.fieldInfo.getIndexOptions() == FieldInfo.IndexOptions.DOCS_ONLY ? -1L : this.sumTotalTermFreq;
        }

        public long getSumDocFreq() throws IOException {
            return this.sumDocFreq;
        }

        public int getDocCount() throws IOException {
            return this.docCount;
        }

        public boolean hasOffsets() {
            return this.fieldInfo.getIndexOptions().compareTo((Enum)FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0;
        }

        public boolean hasPositions() {
            return this.fieldInfo.getIndexOptions().compareTo((Enum)FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0;
        }

        public boolean hasPayloads() {
            return this.fieldInfo.hasPayloads();
        }
    }

    static class TermData {
        public long docsStart;
        public int docFreq;

        public TermData(long docsStart, int docFreq) {
            this.docsStart = docsStart;
            this.docFreq = docFreq;
        }
    }

    private class SimpleTextDocsAndPositionsEnum
    extends DocsAndPositionsEnum {
        private final IndexInput inStart;
        private final IndexInput in;
        private int docID = -1;
        private int tf;
        private Bits liveDocs;
        private final BytesRef scratch = new BytesRef(10);
        private final BytesRef scratch2 = new BytesRef(10);
        private final CharsRef scratchUTF16 = new CharsRef(10);
        private final CharsRef scratchUTF16_2 = new CharsRef(10);
        private BytesRef payload;
        private long nextDocStart;
        private boolean readOffsets;
        private boolean readPositions;
        private int startOffset;
        private int endOffset;

        public SimpleTextDocsAndPositionsEnum() {
            this.inStart = SimpleTextFieldsReader.this.in;
            this.in = this.inStart.clone();
        }

        public boolean canReuse(IndexInput in) {
            return in == this.inStart;
        }

        public SimpleTextDocsAndPositionsEnum reset(long fp, Bits liveDocs, FieldInfo.IndexOptions indexOptions) {
            this.liveDocs = liveDocs;
            this.nextDocStart = fp;
            this.docID = -1;
            this.readPositions = indexOptions.compareTo((Enum)FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0;
            boolean bl = this.readOffsets = indexOptions.compareTo((Enum)FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0;
            if (!this.readOffsets) {
                this.startOffset = -1;
                this.endOffset = -1;
            }
            return this;
        }

        public int docID() {
            return this.docID;
        }

        public int freq() throws IOException {
            return this.tf;
        }

        public int nextDoc() throws IOException {
            long lineStart;
            boolean first = true;
            this.in.seek(this.nextDocStart);
            long posStart = 0L;
            while (true) {
                lineStart = this.in.getFilePointer();
                SimpleTextUtil.readLine((DataInput)this.in, this.scratch);
                if (StringHelper.startsWith((BytesRef)this.scratch, (BytesRef)DOC)) {
                    if (!first && (this.liveDocs == null || this.liveDocs.get(this.docID))) {
                        this.nextDocStart = lineStart;
                        this.in.seek(posStart);
                        return this.docID;
                    }
                    UnicodeUtil.UTF8toUTF16((byte[])this.scratch.bytes, (int)(this.scratch.offset + SimpleTextFieldsReader.DOC.length), (int)(this.scratch.length - SimpleTextFieldsReader.DOC.length), (CharsRef)this.scratchUTF16);
                    this.docID = ArrayUtil.parseInt((char[])this.scratchUTF16.chars, (int)0, (int)this.scratchUTF16.length);
                    this.tf = 0;
                    first = false;
                    continue;
                }
                if (StringHelper.startsWith((BytesRef)this.scratch, (BytesRef)FREQ)) {
                    UnicodeUtil.UTF8toUTF16((byte[])this.scratch.bytes, (int)(this.scratch.offset + SimpleTextFieldsReader.FREQ.length), (int)(this.scratch.length - SimpleTextFieldsReader.FREQ.length), (CharsRef)this.scratchUTF16);
                    this.tf = ArrayUtil.parseInt((char[])this.scratchUTF16.chars, (int)0, (int)this.scratchUTF16.length);
                    posStart = this.in.getFilePointer();
                    continue;
                }
                if (!(StringHelper.startsWith((BytesRef)this.scratch, (BytesRef)POS) || StringHelper.startsWith((BytesRef)this.scratch, (BytesRef)START_OFFSET) || StringHelper.startsWith((BytesRef)this.scratch, (BytesRef)END_OFFSET) || StringHelper.startsWith((BytesRef)this.scratch, (BytesRef)PAYLOAD))) break;
            }
            assert (StringHelper.startsWith((BytesRef)this.scratch, (BytesRef)TERM) || StringHelper.startsWith((BytesRef)this.scratch, (BytesRef)FIELD) || StringHelper.startsWith((BytesRef)this.scratch, (BytesRef)END));
            if (!first && (this.liveDocs == null || this.liveDocs.get(this.docID))) {
                this.nextDocStart = lineStart;
                this.in.seek(posStart);
                return this.docID;
            }
            this.docID = Integer.MAX_VALUE;
            return Integer.MAX_VALUE;
        }

        public int advance(int target) throws IOException {
            while (this.nextDoc() < target) {
            }
            return this.docID;
        }

        public int nextPosition() throws IOException {
            int pos;
            if (this.readPositions) {
                SimpleTextUtil.readLine((DataInput)this.in, this.scratch);
                assert (StringHelper.startsWith((BytesRef)this.scratch, (BytesRef)POS)) : "got line=" + this.scratch.utf8ToString();
                UnicodeUtil.UTF8toUTF16((byte[])this.scratch.bytes, (int)(this.scratch.offset + SimpleTextFieldsReader.POS.length), (int)(this.scratch.length - SimpleTextFieldsReader.POS.length), (CharsRef)this.scratchUTF16_2);
                pos = ArrayUtil.parseInt((char[])this.scratchUTF16_2.chars, (int)0, (int)this.scratchUTF16_2.length);
            } else {
                pos = -1;
            }
            if (this.readOffsets) {
                SimpleTextUtil.readLine((DataInput)this.in, this.scratch);
                assert (StringHelper.startsWith((BytesRef)this.scratch, (BytesRef)START_OFFSET)) : "got line=" + this.scratch.utf8ToString();
                UnicodeUtil.UTF8toUTF16((byte[])this.scratch.bytes, (int)(this.scratch.offset + SimpleTextFieldsReader.START_OFFSET.length), (int)(this.scratch.length - SimpleTextFieldsReader.START_OFFSET.length), (CharsRef)this.scratchUTF16_2);
                this.startOffset = ArrayUtil.parseInt((char[])this.scratchUTF16_2.chars, (int)0, (int)this.scratchUTF16_2.length);
                SimpleTextUtil.readLine((DataInput)this.in, this.scratch);
                assert (StringHelper.startsWith((BytesRef)this.scratch, (BytesRef)END_OFFSET)) : "got line=" + this.scratch.utf8ToString();
                UnicodeUtil.UTF8toUTF16((byte[])this.scratch.bytes, (int)(this.scratch.offset + SimpleTextFieldsReader.END_OFFSET.length), (int)(this.scratch.length - SimpleTextFieldsReader.END_OFFSET.length), (CharsRef)this.scratchUTF16_2);
                this.endOffset = ArrayUtil.parseInt((char[])this.scratchUTF16_2.chars, (int)0, (int)this.scratchUTF16_2.length);
            }
            long fp = this.in.getFilePointer();
            SimpleTextUtil.readLine((DataInput)this.in, this.scratch);
            if (StringHelper.startsWith((BytesRef)this.scratch, (BytesRef)PAYLOAD)) {
                int len = this.scratch.length - SimpleTextFieldsReader.PAYLOAD.length;
                if (this.scratch2.bytes.length < len) {
                    this.scratch2.grow(len);
                }
                System.arraycopy(this.scratch.bytes, SimpleTextFieldsReader.PAYLOAD.length, this.scratch2.bytes, 0, len);
                this.scratch2.length = len;
                this.payload = this.scratch2;
            } else {
                this.payload = null;
                this.in.seek(fp);
            }
            return pos;
        }

        public int startOffset() throws IOException {
            return this.startOffset;
        }

        public int endOffset() throws IOException {
            return this.endOffset;
        }

        public BytesRef getPayload() {
            return this.payload;
        }
    }

    private class SimpleTextDocsEnum
    extends DocsEnum {
        private final IndexInput inStart;
        private final IndexInput in;
        private boolean omitTF;
        private int docID = -1;
        private int tf;
        private Bits liveDocs;
        private final BytesRef scratch = new BytesRef(10);
        private final CharsRef scratchUTF16 = new CharsRef(10);

        public SimpleTextDocsEnum() {
            this.inStart = SimpleTextFieldsReader.this.in;
            this.in = this.inStart.clone();
        }

        public boolean canReuse(IndexInput in) {
            return in == this.inStart;
        }

        public SimpleTextDocsEnum reset(long fp, Bits liveDocs, boolean omitTF) throws IOException {
            this.liveDocs = liveDocs;
            this.in.seek(fp);
            this.omitTF = omitTF;
            this.docID = -1;
            this.tf = 1;
            return this;
        }

        public int docID() {
            return this.docID;
        }

        public int freq() throws IOException {
            return this.tf;
        }

        public int nextDoc() throws IOException {
            long lineStart;
            if (this.docID == Integer.MAX_VALUE) {
                return this.docID;
            }
            boolean first = true;
            int termFreq = 0;
            while (true) {
                lineStart = this.in.getFilePointer();
                SimpleTextUtil.readLine((DataInput)this.in, this.scratch);
                if (StringHelper.startsWith((BytesRef)this.scratch, (BytesRef)DOC)) {
                    if (!first && (this.liveDocs == null || this.liveDocs.get(this.docID))) {
                        this.in.seek(lineStart);
                        if (!this.omitTF) {
                            this.tf = termFreq;
                        }
                        return this.docID;
                    }
                    UnicodeUtil.UTF8toUTF16((byte[])this.scratch.bytes, (int)(this.scratch.offset + SimpleTextFieldsReader.DOC.length), (int)(this.scratch.length - SimpleTextFieldsReader.DOC.length), (CharsRef)this.scratchUTF16);
                    this.docID = ArrayUtil.parseInt((char[])this.scratchUTF16.chars, (int)0, (int)this.scratchUTF16.length);
                    termFreq = 0;
                    first = false;
                    continue;
                }
                if (StringHelper.startsWith((BytesRef)this.scratch, (BytesRef)FREQ)) {
                    UnicodeUtil.UTF8toUTF16((byte[])this.scratch.bytes, (int)(this.scratch.offset + SimpleTextFieldsReader.FREQ.length), (int)(this.scratch.length - SimpleTextFieldsReader.FREQ.length), (CharsRef)this.scratchUTF16);
                    termFreq = ArrayUtil.parseInt((char[])this.scratchUTF16.chars, (int)0, (int)this.scratchUTF16.length);
                    continue;
                }
                if (!(StringHelper.startsWith((BytesRef)this.scratch, (BytesRef)POS) || StringHelper.startsWith((BytesRef)this.scratch, (BytesRef)START_OFFSET) || StringHelper.startsWith((BytesRef)this.scratch, (BytesRef)END_OFFSET) || StringHelper.startsWith((BytesRef)this.scratch, (BytesRef)PAYLOAD))) break;
            }
            assert (StringHelper.startsWith((BytesRef)this.scratch, (BytesRef)TERM) || StringHelper.startsWith((BytesRef)this.scratch, (BytesRef)FIELD) || StringHelper.startsWith((BytesRef)this.scratch, (BytesRef)END)) : "scratch=" + this.scratch.utf8ToString();
            if (!first && (this.liveDocs == null || this.liveDocs.get(this.docID))) {
                this.in.seek(lineStart);
                if (!this.omitTF) {
                    this.tf = termFreq;
                }
                return this.docID;
            }
            this.docID = Integer.MAX_VALUE;
            return Integer.MAX_VALUE;
        }

        public int advance(int target) throws IOException {
            while (this.nextDoc() < target) {
            }
            return this.docID;
        }
    }

    private class SimpleTextTermsEnum
    extends TermsEnum {
        private final FieldInfo.IndexOptions indexOptions;
        private int docFreq;
        private long totalTermFreq;
        private long docsStart;
        private boolean ended;
        private final BytesRefFSTEnum<PairOutputs.Pair<Long, PairOutputs.Pair<Long, Long>>> fstEnum;

        public SimpleTextTermsEnum(FST<PairOutputs.Pair<Long, PairOutputs.Pair<Long, Long>>> fst, FieldInfo.IndexOptions indexOptions) {
            this.indexOptions = indexOptions;
            this.fstEnum = new BytesRefFSTEnum(fst);
        }

        public boolean seekExact(BytesRef text, boolean useCache) throws IOException {
            BytesRefFSTEnum.InputOutput result = this.fstEnum.seekExact(text);
            if (result != null) {
                PairOutputs.Pair pair1 = (PairOutputs.Pair)result.output;
                PairOutputs.Pair pair2 = (PairOutputs.Pair)pair1.output2;
                this.docsStart = (Long)pair1.output1;
                this.docFreq = ((Long)pair2.output1).intValue();
                this.totalTermFreq = (Long)pair2.output2;
                return true;
            }
            return false;
        }

        public TermsEnum.SeekStatus seekCeil(BytesRef text, boolean useCache) throws IOException {
            BytesRefFSTEnum.InputOutput result = this.fstEnum.seekCeil(text);
            if (result == null) {
                return TermsEnum.SeekStatus.END;
            }
            PairOutputs.Pair pair1 = (PairOutputs.Pair)result.output;
            PairOutputs.Pair pair2 = (PairOutputs.Pair)pair1.output2;
            this.docsStart = (Long)pair1.output1;
            this.docFreq = ((Long)pair2.output1).intValue();
            this.totalTermFreq = (Long)pair2.output2;
            if (result.input.equals((Object)text)) {
                return TermsEnum.SeekStatus.FOUND;
            }
            return TermsEnum.SeekStatus.NOT_FOUND;
        }

        public BytesRef next() throws IOException {
            assert (!this.ended);
            BytesRefFSTEnum.InputOutput result = this.fstEnum.next();
            if (result != null) {
                PairOutputs.Pair pair1 = (PairOutputs.Pair)result.output;
                PairOutputs.Pair pair2 = (PairOutputs.Pair)pair1.output2;
                this.docsStart = (Long)pair1.output1;
                this.docFreq = ((Long)pair2.output1).intValue();
                this.totalTermFreq = (Long)pair2.output2;
                return result.input;
            }
            return null;
        }

        public BytesRef term() {
            return this.fstEnum.current().input;
        }

        public long ord() throws IOException {
            throw new UnsupportedOperationException();
        }

        public void seekExact(long ord) {
            throw new UnsupportedOperationException();
        }

        public int docFreq() {
            return this.docFreq;
        }

        public long totalTermFreq() {
            return this.indexOptions == FieldInfo.IndexOptions.DOCS_ONLY ? -1L : this.totalTermFreq;
        }

        public DocsEnum docs(Bits liveDocs, DocsEnum reuse, int flags) throws IOException {
            SimpleTextDocsEnum docsEnum = reuse != null && reuse instanceof SimpleTextDocsEnum && ((SimpleTextDocsEnum)reuse).canReuse(SimpleTextFieldsReader.this.in) ? (SimpleTextDocsEnum)reuse : new SimpleTextDocsEnum();
            return docsEnum.reset(this.docsStart, liveDocs, this.indexOptions == FieldInfo.IndexOptions.DOCS_ONLY);
        }

        public DocsAndPositionsEnum docsAndPositions(Bits liveDocs, DocsAndPositionsEnum reuse, int flags) throws IOException {
            if (this.indexOptions.compareTo((Enum)FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) < 0) {
                return null;
            }
            SimpleTextDocsAndPositionsEnum docsAndPositionsEnum = reuse != null && reuse instanceof SimpleTextDocsAndPositionsEnum && ((SimpleTextDocsAndPositionsEnum)reuse).canReuse(SimpleTextFieldsReader.this.in) ? (SimpleTextDocsAndPositionsEnum)reuse : new SimpleTextDocsAndPositionsEnum();
            return docsAndPositionsEnum.reset(this.docsStart, liveDocs, this.indexOptions);
        }

        public Comparator<BytesRef> getComparator() {
            return BytesRef.getUTF8SortedAsUnicodeComparator();
        }
    }
}

