/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.simpletext;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.lucene.codecs.TermVectorsReader;
import org.apache.lucene.codecs.simpletext.SimpleTextTermVectorsWriter;
import org.apache.lucene.codecs.simpletext.SimpleTextUtil;
import org.apache.lucene.index.DocsAndPositionsEnum;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.BufferedChecksumIndexInput;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.StringHelper;
import org.apache.lucene.util.UnicodeUtil;

public class SimpleTextTermVectorsReader
extends TermVectorsReader {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(SimpleTextTermVectorsReader.class) + RamUsageEstimator.shallowSizeOfInstance(BytesRef.class) + RamUsageEstimator.shallowSizeOfInstance(CharsRef.class);
    private long[] offsets;
    private IndexInput in;
    private BytesRef scratch = new BytesRef();
    private CharsRef scratchUTF16 = new CharsRef();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleTextTermVectorsReader(Directory directory, SegmentInfo si, IOContext context) throws IOException {
        boolean success = false;
        try {
            this.in = directory.openInput(IndexFileNames.segmentFileName((String)si.name, (String)"", (String)"vec"), context);
            success = true;
        }
        finally {
            if (!success) {
                try {
                    this.close();
                }
                catch (Throwable t) {}
            }
        }
        this.readIndex(si.getDocCount());
    }

    SimpleTextTermVectorsReader(long[] offsets, IndexInput in) {
        this.offsets = offsets;
        this.in = in;
    }

    private void readIndex(int maxDoc) throws IOException {
        BufferedChecksumIndexInput input = new BufferedChecksumIndexInput(this.in);
        this.offsets = new long[maxDoc];
        int upto = 0;
        while (!this.scratch.equals((Object)SimpleTextTermVectorsWriter.END)) {
            SimpleTextUtil.readLine((DataInput)input, this.scratch);
            if (!StringHelper.startsWith((BytesRef)this.scratch, (BytesRef)SimpleTextTermVectorsWriter.DOC)) continue;
            this.offsets[upto] = input.getFilePointer();
            ++upto;
        }
        SimpleTextUtil.checkFooter((ChecksumIndexInput)input);
        assert (upto == this.offsets.length);
    }

    public Fields get(int doc) throws IOException {
        TreeMap<String, SimpleTVTerms> fields = new TreeMap<String, SimpleTVTerms>();
        this.in.seek(this.offsets[doc]);
        this.readLine();
        assert (StringHelper.startsWith((BytesRef)this.scratch, (BytesRef)SimpleTextTermVectorsWriter.NUMFIELDS));
        int numFields = this.parseIntAt(SimpleTextTermVectorsWriter.NUMFIELDS.length);
        if (numFields == 0) {
            return null;
        }
        for (int i = 0; i < numFields; ++i) {
            this.readLine();
            assert (StringHelper.startsWith((BytesRef)this.scratch, (BytesRef)SimpleTextTermVectorsWriter.FIELD));
            this.parseIntAt(SimpleTextTermVectorsWriter.FIELD.length);
            this.readLine();
            assert (StringHelper.startsWith((BytesRef)this.scratch, (BytesRef)SimpleTextTermVectorsWriter.FIELDNAME));
            String fieldName = this.readString(SimpleTextTermVectorsWriter.FIELDNAME.length, this.scratch);
            this.readLine();
            assert (StringHelper.startsWith((BytesRef)this.scratch, (BytesRef)SimpleTextTermVectorsWriter.FIELDPOSITIONS));
            boolean positions = Boolean.parseBoolean(this.readString(SimpleTextTermVectorsWriter.FIELDPOSITIONS.length, this.scratch));
            this.readLine();
            assert (StringHelper.startsWith((BytesRef)this.scratch, (BytesRef)SimpleTextTermVectorsWriter.FIELDOFFSETS));
            boolean offsets = Boolean.parseBoolean(this.readString(SimpleTextTermVectorsWriter.FIELDOFFSETS.length, this.scratch));
            this.readLine();
            assert (StringHelper.startsWith((BytesRef)this.scratch, (BytesRef)SimpleTextTermVectorsWriter.FIELDPAYLOADS));
            boolean payloads = Boolean.parseBoolean(this.readString(SimpleTextTermVectorsWriter.FIELDPAYLOADS.length, this.scratch));
            this.readLine();
            assert (StringHelper.startsWith((BytesRef)this.scratch, (BytesRef)SimpleTextTermVectorsWriter.FIELDTERMCOUNT));
            int termCount = this.parseIntAt(SimpleTextTermVectorsWriter.FIELDTERMCOUNT.length);
            SimpleTVTerms terms = new SimpleTVTerms(offsets, positions, payloads);
            fields.put(fieldName, terms);
            for (int j = 0; j < termCount; ++j) {
                this.readLine();
                assert (StringHelper.startsWith((BytesRef)this.scratch, (BytesRef)SimpleTextTermVectorsWriter.TERMTEXT));
                BytesRef term = new BytesRef();
                int termLength = this.scratch.length - SimpleTextTermVectorsWriter.TERMTEXT.length;
                term.grow(termLength);
                term.length = termLength;
                System.arraycopy(this.scratch.bytes, this.scratch.offset + SimpleTextTermVectorsWriter.TERMTEXT.length, term.bytes, term.offset, termLength);
                SimpleTVPostings postings = new SimpleTVPostings();
                terms.terms.put(term, postings);
                this.readLine();
                assert (StringHelper.startsWith((BytesRef)this.scratch, (BytesRef)SimpleTextTermVectorsWriter.TERMFREQ));
                postings.freq = this.parseIntAt(SimpleTextTermVectorsWriter.TERMFREQ.length);
                if (!positions && !offsets) continue;
                if (positions) {
                    SimpleTVPostings.access$202(postings, new int[postings.freq]);
                    if (payloads) {
                        SimpleTVPostings.access$302(postings, new BytesRef[postings.freq]);
                    }
                }
                if (offsets) {
                    SimpleTVPostings.access$402(postings, new int[postings.freq]);
                    SimpleTVPostings.access$502(postings, new int[postings.freq]);
                }
                for (int k = 0; k < postings.freq; ++k) {
                    if (positions) {
                        this.readLine();
                        assert (StringHelper.startsWith((BytesRef)this.scratch, (BytesRef)SimpleTextTermVectorsWriter.POSITION));
                        ((SimpleTVPostings)postings).positions[k] = this.parseIntAt(SimpleTextTermVectorsWriter.POSITION.length);
                        if (payloads) {
                            this.readLine();
                            assert (StringHelper.startsWith((BytesRef)this.scratch, (BytesRef)SimpleTextTermVectorsWriter.PAYLOAD));
                            if (this.scratch.length - SimpleTextTermVectorsWriter.PAYLOAD.length == 0) {
                                ((SimpleTVPostings)postings).payloads[k] = null;
                            } else {
                                byte[] payloadBytes = new byte[this.scratch.length - SimpleTextTermVectorsWriter.PAYLOAD.length];
                                System.arraycopy(this.scratch.bytes, this.scratch.offset + SimpleTextTermVectorsWriter.PAYLOAD.length, payloadBytes, 0, payloadBytes.length);
                                ((SimpleTVPostings)postings).payloads[k] = new BytesRef(payloadBytes);
                            }
                        }
                    }
                    if (!offsets) continue;
                    this.readLine();
                    assert (StringHelper.startsWith((BytesRef)this.scratch, (BytesRef)SimpleTextTermVectorsWriter.STARTOFFSET));
                    ((SimpleTVPostings)postings).startOffsets[k] = this.parseIntAt(SimpleTextTermVectorsWriter.STARTOFFSET.length);
                    this.readLine();
                    assert (StringHelper.startsWith((BytesRef)this.scratch, (BytesRef)SimpleTextTermVectorsWriter.ENDOFFSET));
                    ((SimpleTVPostings)postings).endOffsets[k] = this.parseIntAt(SimpleTextTermVectorsWriter.ENDOFFSET.length);
                }
            }
        }
        return new SimpleTVFields(fields);
    }

    public TermVectorsReader clone() {
        if (this.in == null) {
            throw new AlreadyClosedException("this TermVectorsReader is closed");
        }
        return new SimpleTextTermVectorsReader(this.offsets, this.in.clone());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            IOUtils.close((Closeable[])new Closeable[]{this.in});
        }
        finally {
            this.in = null;
            this.offsets = null;
        }
    }

    private void readLine() throws IOException {
        SimpleTextUtil.readLine((DataInput)this.in, this.scratch);
    }

    private int parseIntAt(int offset) {
        UnicodeUtil.UTF8toUTF16((byte[])this.scratch.bytes, (int)(this.scratch.offset + offset), (int)(this.scratch.length - offset), (CharsRef)this.scratchUTF16);
        return ArrayUtil.parseInt((char[])this.scratchUTF16.chars, (int)0, (int)this.scratchUTF16.length);
    }

    private String readString(int offset, BytesRef scratch) {
        UnicodeUtil.UTF8toUTF16((byte[])scratch.bytes, (int)(scratch.offset + offset), (int)(scratch.length - offset), (CharsRef)this.scratchUTF16);
        return this.scratchUTF16.toString();
    }

    public long ramBytesUsed() {
        return BASE_RAM_BYTES_USED + RamUsageEstimator.sizeOf((long[])this.offsets);
    }

    public void checkIntegrity() throws IOException {
    }

    private static class SimpleTVDocsAndPositionsEnum
    extends DocsAndPositionsEnum {
        private boolean didNext;
        private int doc = -1;
        private int nextPos;
        private Bits liveDocs;
        private int[] positions;
        private BytesRef[] payloads;
        private int[] startOffsets;
        private int[] endOffsets;

        private SimpleTVDocsAndPositionsEnum() {
        }

        public int freq() throws IOException {
            if (this.positions != null) {
                return this.positions.length;
            }
            assert (this.startOffsets != null);
            return this.startOffsets.length;
        }

        public int docID() {
            return this.doc;
        }

        public int nextDoc() {
            if (!this.didNext && (this.liveDocs == null || this.liveDocs.get(0))) {
                this.didNext = true;
                this.doc = 0;
                return 0;
            }
            this.doc = Integer.MAX_VALUE;
            return Integer.MAX_VALUE;
        }

        public int advance(int target) throws IOException {
            return this.slowAdvance(target);
        }

        public void reset(Bits liveDocs, int[] positions, int[] startOffsets, int[] endOffsets, BytesRef[] payloads) {
            this.liveDocs = liveDocs;
            this.positions = positions;
            this.startOffsets = startOffsets;
            this.endOffsets = endOffsets;
            this.payloads = payloads;
            this.doc = -1;
            this.didNext = false;
            this.nextPos = 0;
        }

        public BytesRef getPayload() {
            return this.payloads == null ? null : this.payloads[this.nextPos - 1];
        }

        public int nextPosition() {
            assert (this.positions != null && this.nextPos < this.positions.length || this.startOffsets != null && this.nextPos < this.startOffsets.length);
            if (this.positions != null) {
                return this.positions[this.nextPos++];
            }
            ++this.nextPos;
            return -1;
        }

        public int startOffset() {
            if (this.startOffsets == null) {
                return -1;
            }
            return this.startOffsets[this.nextPos - 1];
        }

        public int endOffset() {
            if (this.endOffsets == null) {
                return -1;
            }
            return this.endOffsets[this.nextPos - 1];
        }

        public long cost() {
            return 1L;
        }
    }

    private static class SimpleTVDocsEnum
    extends DocsEnum {
        private boolean didNext;
        private int doc = -1;
        private int freq;
        private Bits liveDocs;

        private SimpleTVDocsEnum() {
        }

        public int freq() throws IOException {
            assert (this.freq != -1);
            return this.freq;
        }

        public int docID() {
            return this.doc;
        }

        public int nextDoc() {
            if (!this.didNext && (this.liveDocs == null || this.liveDocs.get(0))) {
                this.didNext = true;
                this.doc = 0;
                return 0;
            }
            this.doc = Integer.MAX_VALUE;
            return Integer.MAX_VALUE;
        }

        public int advance(int target) throws IOException {
            return this.slowAdvance(target);
        }

        public void reset(Bits liveDocs, int freq) {
            this.liveDocs = liveDocs;
            this.freq = freq;
            this.doc = -1;
            this.didNext = false;
        }

        public long cost() {
            return 1L;
        }
    }

    private static class SimpleTVTermsEnum
    extends TermsEnum {
        SortedMap<BytesRef, SimpleTVPostings> terms;
        Iterator<Map.Entry<BytesRef, SimpleTVPostings>> iterator;
        Map.Entry<BytesRef, SimpleTVPostings> current;

        SimpleTVTermsEnum(SortedMap<BytesRef, SimpleTVPostings> terms) {
            this.terms = terms;
            this.iterator = terms.entrySet().iterator();
        }

        public TermsEnum.SeekStatus seekCeil(BytesRef text) throws IOException {
            this.iterator = this.terms.tailMap(text).entrySet().iterator();
            if (!this.iterator.hasNext()) {
                return TermsEnum.SeekStatus.END;
            }
            return this.next().equals((Object)text) ? TermsEnum.SeekStatus.FOUND : TermsEnum.SeekStatus.NOT_FOUND;
        }

        public void seekExact(long ord) throws IOException {
            throw new UnsupportedOperationException();
        }

        public BytesRef next() throws IOException {
            if (!this.iterator.hasNext()) {
                return null;
            }
            this.current = this.iterator.next();
            return this.current.getKey();
        }

        public BytesRef term() throws IOException {
            return this.current.getKey();
        }

        public long ord() throws IOException {
            throw new UnsupportedOperationException();
        }

        public int docFreq() throws IOException {
            return 1;
        }

        public long totalTermFreq() throws IOException {
            return this.current.getValue().freq;
        }

        public DocsEnum docs(Bits liveDocs, DocsEnum reuse, int flags) throws IOException {
            SimpleTVDocsEnum e = new SimpleTVDocsEnum();
            e.reset(liveDocs, (flags & 1) == 0 ? 1 : this.current.getValue().freq);
            return e;
        }

        public DocsAndPositionsEnum docsAndPositions(Bits liveDocs, DocsAndPositionsEnum reuse, int flags) throws IOException {
            SimpleTVPostings postings = this.current.getValue();
            if (postings.positions == null && postings.startOffsets == null) {
                return null;
            }
            SimpleTVDocsAndPositionsEnum e = new SimpleTVDocsAndPositionsEnum();
            e.reset(liveDocs, postings.positions, postings.startOffsets, postings.endOffsets, postings.payloads);
            return e;
        }

        public Comparator<BytesRef> getComparator() {
            return BytesRef.getUTF8SortedAsUnicodeComparator();
        }
    }

    private static class SimpleTVPostings {
        private int freq;
        private int[] positions;
        private int[] startOffsets;
        private int[] endOffsets;
        private BytesRef[] payloads;

        private SimpleTVPostings() {
        }

        static /* synthetic */ int[] access$202(SimpleTVPostings x0, int[] x1) {
            x0.positions = x1;
            return x1;
        }

        static /* synthetic */ BytesRef[] access$302(SimpleTVPostings x0, BytesRef[] x1) {
            x0.payloads = x1;
            return x1;
        }

        static /* synthetic */ int[] access$402(SimpleTVPostings x0, int[] x1) {
            x0.startOffsets = x1;
            return x1;
        }

        static /* synthetic */ int[] access$502(SimpleTVPostings x0, int[] x1) {
            x0.endOffsets = x1;
            return x1;
        }
    }

    private static class SimpleTVTerms
    extends Terms {
        final SortedMap<BytesRef, SimpleTVPostings> terms;
        final boolean hasOffsets;
        final boolean hasPositions;
        final boolean hasPayloads;

        SimpleTVTerms(boolean hasOffsets, boolean hasPositions, boolean hasPayloads) {
            this.hasOffsets = hasOffsets;
            this.hasPositions = hasPositions;
            this.hasPayloads = hasPayloads;
            this.terms = new TreeMap<BytesRef, SimpleTVPostings>();
        }

        public TermsEnum iterator(TermsEnum reuse) throws IOException {
            return new SimpleTVTermsEnum(this.terms);
        }

        public Comparator<BytesRef> getComparator() {
            return BytesRef.getUTF8SortedAsUnicodeComparator();
        }

        public long size() throws IOException {
            return this.terms.size();
        }

        public long getSumTotalTermFreq() throws IOException {
            return -1L;
        }

        public long getSumDocFreq() throws IOException {
            return this.terms.size();
        }

        public int getDocCount() throws IOException {
            return 1;
        }

        public boolean hasFreqs() {
            return true;
        }

        public boolean hasOffsets() {
            return this.hasOffsets;
        }

        public boolean hasPositions() {
            return this.hasPositions;
        }

        public boolean hasPayloads() {
            return this.hasPayloads;
        }
    }

    private class SimpleTVFields
    extends Fields {
        private final SortedMap<String, SimpleTVTerms> fields;

        SimpleTVFields(SortedMap<String, SimpleTVTerms> fields) {
            this.fields = fields;
        }

        public Iterator<String> iterator() {
            return Collections.unmodifiableSet(this.fields.keySet()).iterator();
        }

        public Terms terms(String field) throws IOException {
            return (Terms)this.fields.get(field);
        }

        public int size() {
            return this.fields.size();
        }
    }
}

