/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.simpletext;

import java.io.IOException;
import org.apache.lucene.codecs.FieldsConsumer;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.codecs.simpletext.SimpleTextFieldsReader;
import org.apache.lucene.codecs.simpletext.SimpleTextFieldsWriter;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;

public final class SimpleTextPostingsFormat
extends PostingsFormat {
    static final String POSTINGS_EXTENSION = "pst";

    public SimpleTextPostingsFormat() {
        super("SimpleText");
    }

    public FieldsConsumer fieldsConsumer(SegmentWriteState state) throws IOException {
        return new SimpleTextFieldsWriter(state);
    }

    public FieldsProducer fieldsProducer(SegmentReadState state) throws IOException {
        return new SimpleTextFieldsReader(state);
    }

    static String getPostingsFileName(String segment, String segmentSuffix) {
        return IndexFileNames.segmentFileName((String)segment, (String)segmentSuffix, (String)POSTINGS_EXTENSION);
    }
}

