/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.simpletext;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.codecs.PointsReader;
import org.apache.lucene.codecs.PointsWriter;
import org.apache.lucene.codecs.simpletext.SimpleTextUtil;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.bkd.BKDWriter;

class SimpleTextPointsWriter
extends PointsWriter {
    static final BytesRef NUM_DIMS = new BytesRef((CharSequence)"num dims ");
    static final BytesRef BYTES_PER_DIM = new BytesRef((CharSequence)"bytes per dim ");
    static final BytesRef MAX_LEAF_POINTS = new BytesRef((CharSequence)"max leaf points ");
    static final BytesRef INDEX_COUNT = new BytesRef((CharSequence)"index count ");
    static final BytesRef BLOCK_COUNT = new BytesRef((CharSequence)"block count ");
    static final BytesRef BLOCK_DOC_ID = new BytesRef((CharSequence)"  doc ");
    static final BytesRef BLOCK_FP = new BytesRef((CharSequence)"  block fp ");
    static final BytesRef BLOCK_VALUE = new BytesRef((CharSequence)"  block value ");
    static final BytesRef SPLIT_COUNT = new BytesRef((CharSequence)"split count ");
    static final BytesRef SPLIT_DIM = new BytesRef((CharSequence)"  split dim ");
    static final BytesRef SPLIT_VALUE = new BytesRef((CharSequence)"  split value ");
    static final BytesRef FIELD_COUNT = new BytesRef((CharSequence)"field count ");
    static final BytesRef FIELD_FP_NAME = new BytesRef((CharSequence)"  field fp name ");
    static final BytesRef FIELD_FP = new BytesRef((CharSequence)"  field fp ");
    static final BytesRef MIN_VALUE = new BytesRef((CharSequence)"min value ");
    static final BytesRef MAX_VALUE = new BytesRef((CharSequence)"max value ");
    static final BytesRef POINT_COUNT = new BytesRef((CharSequence)"point count ");
    static final BytesRef DOC_COUNT = new BytesRef((CharSequence)"doc count ");
    static final BytesRef END = new BytesRef((CharSequence)"END");
    private IndexOutput dataOut;
    final BytesRefBuilder scratch = new BytesRefBuilder();
    final SegmentWriteState writeState;
    final Map<String, Long> indexFPs = new HashMap<String, Long>();

    public SimpleTextPointsWriter(SegmentWriteState writeState) throws IOException {
        String fileName = IndexFileNames.segmentFileName((String)writeState.segmentInfo.name, (String)writeState.segmentSuffix, (String)"dim");
        this.dataOut = writeState.directory.createOutput(fileName, writeState.context);
        this.writeState = writeState;
    }

    public void writeField(final FieldInfo fieldInfo, PointsReader values) throws IOException {
        try (final BKDWriter writer = new BKDWriter(this.writeState.segmentInfo.maxDoc(), this.writeState.directory, this.writeState.segmentInfo.name, fieldInfo.getPointDimensionCount(), fieldInfo.getPointNumBytes(), 1024, 16.0){

            protected void writeIndex(IndexOutput out, long[] leafBlockFPs, byte[] splitPackedValues) throws IOException {
                SimpleTextPointsWriter.this.write(out, NUM_DIMS);
                SimpleTextPointsWriter.this.writeInt(out, this.numDims);
                SimpleTextPointsWriter.this.newline(out);
                SimpleTextPointsWriter.this.write(out, BYTES_PER_DIM);
                SimpleTextPointsWriter.this.writeInt(out, this.bytesPerDim);
                SimpleTextPointsWriter.this.newline(out);
                SimpleTextPointsWriter.this.write(out, MAX_LEAF_POINTS);
                SimpleTextPointsWriter.this.writeInt(out, this.maxPointsInLeafNode);
                SimpleTextPointsWriter.this.newline(out);
                SimpleTextPointsWriter.this.write(out, INDEX_COUNT);
                SimpleTextPointsWriter.this.writeInt(out, leafBlockFPs.length);
                SimpleTextPointsWriter.this.newline(out);
                SimpleTextPointsWriter.this.write(out, MIN_VALUE);
                BytesRef br = new BytesRef(this.minPackedValue, 0, this.minPackedValue.length);
                SimpleTextPointsWriter.this.write(out, br.toString());
                SimpleTextPointsWriter.this.newline(out);
                SimpleTextPointsWriter.this.write(out, MAX_VALUE);
                br = new BytesRef(this.maxPackedValue, 0, this.maxPackedValue.length);
                SimpleTextPointsWriter.this.write(out, br.toString());
                SimpleTextPointsWriter.this.newline(out);
                SimpleTextPointsWriter.this.write(out, POINT_COUNT);
                SimpleTextPointsWriter.this.writeLong(out, this.pointCount);
                SimpleTextPointsWriter.this.newline(out);
                SimpleTextPointsWriter.this.write(out, DOC_COUNT);
                SimpleTextPointsWriter.this.writeInt(out, this.docsSeen.cardinality());
                SimpleTextPointsWriter.this.newline(out);
                for (int i = 0; i < leafBlockFPs.length; ++i) {
                    SimpleTextPointsWriter.this.write(out, BLOCK_FP);
                    SimpleTextPointsWriter.this.writeLong(out, leafBlockFPs[i]);
                    SimpleTextPointsWriter.this.newline(out);
                }
                assert (splitPackedValues.length % (1 + fieldInfo.getPointNumBytes()) == 0);
                int count = splitPackedValues.length / (1 + fieldInfo.getPointNumBytes());
                assert (count == leafBlockFPs.length);
                SimpleTextPointsWriter.this.write(out, SPLIT_COUNT);
                SimpleTextPointsWriter.this.writeInt(out, count);
                SimpleTextPointsWriter.this.newline(out);
                for (int i = 0; i < count; ++i) {
                    SimpleTextPointsWriter.this.write(out, SPLIT_DIM);
                    SimpleTextPointsWriter.this.writeInt(out, splitPackedValues[i * (1 + fieldInfo.getPointNumBytes())] & 0xFF);
                    SimpleTextPointsWriter.this.newline(out);
                    SimpleTextPointsWriter.this.write(out, SPLIT_VALUE);
                    br = new BytesRef(splitPackedValues, 1 + i * (1 + fieldInfo.getPointNumBytes()), fieldInfo.getPointNumBytes());
                    SimpleTextPointsWriter.this.write(out, br.toString());
                    SimpleTextPointsWriter.this.newline(out);
                }
            }

            protected void writeLeafBlockDocs(IndexOutput out, int[] docIDs, int start, int count) throws IOException {
                SimpleTextPointsWriter.this.write(out, BLOCK_COUNT);
                SimpleTextPointsWriter.this.writeInt(out, count);
                SimpleTextPointsWriter.this.newline(out);
                for (int i = 0; i < count; ++i) {
                    SimpleTextPointsWriter.this.write(out, BLOCK_DOC_ID);
                    SimpleTextPointsWriter.this.writeInt(out, docIDs[start + i]);
                    SimpleTextPointsWriter.this.newline(out);
                }
            }

            protected void writeCommonPrefixes(IndexOutput out, int[] commonPrefixLengths, byte[] packedValue) {
            }

            protected void writeLeafBlockPackedValue(IndexOutput out, int[] commonPrefixLengths, byte[] bytes) throws IOException {
                assert (bytes.length == this.packedBytesLength);
                SimpleTextPointsWriter.this.write(out, BLOCK_VALUE);
                SimpleTextPointsWriter.this.write(out, new BytesRef(bytes, 0, bytes.length).toString());
                SimpleTextPointsWriter.this.newline(out);
            }
        };){
            values.intersect(fieldInfo.name, new PointValues.IntersectVisitor(){

                public void visit(int docID) {
                    throw new IllegalStateException();
                }

                public void visit(int docID, byte[] packedValue) throws IOException {
                    writer.add(packedValue, docID);
                }

                public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
                    return PointValues.Relation.CELL_CROSSES_QUERY;
                }
            });
            if (writer.getPointCount() > 0L) {
                this.indexFPs.put(fieldInfo.name, writer.finish(this.dataOut));
            }
        }
    }

    private void write(IndexOutput out, String s) throws IOException {
        SimpleTextUtil.write((DataOutput)out, s, this.scratch);
    }

    private void writeInt(IndexOutput out, int x) throws IOException {
        SimpleTextUtil.write((DataOutput)out, Integer.toString(x), this.scratch);
    }

    private void writeLong(IndexOutput out, long x) throws IOException {
        SimpleTextUtil.write((DataOutput)out, Long.toString(x), this.scratch);
    }

    private void write(IndexOutput out, BytesRef b) throws IOException {
        SimpleTextUtil.write((DataOutput)out, b);
    }

    private void newline(IndexOutput out) throws IOException {
        SimpleTextUtil.writeNewline((DataOutput)out);
    }

    public void finish() throws IOException {
        SimpleTextUtil.write((DataOutput)this.dataOut, END);
        SimpleTextUtil.writeNewline((DataOutput)this.dataOut);
        SimpleTextUtil.writeChecksum(this.dataOut, this.scratch);
    }

    public void close() throws IOException {
        if (this.dataOut != null) {
            this.dataOut.close();
            this.dataOut = null;
            String fileName = IndexFileNames.segmentFileName((String)this.writeState.segmentInfo.name, (String)this.writeState.segmentSuffix, (String)"dii");
            try (IndexOutput indexOut = this.writeState.directory.createOutput(fileName, this.writeState.context);){
                int count = this.indexFPs.size();
                this.write(indexOut, FIELD_COUNT);
                this.write(indexOut, Integer.toString(count));
                this.newline(indexOut);
                for (Map.Entry<String, Long> ent : this.indexFPs.entrySet()) {
                    this.write(indexOut, FIELD_FP_NAME);
                    this.write(indexOut, ent.getKey());
                    this.newline(indexOut);
                    this.write(indexOut, FIELD_FP);
                    this.write(indexOut, Long.toString(ent.getValue()));
                    this.newline(indexOut);
                }
                SimpleTextUtil.writeChecksum(indexOut, this.scratch);
            }
        }
    }
}

