/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.search.sampling;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.lucene.facet.search.FacetArrays;
import org.apache.lucene.facet.search.ScoredDocIDs;
import org.apache.lucene.facet.search.aggregator.Aggregator;
import org.apache.lucene.facet.search.params.FacetRequest;
import org.apache.lucene.facet.search.params.FacetSearchParams;
import org.apache.lucene.facet.search.results.FacetResult;
import org.apache.lucene.facet.search.results.MutableFacetResultNode;
import org.apache.lucene.facet.search.sampling.SampleFixer;
import org.apache.lucene.facet.search.sampling.SamplingParams;
import org.apache.lucene.facet.search.sampling.TakmiSampleFixer;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;
import org.apache.lucene.facet.util.RandomSample;
import org.apache.lucene.facet.util.ScoredDocIdsUtils;
import org.apache.lucene.index.IndexReader;

public class Sampler {
    private static final Logger logger = Logger.getLogger(Sampler.class.getName());
    private final SamplingParams samplingParams;

    public Sampler() {
        this(new SamplingParams());
    }

    public Sampler(SamplingParams params) throws IllegalArgumentException {
        if (!params.validate()) {
            throw new IllegalArgumentException("The provided SamplingParams are not valid!!");
        }
        this.samplingParams = params;
    }

    public boolean shouldSample(ScoredDocIDs docIds) {
        return docIds.size() > this.samplingParams.getSamplingThreshold();
    }

    public SampleResult getSampleSet(ScoredDocIDs docids) throws IOException {
        if (!this.shouldSample(docids)) {
            return new SampleResult(docids, 1.0);
        }
        int actualSize = docids.size();
        int sampleSetSize = (int)((double)actualSize * this.samplingParams.getSampleRatio());
        sampleSetSize = Math.max(sampleSetSize, this.samplingParams.getMinSampleSize());
        sampleSetSize = Math.min(sampleSetSize, this.samplingParams.getMaxSampleSize());
        int[] sampleSet = null;
        try {
            sampleSet = RandomSample.repeatableSample(docids, actualSize, sampleSetSize);
        }
        catch (IOException e) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "sampling failed: " + e.getMessage() + " - falling back to no sampling!", e);
            }
            return new SampleResult(docids, 1.0);
        }
        ScoredDocIDs sampled = ScoredDocIdsUtils.createScoredDocIDsSubset(docids, sampleSet);
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("******************** " + sampled.size());
        }
        return new SampleResult(sampled, (double)sampled.size() / (double)docids.size());
    }

    public SampleFixer getSampleFixer(IndexReader indexReader, TaxonomyReader taxonomyReader, FacetSearchParams searchParams) {
        return new TakmiSampleFixer(indexReader, taxonomyReader, searchParams);
    }

    public final SamplingParams getSamplingParams() {
        return this.samplingParams;
    }

    public FacetResult trimResult(FacetResult facetResult) throws IllegalArgumentException {
        double overSampleFactor = this.getSamplingParams().getOversampleFactor();
        if (overSampleFactor <= 1.0) {
            return facetResult;
        }
        OverSampledFacetRequest sampledFreq = null;
        try {
            sampledFreq = (OverSampledFacetRequest)facetResult.getFacetRequest();
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("It is only valid to call this method with result obtained for afacet request created through sampler.overSamlpingSearchParams()", e);
        }
        FacetRequest origFrq = sampledFreq.orig;
        MutableFacetResultNode trimmedRootNode = MutableFacetResultNode.toImpl(facetResult.getFacetResultNode());
        trimmedRootNode.trimSubResults(origFrq.getNumResults());
        return new FacetResult(origFrq, trimmedRootNode, facetResult.getNumValidDescendants());
    }

    public FacetSearchParams overSampledSearchParams(FacetSearchParams original) {
        FacetSearchParams res = original;
        double overSampleFactor = this.getSamplingParams().getOversampleFactor();
        if (overSampleFactor > 1.0) {
            res = new FacetSearchParams(original.getFacetIndexingParams());
            for (FacetRequest frq : original.getFacetRequests()) {
                int overSampledNumResults = (int)Math.ceil((double)frq.getNumResults() * overSampleFactor);
                res.addFacetRequest(new OverSampledFacetRequest(frq, overSampledNumResults));
            }
        }
        return res;
    }

    private static class OverSampledFacetRequest
    extends FacetRequest {
        final FacetRequest orig;

        public OverSampledFacetRequest(FacetRequest orig, int num) {
            super(orig.getCategoryPath(), num);
            this.orig = orig;
        }

        public Aggregator createAggregator(boolean useComplements, FacetArrays arrays, IndexReader indexReader, TaxonomyReader taxonomy) throws IOException {
            return this.orig.createAggregator(useComplements, arrays, indexReader, taxonomy);
        }

        public double getValueOf(FacetArrays arrays, int idx) {
            return this.orig.getValueOf(arrays, idx);
        }

        public boolean requireDocumentScore() {
            return this.orig.requireDocumentScore();
        }
    }

    public static final class SampleResult {
        public final ScoredDocIDs docids;
        public final double actualSampleRatio;

        protected SampleResult(ScoredDocIDs docids, double actualSampleRatio) {
            this.docids = docids;
            this.actualSampleRatio = actualSampleRatio;
        }
    }
}

