/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.taxonomy.lucene;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.lucene.facet.taxonomy.CategoryPath;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;
import org.apache.lucene.facet.taxonomy.lucene.Consts;
import org.apache.lucene.facet.taxonomy.lucene.ParentArray;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.collections.LRUHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LuceneTaxonomyReader
implements TaxonomyReader {
    private static final Logger logger = Logger.getLogger(LuceneTaxonomyReader.class.getName());
    private IndexReader indexReader;
    private ReadWriteLock indexReaderLock = new ReentrantReadWriteLock();
    private final LRUHashMap<String, Integer> getOrdinalCache;
    private final LRUHashMap<Integer, String> getCategoryCache;
    private ParentArray parentArray;
    private char delimiter = (char)63305;
    private Directory ourDirectory = null;
    private TaxonomyReader.ChildrenArrays childrenArrays;
    Object childrenArraysRebuild = new Object();

    public LuceneTaxonomyReader(Directory directory) throws CorruptIndexException, IOException {
        this.indexReader = this.openIndexReader(directory);
        this.getOrdinalCache = new LRUHashMap(4000);
        this.getCategoryCache = new LRUHashMap(4000);
        this.parentArray = new ParentArray();
        this.parentArray.refresh(this.indexReader);
    }

    protected IndexReader openIndexReader(Directory directory) throws CorruptIndexException, IOException {
        return IndexReader.open((Directory)directory);
    }

    @Deprecated
    public LuceneTaxonomyReader(File parentDir, String name) throws CorruptIndexException, IOException {
        this((Directory)FSDirectory.open((File)new File(parentDir, name)));
        this.ourDirectory = this.indexReader.directory();
    }

    @Deprecated
    public LuceneTaxonomyReader(String parentDir, String name) throws CorruptIndexException, IOException {
        this((Directory)FSDirectory.open((File)new File(parentDir, name)));
        this.ourDirectory = this.indexReader.directory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCacheSize(int size) {
        LRUHashMap<Object, Object> lRUHashMap = this.getCategoryCache;
        synchronized (lRUHashMap) {
            this.getCategoryCache.setMaxSize(size);
        }
        lRUHashMap = this.getOrdinalCache;
        synchronized (lRUHashMap) {
            this.getOrdinalCache.setMaxSize(size);
        }
    }

    public void setDelimiter(char delimiter) {
        this.delimiter = delimiter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getOrdinal(CategoryPath categoryPath) throws IOException {
        if (categoryPath.length() == 0) {
            return 0;
        }
        String path = categoryPath.toString(this.delimiter);
        LRUHashMap<String, Integer> lRUHashMap = this.getOrdinalCache;
        synchronized (lRUHashMap) {
            Integer res = (Integer)this.getOrdinalCache.get(path);
            if (res != null) {
                return res;
            }
        }
        int ret = -1;
        try {
            this.indexReaderLock.readLock().lock();
            TermDocs docs = this.indexReader.termDocs(new Term("$full_path$", path));
            if (docs.next()) {
                ret = docs.doc();
            }
        }
        finally {
            this.indexReaderLock.readLock().unlock();
        }
        LRUHashMap<String, Integer> lRUHashMap2 = this.getOrdinalCache;
        synchronized (lRUHashMap2) {
            this.getOrdinalCache.put(path, ret);
        }
        return ret;
    }

    @Override
    public CategoryPath getPath(int ordinal) throws CorruptIndexException, IOException {
        String label = this.getLabel(ordinal);
        if (label == null) {
            return null;
        }
        return new CategoryPath(label, this.delimiter);
    }

    @Override
    public boolean getPath(int ordinal, CategoryPath result) throws CorruptIndexException, IOException {
        String label = this.getLabel(ordinal);
        if (label == null) {
            return false;
        }
        result.clear();
        result.add(label, this.delimiter);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getLabel(int catID) throws CorruptIndexException, IOException {
        String ret;
        LRUHashMap<Integer, String> lRUHashMap;
        Integer catIDInteger = catID;
        LRUHashMap<Integer, String> lRUHashMap2 = this.getCategoryCache;
        synchronized (lRUHashMap2) {
            String res = (String)this.getCategoryCache.get(catIDInteger);
            if (res != null) {
                return res;
            }
        }
        try {
            this.indexReaderLock.readLock().lock();
            if (catID < 0 || catID >= this.indexReader.maxDoc()) {
                lRUHashMap = null;
                return lRUHashMap;
            }
            ret = this.indexReader.document(catID, Consts.fullPathSelector).get("$full_path$");
        }
        finally {
            this.indexReaderLock.readLock().unlock();
        }
        lRUHashMap = this.getCategoryCache;
        synchronized (lRUHashMap) {
            this.getCategoryCache.put(catIDInteger, ret);
        }
        return ret;
    }

    @Override
    public int getParent(int ordinal) {
        return this.getParentArray()[ordinal];
    }

    @Override
    public int[] getParentArray() {
        return this.parentArray.getArray();
    }

    @Override
    public synchronized void refresh() throws IOException {
        IndexReader r2 = this.indexReader.reopen();
        if (this.indexReader != r2) {
            IndexReader oldreader = this.indexReader;
            this.indexReaderLock.writeLock().lock();
            this.indexReader = r2;
            this.indexReaderLock.writeLock().unlock();
            oldreader.close();
            this.parentArray.refresh(this.indexReader);
            Iterator i = this.getOrdinalCache.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry e = i.next();
                if ((Integer)e.getValue() != -1) continue;
                i.remove();
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.indexReader.close();
        if (this.ourDirectory != null) {
            this.ourDirectory.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSize() {
        this.indexReaderLock.readLock().lock();
        try {
            int n = this.indexReader.numDocs();
            return n;
        }
        finally {
            this.indexReaderLock.readLock().unlock();
        }
    }

    @Override
    public Map<String, String> getCommitUserData() {
        return this.indexReader.getCommitUserData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaxonomyReader.ChildrenArrays getChildrenArrays() {
        Object object = this.childrenArraysRebuild;
        synchronized (object) {
            int i;
            int num = this.getSize();
            int first = this.childrenArrays == null ? 0 : this.childrenArrays.getYoungestChildArray().length;
            if (first == num) {
                return this.childrenArrays;
            }
            int[] newYoungestChildArray = new int[num];
            int[] newOlderSiblingArray = new int[num];
            if (this.childrenArrays != null) {
                System.arraycopy(this.childrenArrays.getYoungestChildArray(), 0, newYoungestChildArray, 0, this.childrenArrays.getYoungestChildArray().length);
                System.arraycopy(this.childrenArrays.getOlderSiblingArray(), 0, newOlderSiblingArray, 0, this.childrenArrays.getOlderSiblingArray().length);
            }
            int[] parents = this.getParentArray();
            for (i = first; i < num; ++i) {
                newYoungestChildArray[i] = -1;
            }
            if (first == 0) {
                first = 1;
                newOlderSiblingArray[0] = -1;
            }
            for (i = first; i < num; ++i) {
                newOlderSiblingArray[i] = newYoungestChildArray[parents[i]];
                newYoungestChildArray[parents[i]] = i;
            }
            this.childrenArrays = new ChildrenArraysImpl(newYoungestChildArray, newOlderSiblingArray);
            return this.childrenArrays;
        }
    }

    public String toString(int max) {
        StringBuilder sb = new StringBuilder();
        int upperl = Math.min(max, this.indexReader.maxDoc());
        for (int i = 0; i < upperl; ++i) {
            try {
                CategoryPath category = this.getPath(i);
                if (category == null) {
                    sb.append(i + ": NULL!! \n");
                    continue;
                }
                if (category.length() == 0) {
                    sb.append(i + ": EMPTY STRING!! \n");
                    continue;
                }
                sb.append(i + ": " + category.toString() + "\n");
                continue;
            }
            catch (IOException e) {
                if (!logger.isLoggable(Level.FINEST)) continue;
                logger.log(Level.FINEST, e.getMessage(), e);
            }
        }
        return sb.toString();
    }

    IndexReader getInternalIndexReader() {
        return this.indexReader;
    }

    @Override
    public void decRef() throws IOException {
        this.indexReader.decRef();
    }

    @Override
    public int getRefCount() {
        return this.indexReader.getRefCount();
    }

    @Override
    public void incRef() {
        this.indexReader.incRef();
    }

    private static final class ChildrenArraysImpl
    implements TaxonomyReader.ChildrenArrays {
        private int[] youngestChildArray;
        private int[] olderSiblingArray;

        public ChildrenArraysImpl(int[] youngestChildArray, int[] olderSiblingArray) {
            this.youngestChildArray = youngestChildArray;
            this.olderSiblingArray = olderSiblingArray;
        }

        public int[] getOlderSiblingArray() {
            return this.olderSiblingArray;
        }

        public int[] getYoungestChildArray() {
            return this.youngestChildArray;
        }
    }
}

