/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.taxonomy.lucene;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.KeywordAnalyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.facet.taxonomy.CategoryPath;
import org.apache.lucene.facet.taxonomy.TaxonomyWriter;
import org.apache.lucene.facet.taxonomy.lucene.ParentArray;
import org.apache.lucene.facet.taxonomy.writercache.TaxonomyWriterCache;
import org.apache.lucene.facet.taxonomy.writercache.cl2o.Cl2oTaxonomyWriterCache;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.LogByteSizeMergePolicy;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.LockObtainFailedException;
import org.apache.lucene.util.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LuceneTaxonomyWriter
implements TaxonomyWriter {
    protected IndexWriter indexWriter;
    private int nextID;
    private char delimiter = (char)63305;
    private SinglePositionTokenStream parentStream = new SinglePositionTokenStream("p");
    private Field parentStreamField;
    private Field fullPathField;
    private TaxonomyWriterCache cache;
    private boolean cacheIsComplete;
    private IndexReader reader;
    private int cacheMisses;
    private boolean alreadyCalledFillCache = false;
    private int cacheMissesUntilFill = 11;
    private ParentArray parentArray;

    public void setDelimiter(char delimiter) {
        this.delimiter = delimiter;
    }

    public static void unlock(Directory directory) throws IOException {
        IndexWriter.unlock((Directory)directory);
    }

    public LuceneTaxonomyWriter(Directory directory, IndexWriterConfig.OpenMode openMode, TaxonomyWriterCache cache) throws CorruptIndexException, LockObtainFailedException, IOException {
        this.openLuceneIndex(directory, openMode);
        this.reader = null;
        this.parentStreamField = new Field("$payloads$", (TokenStream)this.parentStream);
        this.parentStreamField.setOmitNorms(true);
        this.fullPathField = new Field("$full_path$", "", Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS);
        this.fullPathField.setIndexOptions(FieldInfo.IndexOptions.DOCS_ONLY);
        this.nextID = this.indexWriter.maxDoc();
        if (cache == null) {
            cache = LuceneTaxonomyWriter.defaultTaxonomyWriterCache();
        }
        this.cache = cache;
        if (this.nextID == 0) {
            this.cacheIsComplete = true;
            this.addCategory(new CategoryPath());
            this.refreshReader();
        } else {
            this.cacheIsComplete = false;
        }
        this.cacheMisses = 0;
    }

    protected void openLuceneIndex(Directory directory, IndexWriterConfig.OpenMode openMode) throws CorruptIndexException, LockObtainFailedException, IOException {
        IndexWriterConfig config = new IndexWriterConfig(Version.LUCENE_30, (Analyzer)new KeywordAnalyzer()).setOpenMode(openMode).setMergePolicy((MergePolicy)new LogByteSizeMergePolicy());
        this.indexWriter = new IndexWriter(directory, config);
    }

    protected IndexReader openReader() throws IOException {
        return IndexReader.open((IndexWriter)this.indexWriter, (boolean)true);
    }

    public LuceneTaxonomyWriter(Directory directory, IndexWriterConfig.OpenMode openMode) throws CorruptIndexException, LockObtainFailedException, IOException {
        this(directory, openMode, LuceneTaxonomyWriter.defaultTaxonomyWriterCache());
    }

    public static TaxonomyWriterCache defaultTaxonomyWriterCache() {
        return new Cl2oTaxonomyWriterCache(1024, 0.15f, 3);
    }

    public LuceneTaxonomyWriter(Directory d) throws CorruptIndexException, LockObtainFailedException, IOException {
        this(d, IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
    }

    @Override
    public synchronized void close() throws CorruptIndexException, IOException {
        this.closeLuceneIndex();
        this.closeResources();
    }

    public int getCacheMemoryUsage() {
        if (this.cache == null || !(this.cache instanceof Cl2oTaxonomyWriterCache)) {
            return 0;
        }
        return ((Cl2oTaxonomyWriterCache)this.cache).getMemoryUsage();
    }

    protected synchronized void closeResources() throws IOException {
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
        }
        if (this.cache != null) {
            this.cache.close();
            this.cache = null;
        }
    }

    protected void closeLuceneIndex() throws CorruptIndexException, IOException {
        if (this.indexWriter != null) {
            this.indexWriter.close();
            this.indexWriter = null;
        }
    }

    protected int findCategory(CategoryPath categoryPath) throws IOException {
        TermDocs docs;
        int res = this.cache.get(categoryPath);
        if (res >= 0) {
            return res;
        }
        if (this.cacheIsComplete) {
            return -1;
        }
        ++this.cacheMisses;
        if (this.perhapsFillCache()) {
            return this.cache.get(categoryPath);
        }
        if (this.reader == null) {
            this.reader = this.openReader();
        }
        if (!(docs = this.reader.termDocs(new Term("$full_path$", categoryPath.toString(this.delimiter)))).next()) {
            return -1;
        }
        this.addToCache(categoryPath, docs.doc());
        return docs.doc();
    }

    private int findCategory(CategoryPath categoryPath, int prefixLen) throws IOException {
        TermDocs docs;
        int res = this.cache.get(categoryPath, prefixLen);
        if (res >= 0) {
            return res;
        }
        if (this.cacheIsComplete) {
            return -1;
        }
        ++this.cacheMisses;
        if (this.perhapsFillCache()) {
            return this.cache.get(categoryPath, prefixLen);
        }
        if (this.reader == null) {
            this.reader = this.openReader();
        }
        if (!(docs = this.reader.termDocs(new Term("$full_path$", categoryPath.toString(this.delimiter, prefixLen)))).next()) {
            return -1;
        }
        this.addToCache(categoryPath, prefixLen, docs.doc());
        return docs.doc();
    }

    @Override
    public synchronized int addCategory(CategoryPath categoryPath) throws IOException {
        int res = this.findCategory(categoryPath);
        if (res < 0) {
            res = this.internalAddCategory(categoryPath, categoryPath.length());
        }
        return res;
    }

    private int internalAddCategory(CategoryPath categoryPath, int length) throws CorruptIndexException, IOException {
        int parent;
        if (length > 1) {
            parent = this.findCategory(categoryPath, length - 1);
            if (parent < 0) {
                parent = this.internalAddCategory(categoryPath, length - 1);
            }
        } else {
            parent = length == 1 ? 0 : -1;
        }
        int id = this.addCategoryDocument(categoryPath, length, parent);
        return id;
    }

    protected synchronized int addCategoryDocument(CategoryPath categoryPath, int length, int parent) throws CorruptIndexException, IOException {
        this.parentStream.set(parent + 1);
        Document d = new Document();
        d.add((Fieldable)this.parentStreamField);
        this.fullPathField.setValue(categoryPath.toString(this.delimiter, length));
        d.add((Fieldable)this.fullPathField);
        this.indexWriter.addDocument(d);
        int id = this.nextID++;
        this.addToCache(categoryPath, length, id);
        this.getParentArray().add(id, parent);
        return id;
    }

    private void addToCache(CategoryPath categoryPath, int id) throws CorruptIndexException, IOException {
        if (this.cache.put(categoryPath, id)) {
            this.refreshReader();
            this.cacheIsComplete = false;
        }
    }

    private void addToCache(CategoryPath categoryPath, int prefixLen, int id) throws CorruptIndexException, IOException {
        if (this.cache.put(categoryPath, prefixLen, id)) {
            this.refreshReader();
            this.cacheIsComplete = false;
        }
    }

    private synchronized void refreshReader() throws IOException {
        IndexReader r2;
        if (this.reader != null && this.reader != (r2 = this.reader.reopen())) {
            this.reader.close();
            this.reader = r2;
        }
    }

    @Override
    public synchronized void commit() throws CorruptIndexException, IOException {
        this.indexWriter.commit();
        this.refreshReader();
    }

    @Override
    public synchronized void commit(Map<String, String> commitUserData) throws CorruptIndexException, IOException {
        this.indexWriter.commit(commitUserData);
        this.refreshReader();
    }

    @Override
    public synchronized void prepareCommit() throws CorruptIndexException, IOException {
        this.indexWriter.prepareCommit();
    }

    @Override
    public synchronized void prepareCommit(Map<String, String> commitUserData) throws CorruptIndexException, IOException {
        this.indexWriter.prepareCommit(commitUserData);
    }

    @Override
    public synchronized int getSize() {
        return this.indexWriter.maxDoc();
    }

    public void setCacheMissesUntilFill(int i) {
        this.cacheMissesUntilFill = i;
    }

    private boolean perhapsFillCache() throws IOException {
        if (this.cacheMisses < this.cacheMissesUntilFill) {
            return false;
        }
        if (this.alreadyCalledFillCache) {
            return false;
        }
        this.alreadyCalledFillCache = true;
        if (this.reader == null) {
            this.reader = this.openReader();
        }
        if (!this.cache.hasRoom(this.reader.numDocs())) {
            return false;
        }
        CategoryPath cp = new CategoryPath();
        TermDocs td = this.reader.termDocs();
        Term fullPathTerm = new Term("$full_path$");
        String field = fullPathTerm.field();
        TermEnum terms = this.reader.terms(fullPathTerm);
        if (terms.term() != null) {
            Term t;
            while ((t = terms.term()).field() == field) {
                td.seek(t);
                td.next();
                cp.clear();
                cp.add(t.text(), this.delimiter);
                this.cache.put(cp, td.doc());
                if (terms.next()) continue;
            }
        }
        this.cacheIsComplete = true;
        this.reader.close();
        this.reader = null;
        return true;
    }

    private ParentArray getParentArray() throws IOException {
        if (this.parentArray == null) {
            if (this.reader == null) {
                this.reader = this.openReader();
            }
            this.parentArray = new ParentArray();
            this.parentArray.refresh(this.reader);
        }
        return this.parentArray;
    }

    @Override
    public int getParent(int ordinal) throws IOException {
        if (ordinal >= this.getSize()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.getParentArray().getArray()[ordinal];
    }

    public void addTaxonomies(Directory[] taxonomies, OrdinalMap[] ordinalMaps) throws IOException {
        int i;
        IndexReader mainreader = this.openReader();
        TermEnum mainte = mainreader.terms(new Term("$full_path$"));
        IndexReader[] otherreaders = new IndexReader[taxonomies.length];
        TermEnum[] othertes = new TermEnum[taxonomies.length];
        for (int i2 = 0; i2 < taxonomies.length; ++i2) {
            otherreaders[i2] = IndexReader.open((Directory)taxonomies[i2]);
            othertes[i2] = otherreaders[i2].terms(new Term("$full_path$"));
            ordinalMaps[i2].setSize(otherreaders[i2].numDocs());
        }
        CategoryPath cp = new CategoryPath();
        String[] currentOthers = new String[taxonomies.length];
        String currentMain = LuceneTaxonomyWriter.nextTE(mainte);
        int otherTaxonomiesLeft = 0;
        for (i = 0; i < taxonomies.length; ++i) {
            currentOthers[i] = LuceneTaxonomyWriter.nextTE(othertes[i]);
            if (currentOthers[i] == null) continue;
            ++otherTaxonomiesLeft;
        }
        while (otherTaxonomiesLeft > 0) {
            int origordinal;
            String first = null;
            for (int i3 = 0; i3 < taxonomies.length; ++i3) {
                if (currentOthers[i3] == null || first != null && first.compareTo(currentOthers[i3]) <= 0) continue;
                first = currentOthers[i3];
            }
            int comp = 0;
            if (currentMain == null || (comp = currentMain.compareTo(first)) > 0) {
                cp.clear();
                cp.add(first, this.delimiter);
                int newordinal = this.internalAddCategory(cp, cp.length());
                Term t = new Term("$full_path$", first);
                for (int i4 = 0; i4 < taxonomies.length; ++i4) {
                    if (!first.equals(currentOthers[i4])) continue;
                    TermDocs td = otherreaders[i4].termDocs(t);
                    td.next();
                    origordinal = td.doc();
                    ordinalMaps[i4].addMapping(origordinal, newordinal);
                    currentOthers[i4] = LuceneTaxonomyWriter.nextTE(othertes[i4]);
                    if (currentOthers[i4] != null) continue;
                    --otherTaxonomiesLeft;
                }
                continue;
            }
            if (comp == 0) {
                Term t = new Term("$full_path$", first);
                TermDocs td = mainreader.termDocs(t);
                td.next();
                int newordinal = td.doc();
                currentMain = LuceneTaxonomyWriter.nextTE(mainte);
                for (int i5 = 0; i5 < taxonomies.length; ++i5) {
                    if (!first.equals(currentOthers[i5])) continue;
                    td = otherreaders[i5].termDocs(t);
                    td.next();
                    origordinal = td.doc();
                    ordinalMaps[i5].addMapping(origordinal, newordinal);
                    currentOthers[i5] = LuceneTaxonomyWriter.nextTE(othertes[i5]);
                    if (currentOthers[i5] != null) continue;
                    --otherTaxonomiesLeft;
                }
                continue;
            }
            currentMain = LuceneTaxonomyWriter.nextTE(mainte);
        }
        mainreader.close();
        for (i = 0; i < taxonomies.length; ++i) {
            otherreaders[i].close();
            ordinalMaps[i].addMapping(0, 0);
            ordinalMaps[i].addDone();
        }
    }

    private static final String nextTE(TermEnum te) throws IOException {
        if (te.next()) {
            Term t = te.term();
            if (t.field() == "$full_path$") {
                return t.text();
            }
            return null;
        }
        return null;
    }

    public static final class DiskOrdinalMap
    implements OrdinalMap {
        File tmpfile;
        DataOutputStream out;
        int[] map = null;

        public DiskOrdinalMap(File tmpfile) throws FileNotFoundException {
            this.tmpfile = tmpfile;
            this.out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(tmpfile)));
        }

        public void addMapping(int origOrdinal, int newOrdinal) throws IOException {
            this.out.writeInt(origOrdinal);
            this.out.writeInt(newOrdinal);
        }

        public void setSize(int taxonomySize) throws IOException {
            this.out.writeInt(taxonomySize);
        }

        public void addDone() throws IOException {
            if (this.out != null) {
                this.out.close();
                this.out = null;
            }
        }

        public int[] getMap() throws IOException {
            if (this.map != null) {
                return this.map;
            }
            this.addDone();
            DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(this.tmpfile)));
            this.map = new int[in.readInt()];
            for (int i = 0; i < this.map.length; ++i) {
                int newordinal;
                int origordinal = in.readInt();
                this.map[origordinal] = newordinal = in.readInt();
            }
            in.close();
            if (!this.tmpfile.delete()) {
                this.tmpfile.deleteOnExit();
            }
            return this.map;
        }
    }

    public static final class MemoryOrdinalMap
    implements OrdinalMap {
        int[] map;

        public void setSize(int taxonomySize) {
            this.map = new int[taxonomySize];
        }

        public void addMapping(int origOrdinal, int newOrdinal) {
            this.map[origOrdinal] = newOrdinal;
        }

        public void addDone() {
        }

        public int[] getMap() {
            return this.map;
        }
    }

    public static interface OrdinalMap {
        public void setSize(int var1) throws IOException;

        public void addMapping(int var1, int var2) throws IOException;

        public void addDone() throws IOException;

        public int[] getMap() throws IOException;
    }

    private static class SinglePositionTokenStream
    extends TokenStream {
        private CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
        private PositionIncrementAttribute posIncrAtt = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);
        private boolean returned;

        public SinglePositionTokenStream(String word) {
            this.termAtt.setEmpty().append(word);
            this.returned = true;
        }

        public void set(int val) {
            this.posIncrAtt.setPositionIncrement(val);
            this.returned = false;
        }

        public boolean incrementToken() throws IOException {
            if (this.returned) {
                return false;
            }
            this.returned = true;
            return true;
        }
    }
}

