/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.taxonomy.writercache.cl2o;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.Iterator;
import org.apache.lucene.facet.taxonomy.CategoryPath;
import org.apache.lucene.facet.taxonomy.writercache.cl2o.CharBlockArray;
import org.apache.lucene.facet.taxonomy.writercache.cl2o.CollisionMap;
import org.apache.lucene.facet.taxonomy.writercache.cl2o.LabelToOrdinal;

public class CompactLabelToOrdinal
extends LabelToOrdinal {
    public static final float DefaultLoadFactor = 0.15f;
    static final char TerminatorChar = '\uffff';
    private static final int Collision = -5;
    private HashArray[] hashArrays;
    private CollisionMap collisionMap;
    private CharBlockArray labelRepository;
    private int capacity;
    private int threshold;
    private float loadFactor;

    public int sizeOfMap() {
        return this.collisionMap.size();
    }

    private CompactLabelToOrdinal() {
    }

    public CompactLabelToOrdinal(int initialCapacity, float loadFactor, int numHashArrays) {
        this.hashArrays = new HashArray[numHashArrays];
        this.capacity = CompactLabelToOrdinal.determineCapacity((int)Math.pow(2.0, numHashArrays), initialCapacity);
        this.init();
        this.collisionMap = new CollisionMap(this.labelRepository);
        this.counter = 0;
        this.loadFactor = loadFactor;
        this.threshold = (int)(this.loadFactor * (float)this.capacity);
    }

    static int determineCapacity(int minCapacity, int initialCapacity) {
        int capacity;
        for (capacity = minCapacity; capacity < initialCapacity; capacity <<= 1) {
        }
        return capacity;
    }

    private void init() {
        this.labelRepository = new CharBlockArray();
        try {
            new CategoryPath().serializeAppendTo(this.labelRepository);
        }
        catch (IOException e) {
            // empty catch block
        }
        int c = this.capacity;
        for (int i = 0; i < this.hashArrays.length; ++i) {
            this.hashArrays[i] = new HashArray(c);
            c /= 2;
        }
    }

    public void addLabel(CategoryPath label, int ordinal) {
        if (this.collisionMap.size() > this.threshold) {
            this.grow();
        }
        int hash = CompactLabelToOrdinal.stringHashCode(label);
        for (int i = 0; i < this.hashArrays.length; ++i) {
            if (!this.addLabel(this.hashArrays[i], label, hash, ordinal)) continue;
            return;
        }
        int prevVal = this.collisionMap.addLabel(label, hash, ordinal);
        if (prevVal != ordinal) {
            throw new IllegalArgumentException("Label already exists: " + label.toString('/') + " prev ordinal " + prevVal);
        }
    }

    public void addLabel(CategoryPath label, int prefixLen, int ordinal) {
        if (this.collisionMap.size() > this.threshold) {
            this.grow();
        }
        int hash = CompactLabelToOrdinal.stringHashCode(label, prefixLen);
        for (int i = 0; i < this.hashArrays.length; ++i) {
            if (!this.addLabel(this.hashArrays[i], label, prefixLen, hash, ordinal)) continue;
            return;
        }
        int prevVal = this.collisionMap.addLabel(label, prefixLen, hash, ordinal);
        if (prevVal != ordinal) {
            throw new IllegalArgumentException("Label already exists: " + label.toString('/', prefixLen) + " prev ordinal " + prevVal);
        }
    }

    public int getOrdinal(CategoryPath label) {
        if (label == null) {
            return -2;
        }
        int hash = CompactLabelToOrdinal.stringHashCode(label);
        for (int i = 0; i < this.hashArrays.length; ++i) {
            int ord = this.getOrdinal(this.hashArrays[i], label, hash);
            if (ord == -5) continue;
            return ord;
        }
        return this.collisionMap.get(label, hash);
    }

    public int getOrdinal(CategoryPath label, int prefixLen) {
        if (label == null) {
            return -2;
        }
        int hash = CompactLabelToOrdinal.stringHashCode(label, prefixLen);
        for (int i = 0; i < this.hashArrays.length; ++i) {
            int ord = this.getOrdinal(this.hashArrays[i], label, prefixLen, hash);
            if (ord == -5) continue;
            return ord;
        }
        return this.collisionMap.get(label, prefixLen, hash);
    }

    private void grow() {
        int i;
        HashArray temp = this.hashArrays[this.hashArrays.length - 1];
        for (i = this.hashArrays.length - 1; i > 0; --i) {
            this.hashArrays[i] = this.hashArrays[i - 1];
        }
        this.capacity *= 2;
        this.hashArrays[0] = new HashArray(this.capacity);
        for (i = 1; i < this.hashArrays.length; ++i) {
            int[] sourceOffsetArray = this.hashArrays[i].offsets;
            int[] sourceCidsArray = this.hashArrays[i].cids;
            for (int k = 0; k < sourceOffsetArray.length; ++k) {
                for (int j = 0; j < i && sourceOffsetArray[k] != 0; ++j) {
                    int[] targetOffsetArray = this.hashArrays[j].offsets;
                    int[] targetCidsArray = this.hashArrays[j].cids;
                    int newIndex = CompactLabelToOrdinal.indexFor(CompactLabelToOrdinal.stringHashCode(this.labelRepository, sourceOffsetArray[k]), targetOffsetArray.length);
                    if (targetOffsetArray[newIndex] != 0) continue;
                    targetOffsetArray[newIndex] = sourceOffsetArray[k];
                    targetCidsArray[newIndex] = sourceCidsArray[k];
                    sourceOffsetArray[k] = 0;
                }
            }
        }
        for (i = 0; i < temp.offsets.length; ++i) {
            int offset = temp.offsets[i];
            if (offset <= 0) continue;
            int hash = CompactLabelToOrdinal.stringHashCode(this.labelRepository, offset);
            this.addLabelOffset(hash, temp.cids[i], offset);
        }
        CollisionMap oldCollisionMap = this.collisionMap;
        this.collisionMap = new CollisionMap(oldCollisionMap.capacity(), this.labelRepository);
        this.threshold = (int)((float)this.capacity * this.loadFactor);
        Iterator<CollisionMap.Entry> it = oldCollisionMap.entryIterator();
        while (it.hasNext()) {
            CollisionMap.Entry e = it.next();
            this.addLabelOffset(CompactLabelToOrdinal.stringHashCode(this.labelRepository, e.offset), e.cid, e.offset);
        }
    }

    private boolean addLabel(HashArray a, CategoryPath label, int hash, int ordinal) {
        int index = CompactLabelToOrdinal.indexFor(hash, a.offsets.length);
        int offset = a.offsets[index];
        if (offset == 0) {
            a.offsets[index] = this.labelRepository.length();
            try {
                label.serializeAppendTo(this.labelRepository);
            }
            catch (IOException e) {
                // empty catch block
            }
            a.cids[index] = ordinal;
            return true;
        }
        return false;
    }

    private boolean addLabel(HashArray a, CategoryPath label, int prefixLen, int hash, int ordinal) {
        int index = CompactLabelToOrdinal.indexFor(hash, a.offsets.length);
        int offset = a.offsets[index];
        if (offset == 0) {
            a.offsets[index] = this.labelRepository.length();
            try {
                label.serializeAppendTo(prefixLen, this.labelRepository);
            }
            catch (IOException e) {
                // empty catch block
            }
            a.cids[index] = ordinal;
            return true;
        }
        return false;
    }

    private void addLabelOffset(int hash, int cid, int knownOffset) {
        for (int i = 0; i < this.hashArrays.length; ++i) {
            if (!this.addLabelOffsetToHashArray(this.hashArrays[i], hash, cid, knownOffset)) continue;
            return;
        }
        this.collisionMap.addLabelOffset(hash, knownOffset, cid);
        if (this.collisionMap.size() > this.threshold) {
            this.grow();
        }
    }

    private boolean addLabelOffsetToHashArray(HashArray a, int hash, int ordinal, int knownOffset) {
        int index = CompactLabelToOrdinal.indexFor(hash, a.offsets.length);
        int offset = a.offsets[index];
        if (offset == 0) {
            a.offsets[index] = knownOffset;
            a.cids[index] = ordinal;
            return true;
        }
        return false;
    }

    private int getOrdinal(HashArray a, CategoryPath label, int hash) {
        if (label == null) {
            return -2;
        }
        int index = CompactLabelToOrdinal.indexFor(hash, a.offsets.length);
        int offset = a.offsets[index];
        if (offset == 0) {
            return -2;
        }
        if (label.equalsToSerialized(this.labelRepository, offset)) {
            return a.cids[index];
        }
        return -5;
    }

    private int getOrdinal(HashArray a, CategoryPath label, int prefixLen, int hash) {
        if (label == null) {
            return -2;
        }
        int index = CompactLabelToOrdinal.indexFor(hash, a.offsets.length);
        int offset = a.offsets[index];
        if (offset == 0) {
            return -2;
        }
        if (label.equalsToSerialized(prefixLen, this.labelRepository, offset)) {
            return a.cids[index];
        }
        return -5;
    }

    static int indexFor(int h, int length) {
        return h & length - 1;
    }

    static int stringHashCode(CategoryPath label) {
        int hash = label.hashCode();
        hash ^= hash >>> 20 ^ hash >>> 12;
        hash = hash ^ hash >>> 7 ^ hash >>> 4;
        return hash;
    }

    static int stringHashCode(CategoryPath label, int prefixLen) {
        int hash = label.hashCode(prefixLen);
        hash ^= hash >>> 20 ^ hash >>> 12;
        hash = hash ^ hash >>> 7 ^ hash >>> 4;
        return hash;
    }

    static int stringHashCode(CharBlockArray labelRepository, int offset) {
        int hash = CategoryPath.hashCodeOfSerialized(labelRepository, offset);
        hash ^= hash >>> 20 ^ hash >>> 12;
        hash = hash ^ hash >>> 7 ^ hash >>> 4;
        return hash;
    }

    int getMemoryUsage() {
        int memoryUsage = 0;
        if (this.hashArrays != null) {
            for (HashArray ha : this.hashArrays) {
                memoryUsage += ha.capacity * 2 * 4 + 4;
            }
        }
        if (this.labelRepository != null) {
            int blockSize = this.labelRepository.blockSize;
            int actualBlockSize = blockSize * 2 + 4;
            memoryUsage += this.labelRepository.blocks.size() * actualBlockSize;
            memoryUsage += 8;
        }
        if (this.collisionMap != null) {
            memoryUsage += this.collisionMap.getMemoryUsage();
        }
        return memoryUsage;
    }

    static CompactLabelToOrdinal open(File file, float loadFactor, int numHashArrays) throws IOException {
        CompactLabelToOrdinal l2o = new CompactLabelToOrdinal();
        l2o.loadFactor = loadFactor;
        l2o.hashArrays = new HashArray[numHashArrays];
        FilterInputStream dis = null;
        try {
            int offset;
            dis = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
            l2o.counter = ((DataInputStream)dis).readInt();
            l2o.capacity = CompactLabelToOrdinal.determineCapacity((int)Math.pow(2.0, l2o.hashArrays.length), l2o.counter);
            l2o.init();
            l2o.labelRepository = CharBlockArray.open(dis);
            l2o.collisionMap = new CollisionMap(l2o.labelRepository);
            int cid = 0;
            int lastStartOffset = offset = 1;
            while (offset < l2o.labelRepository.length()) {
                int ncomponents;
                int hash = ncomponents = l2o.labelRepository.charAt(offset++);
                if (ncomponents != 0) {
                    int i;
                    int usedchars = 0;
                    for (i = 0; i < ncomponents; ++i) {
                        usedchars = l2o.labelRepository.charAt(offset++);
                        hash = hash * 31 + usedchars;
                    }
                    for (i = 0; i < usedchars; ++i) {
                        hash = hash * 31 + l2o.labelRepository.charAt(offset++);
                    }
                }
                hash ^= hash >>> 20 ^ hash >>> 12;
                hash = hash ^ hash >>> 7 ^ hash >>> 4;
                l2o.addLabelOffset(hash, cid, lastStartOffset);
                ++cid;
                lastStartOffset = offset;
            }
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException("Invalid file format. Cannot deserialize.");
        }
        finally {
            if (dis != null) {
                dis.close();
            }
        }
        l2o.threshold = (int)(l2o.loadFactor * (float)l2o.capacity);
        return l2o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flush(File file) throws IOException {
        FileOutputStream fos = new FileOutputStream(file);
        try {
            BufferedOutputStream os = new BufferedOutputStream(fos);
            DataOutputStream dos = new DataOutputStream(os);
            dos.writeInt(this.counter);
            this.labelRepository.flush(dos);
            dos.close();
        }
        finally {
            fos.close();
        }
    }

    private static final class HashArray {
        int[] offsets;
        int[] cids;
        int capacity;

        HashArray(int c) {
            this.capacity = c;
            this.offsets = new int[this.capacity];
            this.cids = new int[this.capacity];
        }
    }
}

