/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.encoding;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.lucene.util.encoding.DGapIntDecoder;
import org.apache.lucene.util.encoding.IntDecoder;
import org.apache.lucene.util.encoding.IntEncoder;
import org.apache.lucene.util.encoding.IntEncoderFilter;

public class DGapIntEncoder
extends IntEncoderFilter {
    private int prev = 0;

    public DGapIntEncoder(IntEncoder encoder) {
        super(encoder);
    }

    public void encode(int value) throws IOException {
        this.encoder.encode(value - this.prev);
        this.prev = value;
    }

    public IntDecoder createMatchingDecoder() {
        return new DGapIntDecoder(this.encoder.createMatchingDecoder());
    }

    public void reInit(OutputStream out) {
        super.reInit(out);
        this.prev = 0;
    }

    public String toString() {
        return "DGap (" + this.encoder.toString() + ")";
    }
}

