/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.index;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.facet.index.params.CategoryListParams;
import org.apache.lucene.facet.index.params.FacetIndexingParams;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.PayloadProcessorProvider;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.encoding.IntDecoder;
import org.apache.lucene.util.encoding.IntEncoder;

public class FacetsPayloadProcessorProvider
extends PayloadProcessorProvider {
    private final Directory workDir;
    private final PayloadProcessorProvider.ReaderPayloadProcessor dirProcessor;

    public FacetsPayloadProcessorProvider(Directory dir, int[] ordinalMap, FacetIndexingParams indexingParams) {
        this.workDir = dir;
        this.dirProcessor = new FacetsDirPayloadProcessor(indexingParams, ordinalMap);
    }

    public PayloadProcessorProvider.ReaderPayloadProcessor getReaderProcessor(AtomicReader reader) throws IOException {
        if (reader instanceof SegmentReader && this.workDir == ((SegmentReader)reader).directory()) {
            return this.dirProcessor;
        }
        return null;
    }

    public static class FacetsPayloadProcessor
    extends PayloadProcessorProvider.PayloadProcessor {
        private final IntEncoder encoder;
        private final IntDecoder decoder;
        private final int[] ordinalMap;
        private final ByteArrayOutputStream os = new ByteArrayOutputStream();

        protected FacetsPayloadProcessor(CategoryListParams params, int[] ordinalMap) {
            this.encoder = params.createEncoder();
            this.decoder = this.encoder.createMatchingDecoder();
            this.ordinalMap = ordinalMap;
        }

        public void processPayload(BytesRef payload) throws IOException {
            long ordinal;
            ByteArrayInputStream is = new ByteArrayInputStream(payload.bytes, payload.offset, payload.length);
            this.decoder.reInit(is);
            this.os.reset();
            this.encoder.reInit(this.os);
            while ((ordinal = this.decoder.decode()) != 0x100000000L) {
                int newOrdinal = this.ordinalMap[(int)ordinal];
                this.encoder.encode(newOrdinal);
            }
            this.encoder.close();
            byte[] out = this.os.toByteArray();
            payload.bytes = out;
            payload.offset = 0;
            payload.length = out.length;
        }
    }

    public static class FacetsDirPayloadProcessor
    extends PayloadProcessorProvider.ReaderPayloadProcessor {
        private final Map<Term, CategoryListParams> termMap = new HashMap<Term, CategoryListParams>(1);
        private final int[] ordinalMap;

        protected FacetsDirPayloadProcessor(FacetIndexingParams indexingParams, int[] ordinalMap) {
            this.ordinalMap = ordinalMap;
            for (CategoryListParams params : indexingParams.getAllCategoryListParams()) {
                this.termMap.put(params.getTerm(), params);
            }
        }

        public PayloadProcessorProvider.PayloadProcessor getProcessor(String field, BytesRef bytes) throws IOException {
            CategoryListParams params = this.termMap.get(new Term(field, bytes));
            if (params == null) {
                return null;
            }
            return new FacetsPayloadProcessor(params, this.ordinalMap);
        }
    }
}

