/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.index.attributes;

import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import org.apache.lucene.facet.index.attributes.CategoryAttribute;
import org.apache.lucene.facet.index.attributes.CategoryProperty;
import org.apache.lucene.facet.taxonomy.CategoryPath;
import org.apache.lucene.util.AttributeImpl;

public final class CategoryAttributeImpl
extends AttributeImpl
implements CategoryAttribute {
    protected CategoryPath categoryPath;
    protected HashMap<Class<? extends CategoryProperty>, CategoryProperty> properties;

    public CategoryAttributeImpl() {
    }

    public CategoryAttributeImpl(CategoryPath categoryPath) {
        this.setCategoryPath(categoryPath);
    }

    @Override
    public void set(CategoryAttribute other) {
        ((CategoryAttributeImpl)other).copyTo(this);
    }

    @Override
    public CategoryPath getCategoryPath() {
        return this.categoryPath;
    }

    @Override
    public void setCategoryPath(CategoryPath cp) {
        this.categoryPath = cp;
    }

    @Override
    public void addProperty(CategoryProperty property) throws UnsupportedOperationException {
        CategoryProperty existing;
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        if ((existing = this.properties.get(property.getClass())) == null) {
            this.properties.put(property.getClass(), property);
        } else {
            existing.merge(property);
        }
    }

    @Override
    public CategoryProperty getProperty(Class<? extends CategoryProperty> propertyClass) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(propertyClass);
    }

    @Override
    public CategoryProperty getProperty(Collection<Class<? extends CategoryProperty>> propertyClasses) {
        if (this.properties == null) {
            return null;
        }
        for (Class<? extends CategoryProperty> propertyClass : propertyClasses) {
            CategoryProperty categoryProperty = this.properties.get(propertyClass);
            if (categoryProperty == null) continue;
            return categoryProperty;
        }
        return null;
    }

    public void copyTo(AttributeImpl target) {
        ((CategoryAttributeImpl)target).categoryPath = this.categoryPath;
        ((CategoryAttributeImpl)target).properties = this.properties;
    }

    @Override
    public CategoryAttributeImpl clone() {
        CategoryAttributeImpl ca = (CategoryAttributeImpl)super.clone();
        if (this.categoryPath != null) {
            ca.categoryPath = this.categoryPath.clone();
        }
        if (this.properties != null && !this.properties.isEmpty()) {
            ca.properties = (HashMap)this.properties.clone();
        }
        return ca;
    }

    @Override
    public void clear() {
        this.categoryPath = null;
        this.clearProperties();
    }

    @Override
    public void clearProperties() {
        if (this.properties != null) {
            this.properties.clear();
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CategoryAttributeImpl)) {
            return false;
        }
        CategoryAttributeImpl other = (CategoryAttributeImpl)o;
        if (this.categoryPath == null) {
            return other.categoryPath == null;
        }
        if (!this.categoryPath.equals(other.categoryPath)) {
            return false;
        }
        if (this.properties == null || this.properties.isEmpty()) {
            return other.properties == null || other.properties.isEmpty();
        }
        return this.properties.equals(other.properties);
    }

    public int hashCode() {
        if (this.categoryPath == null) {
            return 0;
        }
        int hashCode = this.categoryPath.hashCode();
        if (this.properties != null && !this.properties.isEmpty()) {
            hashCode ^= this.properties.hashCode();
        }
        return hashCode;
    }

    @Override
    public Set<Class<? extends CategoryProperty>> getPropertyClasses() {
        if (this.properties == null || this.properties.isEmpty()) {
            return null;
        }
        return this.properties.keySet();
    }

    @Override
    public void remove(Class<? extends CategoryProperty> propertyClass) {
        this.properties.remove(propertyClass);
    }
}

