/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.index.streaming;

import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.facet.index.attributes.CategoryAttribute;
import org.apache.lucene.facet.index.attributes.CategoryProperty;
import org.apache.lucene.facet.index.attributes.OrdinalProperty;
import org.apache.lucene.facet.index.categorypolicy.OrdinalPolicy;
import org.apache.lucene.facet.index.categorypolicy.PathPolicy;
import org.apache.lucene.facet.index.params.FacetIndexingParams;
import org.apache.lucene.facet.index.streaming.CategoryAttributesStream;
import org.apache.lucene.facet.taxonomy.CategoryPath;
import org.apache.lucene.facet.taxonomy.TaxonomyWriter;

public class CategoryParentsStream
extends TokenFilter {
    protected TaxonomyWriter taxonomyWriter;
    protected CategoryAttribute categoryAttribute = (CategoryAttribute)this.addAttribute(CategoryAttribute.class);
    protected OrdinalProperty ordinalProperty;
    private Set<Class<? extends CategoryProperty>> retainableProperties;
    private PathPolicy pathPolicy;
    private OrdinalPolicy ordinalPolicy;

    public CategoryParentsStream(CategoryAttributesStream input, TaxonomyWriter taxonomyWriter, FacetIndexingParams indexingParams) {
        super((TokenStream)input);
        this.taxonomyWriter = taxonomyWriter;
        this.pathPolicy = indexingParams.getPathPolicy();
        this.ordinalPolicy = indexingParams.getOrdinalPolicy();
        this.ordinalPolicy.init(taxonomyWriter);
        this.ordinalProperty = new OrdinalProperty();
    }

    public final boolean incrementToken() throws IOException {
        if (this.categoryAttribute.getCategoryPath() != null) {
            CategoryPath cp;
            this.clearCategoryProperties();
            boolean added = false;
            int ordinal = this.ordinalProperty.getOrdinal();
            if (ordinal != -1) {
                if (this.ordinalPolicy.shouldAdd(ordinal = this.taxonomyWriter.getParent(ordinal))) {
                    this.ordinalProperty.setOrdinal(ordinal);
                    try {
                        this.categoryAttribute.addProperty(this.ordinalProperty);
                    }
                    catch (UnsupportedOperationException e) {
                        throw new IOException(e.getLocalizedMessage());
                    }
                    added = true;
                } else {
                    this.ordinalProperty.setOrdinal(-1);
                }
            }
            if ((cp = this.categoryAttribute.getCategoryPath()) != null) {
                cp.trim(1);
                if (added || this.pathPolicy.shouldAdd(cp)) {
                    this.categoryAttribute.setCategoryPath(cp);
                    added = true;
                } else {
                    this.categoryAttribute.clear();
                }
            }
            if (added) {
                return true;
            }
        }
        if (this.input.incrementToken()) {
            int ordinal = this.taxonomyWriter.addCategory(this.categoryAttribute.getCategoryPath());
            this.ordinalProperty.setOrdinal(ordinal);
            try {
                this.categoryAttribute.addProperty(this.ordinalProperty);
            }
            catch (UnsupportedOperationException e) {
                throw new IOException(e.getLocalizedMessage());
            }
            return true;
        }
        return false;
    }

    protected void clearCategoryProperties() {
        if (this.retainableProperties == null || this.retainableProperties.isEmpty()) {
            this.categoryAttribute.clearProperties();
        } else {
            LinkedList<Class<? extends CategoryProperty>> propertyClassesToRemove = new LinkedList<Class<? extends CategoryProperty>>();
            for (Class<? extends CategoryProperty> propertyClass : this.categoryAttribute.getPropertyClasses()) {
                if (this.retainableProperties.contains(propertyClass)) continue;
                propertyClassesToRemove.add(propertyClass);
            }
            for (Class<? extends CategoryProperty> propertyClass : propertyClassesToRemove) {
                this.categoryAttribute.remove(propertyClass);
            }
        }
    }

    public void addRetainableProperty(Class<? extends CategoryProperty> toRetain) {
        if (this.retainableProperties == null) {
            this.retainableProperties = new HashSet<Class<? extends CategoryProperty>>();
        }
        this.retainableProperties.add(toRetain);
    }
}

