/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.index.streaming;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.facet.index.CategoryListPayloadStream;
import org.apache.lucene.facet.index.attributes.OrdinalProperty;
import org.apache.lucene.facet.index.params.CategoryListParams;
import org.apache.lucene.facet.index.params.FacetIndexingParams;
import org.apache.lucene.facet.index.streaming.CategoryListTokenizer;
import org.apache.lucene.facet.taxonomy.CategoryPath;
import org.apache.lucene.facet.util.PartitionsUtils;
import org.apache.lucene.util.encoding.IntEncoder;

public class CountingListTokenizer
extends CategoryListTokenizer {
    protected HashMap<String, CategoryListPayloadStream> payloadStreamsByName = new HashMap();
    protected Iterator<Map.Entry<String, CategoryListPayloadStream>> payloadStreamIterator;

    public CountingListTokenizer(TokenStream input, FacetIndexingParams indexingParams) {
        super(input, indexingParams);
    }

    @Override
    protected void handleStartOfInput() throws IOException {
        this.payloadStreamsByName.clear();
        this.payloadStreamIterator = null;
    }

    @Override
    public final boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            OrdinalProperty ordinalProperty;
            if (this.categoryAttribute != null && (ordinalProperty = (OrdinalProperty)this.categoryAttribute.getProperty(OrdinalProperty.class)) != null && this.legalCategory()) {
                CategoryPath categoryPath = this.categoryAttribute.getCategoryPath();
                int ordinal = ordinalProperty.getOrdinal();
                CategoryListPayloadStream payloadStream = this.getPayloadStream(categoryPath, ordinal);
                int partitionSize = this.indexingParams.getPartitionSize();
                payloadStream.appendIntToStream(ordinal % partitionSize);
            }
            return true;
        }
        if (this.payloadStreamIterator == null) {
            this.handleEndOfInput();
            this.payloadStreamIterator = this.payloadStreamsByName.entrySet().iterator();
        }
        if (this.payloadStreamIterator.hasNext()) {
            Map.Entry<String, CategoryListPayloadStream> entry = this.payloadStreamIterator.next();
            String countingListName = entry.getKey();
            int length = countingListName.length();
            this.termAttribute.resizeBuffer(length);
            countingListName.getChars(0, length, this.termAttribute.buffer(), 0);
            this.termAttribute.setLength(length);
            CategoryListPayloadStream payloadStream = entry.getValue();
            this.payload.bytes = payloadStream.convertStreamToByteArray();
            this.payload.offset = 0;
            this.payload.length = this.payload.bytes.length;
            this.payloadAttribute.setPayload(this.payload);
            return true;
        }
        return false;
    }

    protected boolean legalCategory() {
        return true;
    }

    protected CategoryListPayloadStream getPayloadStream(CategoryPath categoryPath, int ordinal) throws IOException {
        CategoryListParams clParams = this.indexingParams.getCategoryListParams(categoryPath);
        String name = PartitionsUtils.partitionNameByOrdinal(this.indexingParams, clParams, ordinal);
        CategoryListPayloadStream fps = this.payloadStreamsByName.get(name);
        if (fps == null) {
            IntEncoder encoder = clParams.createEncoder();
            fps = new CategoryListPayloadStream(encoder);
            this.payloadStreamsByName.put(name, fps);
        }
        return fps;
    }
}

