/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.search;

import org.apache.lucene.facet.index.params.CategoryListParams;
import org.apache.lucene.facet.index.params.FacetIndexingParams;
import org.apache.lucene.facet.search.params.FacetSearchParams;
import org.apache.lucene.facet.taxonomy.CategoryPath;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

public final class DrillDown {
    public static final Term term(FacetSearchParams sParams, CategoryPath path) {
        return DrillDown.term(sParams.getFacetIndexingParams(), path);
    }

    public static final Term term(FacetIndexingParams iParams, CategoryPath path) {
        CategoryListParams clp = iParams.getCategoryListParams(path);
        char[] buffer = new char[path.charsNeededForFullPath()];
        iParams.drillDownTermText(path, buffer);
        return new Term(clp.getTerm().field(), String.valueOf(buffer));
    }

    public static final Query query(FacetIndexingParams iParams, CategoryPath ... paths) {
        if (paths == null || paths.length == 0) {
            throw new IllegalArgumentException("Empty category path not allowed for drill down query!");
        }
        if (paths.length == 1) {
            return new TermQuery(DrillDown.term(iParams, paths[0]));
        }
        BooleanQuery res = new BooleanQuery();
        for (CategoryPath cp : paths) {
            res.add((Query)new TermQuery(DrillDown.term(iParams, cp)), BooleanClause.Occur.MUST);
        }
        return res;
    }

    public static final Query query(FacetSearchParams sParams, CategoryPath ... paths) {
        return DrillDown.query(sParams.getFacetIndexingParams(), paths);
    }

    public static final Query query(FacetIndexingParams iParams, Query baseQuery, CategoryPath ... paths) {
        BooleanQuery res = new BooleanQuery();
        res.add(baseQuery, BooleanClause.Occur.MUST);
        res.add(DrillDown.query(iParams, paths), BooleanClause.Occur.MUST);
        return res;
    }

    public static final Query query(FacetSearchParams sParams, Query baseQuery, CategoryPath ... paths) {
        return DrillDown.query(sParams.getFacetIndexingParams(), baseQuery, paths);
    }

    public static final Query query(Query baseQuery, CategoryPath ... paths) {
        return DrillDown.query(new FacetSearchParams(), baseQuery, paths);
    }
}

