/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.search;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.facet.search.ScoredDocIDs;
import org.apache.lucene.facet.search.params.FacetRequest;
import org.apache.lucene.facet.search.params.FacetSearchParams;
import org.apache.lucene.facet.search.results.FacetResult;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;
import org.apache.lucene.index.IndexReader;

public abstract class FacetsAccumulator {
    public static final double DEFAULT_COMPLEMENT_THRESHOLD = 0.6;
    public static final double DISABLE_COMPLEMENT = Double.POSITIVE_INFINITY;
    public static final double FORCE_COMPLEMENT = 0.0;
    private double complementThreshold = 0.6;
    protected final TaxonomyReader taxonomyReader;
    protected final IndexReader indexReader;
    protected FacetSearchParams searchParams;
    private boolean allowLabeling = true;

    public FacetsAccumulator(FacetSearchParams searchParams, IndexReader indexReader, TaxonomyReader taxonomyReader) {
        this.indexReader = indexReader;
        this.taxonomyReader = taxonomyReader;
        this.searchParams = searchParams;
    }

    public abstract List<FacetResult> accumulate(ScoredDocIDs var1) throws IOException;

    public double getComplementThreshold() {
        return this.complementThreshold;
    }

    public void setComplementThreshold(double complementThreshold) {
        this.complementThreshold = complementThreshold;
    }

    protected boolean isAllowLabeling() {
        return this.allowLabeling;
    }

    protected void setAllowLabeling(boolean allowLabeling) {
        this.allowLabeling = allowLabeling;
    }

    protected boolean mayComplement() {
        for (FacetRequest freq : this.searchParams.getFacetRequests()) {
            if (freq.supportsComplements()) continue;
            return false;
        }
        return true;
    }
}

