/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.search;

import java.io.IOException;
import org.apache.lucene.index.DocsAndPositionsEnum;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.index.Term;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;

public class PayloadIterator {
    protected byte[] buffer;
    protected int payloadLength;
    DocsAndPositionsEnum tp;
    private boolean hasMore;

    public PayloadIterator(IndexReader indexReader, Term term) throws IOException {
        this(indexReader, term, new byte[1024]);
    }

    public PayloadIterator(IndexReader indexReader, Term term, byte[] buffer) throws IOException {
        this.buffer = buffer;
        Bits liveDocs = MultiFields.getLiveDocs((IndexReader)indexReader);
        this.tp = MultiFields.getTermPositionsEnum((IndexReader)indexReader, (Bits)liveDocs, (String)term.field(), (BytesRef)term.bytes(), (int)2);
    }

    public boolean init() throws IOException {
        this.hasMore = this.tp != null && this.tp.nextDoc() != Integer.MAX_VALUE;
        return this.hasMore;
    }

    public boolean setdoc(int docId) throws IOException {
        if (!this.hasMore) {
            return false;
        }
        if (this.tp.docID() > docId) {
            return false;
        }
        if (this.tp.docID() < docId) {
            if (this.tp.advance(docId) == Integer.MAX_VALUE) {
                this.hasMore = false;
                return false;
            }
            if (this.tp.docID() != docId) {
                return false;
            }
        }
        this.tp.nextPosition();
        if (!this.tp.hasPayload()) {
            return false;
        }
        BytesRef br = this.tp.getPayload();
        if (br == null || br.length == 0) {
            return false;
        }
        this.payloadLength = br.length;
        if (this.payloadLength > this.buffer.length) {
            this.buffer = new byte[this.payloadLength * 2 + 1];
        }
        System.arraycopy(br.bytes, br.offset, this.buffer, 0, this.payloadLength);
        return true;
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public int getPayloadLength() {
        return this.payloadLength;
    }
}

