/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.search;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.facet.search.FacetArrays;
import org.apache.lucene.facet.search.FacetResultsHandler;
import org.apache.lucene.facet.search.Heap;
import org.apache.lucene.facet.search.params.FacetRequest;
import org.apache.lucene.facet.search.results.FacetResult;
import org.apache.lucene.facet.search.results.FacetResultNode;
import org.apache.lucene.facet.search.results.IntermediateFacetResult;
import org.apache.lucene.facet.search.results.MutableFacetResultNode;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;
import org.apache.lucene.facet.util.ResultSortUtils;

public class TopKFacetResultsHandler
extends FacetResultsHandler {
    public TopKFacetResultsHandler(TaxonomyReader taxonomyReader, FacetRequest facetRequest) {
        super(taxonomyReader, facetRequest);
    }

    @Override
    public IntermediateFacetResult fetchPartitionResult(FacetArrays facetArrays, int offset) throws IOException {
        TopKFacetResult res = null;
        int ordinal = this.taxonomyReader.getOrdinal(this.facetRequest.getCategoryPath());
        if (ordinal != -1) {
            double value = 0.0;
            if (this.isSelfPartition(ordinal, facetArrays, offset)) {
                int partitionSize = facetArrays.getArraysLength();
                value = this.facetRequest.getValueOf(facetArrays, ordinal % partitionSize);
            }
            MutableFacetResultNode parentResultNode = new MutableFacetResultNode(ordinal, value);
            Heap<FacetResultNode> heap = ResultSortUtils.createSuitableHeap(this.facetRequest);
            int totalFacets = this.heapDescendants(ordinal, heap, parentResultNode, facetArrays, offset);
            res = new TopKFacetResult(this.facetRequest, parentResultNode, totalFacets);
            res.setHeap(heap);
        }
        return res;
    }

    @Override
    public IntermediateFacetResult mergeResults(IntermediateFacetResult ... tmpResults) throws IOException {
        int ordinal = this.taxonomyReader.getOrdinal(this.facetRequest.getCategoryPath());
        MutableFacetResultNode resNode = new MutableFacetResultNode(ordinal, 0.0);
        int totalFacets = 0;
        Heap<FacetResultNode> heap = null;
        for (IntermediateFacetResult tmpFres : tmpResults) {
            TopKFacetResult fres = (TopKFacetResult)tmpFres;
            totalFacets += fres.getNumValidDescendants();
            resNode.increaseValue(fres.getFacetResultNode().getValue());
            Heap<FacetResultNode> tmpHeap = fres.getHeap();
            if (heap == null) {
                heap = tmpHeap;
                continue;
            }
            for (int i = tmpHeap.size(); i > 0; --i) {
                FacetResultNode a = heap.insertWithOverflow(tmpHeap.pop());
                if (a == null) continue;
                resNode.increaseResidue(a.getResidue());
            }
        }
        TopKFacetResult res = new TopKFacetResult(this.facetRequest, resNode, totalFacets);
        res.setHeap(heap);
        return res;
    }

    private int heapDescendants(int ordinal, Heap<FacetResultNode> pq, MutableFacetResultNode parentResultNode, FacetArrays facetArrays, int offset) {
        int partitionSize = facetArrays.getArraysLength();
        int endOffset = offset + partitionSize;
        TaxonomyReader.ChildrenArrays childrenArray = this.taxonomyReader.getChildrenArrays();
        int[] youngestChild = childrenArray.getYoungestChildArray();
        int[] olderSibling = childrenArray.getOlderSiblingArray();
        FacetResultNode reusable = null;
        int localDepth = 0;
        int depth = this.facetRequest.getDepth();
        int[] ordinalStack = new int[2 + Math.min(Short.MAX_VALUE, depth)];
        int childrenCounter = 0;
        int yc = youngestChild[ordinal];
        while (yc >= endOffset) {
            yc = olderSibling[yc];
        }
        ordinalStack[++localDepth] = yc;
        while (localDepth > 0) {
            int relativeOrdinal;
            double value;
            int tosOrdinal = ordinalStack[localDepth];
            if (tosOrdinal == -1) {
                ordinalStack[--localDepth] = olderSibling[ordinalStack[localDepth]];
                continue;
            }
            if (tosOrdinal >= offset && (value = this.facetRequest.getValueOf(facetArrays, relativeOrdinal = tosOrdinal % partitionSize)) != 0.0 && !Double.isNaN(value)) {
                if (reusable == null) {
                    reusable = new MutableFacetResultNode(tosOrdinal, value);
                } else {
                    ((MutableFacetResultNode)reusable).reset(tosOrdinal, value);
                }
                ++childrenCounter;
                reusable = pq.insertWithOverflow(reusable);
                if (reusable != null) {
                    parentResultNode.increaseResidue(reusable.getValue());
                }
            }
            if (localDepth < depth) {
                yc = youngestChild[tosOrdinal];
                while (yc >= endOffset) {
                    yc = olderSibling[yc];
                }
                ordinalStack[++localDepth] = yc;
                continue;
            }
            ordinalStack[++localDepth] = -1;
        }
        return childrenCounter;
    }

    @Override
    public FacetResult renderFacetResult(IntermediateFacetResult tmpResult) {
        TopKFacetResult res = (TopKFacetResult)tmpResult;
        if (res != null) {
            Heap<FacetResultNode> heap = res.getHeap();
            MutableFacetResultNode resNode = (MutableFacetResultNode)res.getFacetResultNode();
            for (int i = heap.size(); i > 0; --i) {
                resNode.insertSubResult(heap.pop());
            }
        }
        return res;
    }

    @Override
    public FacetResult rearrangeFacetResult(FacetResult facetResult) {
        TopKFacetResult res = (TopKFacetResult)facetResult;
        Heap<FacetResultNode> heap = res.getHeap();
        heap.clear();
        MutableFacetResultNode topFrn = (MutableFacetResultNode)res.getFacetResultNode();
        for (FacetResultNode facetResultNode : topFrn.getSubResults()) {
            heap.add(facetResultNode);
        }
        int size = heap.size();
        ArrayList<FacetResultNode> arrayList = new ArrayList<FacetResultNode>(size);
        for (int i = heap.size(); i > 0; --i) {
            arrayList.add(0, heap.pop());
        }
        topFrn.setSubResults(arrayList);
        return res;
    }

    @Override
    public void labelResult(FacetResult facetResult) throws IOException {
        FacetResultNode facetResultNode;
        if (facetResult != null && (facetResultNode = facetResult.getFacetResultNode()) != null) {
            facetResultNode.getLabel(this.taxonomyReader);
            int num2label = this.facetRequest.getNumLabel();
            for (FacetResultNode facetResultNode2 : facetResultNode.getSubResults()) {
                if (--num2label < 0) break;
                facetResultNode2.getLabel(this.taxonomyReader);
            }
        }
    }

    private static class TopKFacetResult
    extends FacetResult
    implements IntermediateFacetResult {
        private Heap<FacetResultNode> heap;

        TopKFacetResult(FacetRequest facetRequest, MutableFacetResultNode facetResultNode, int totalFacets) {
            super(facetRequest, facetResultNode, totalFacets);
        }

        public Heap<FacetResultNode> getHeap() {
            return this.heap;
        }

        public void setHeap(Heap<FacetResultNode> heap) {
            this.heap = heap;
        }
    }
}

