/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.search;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.lucene.facet.index.params.CategoryListParams;
import org.apache.lucene.facet.index.params.FacetIndexingParams;
import org.apache.lucene.facet.search.CategoryListIterator;
import org.apache.lucene.facet.search.FacetArrays;
import org.apache.lucene.facet.search.FacetsAccumulator;
import org.apache.lucene.facet.search.StandardFacetsAccumulator;
import org.apache.lucene.facet.search.aggregator.Aggregator;
import org.apache.lucene.facet.search.aggregator.CountingAggregator;
import org.apache.lucene.facet.search.cache.CategoryListCache;
import org.apache.lucene.facet.search.cache.CategoryListData;
import org.apache.lucene.facet.search.params.FacetSearchParams;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;
import org.apache.lucene.facet.util.PartitionsUtils;
import org.apache.lucene.facet.util.ScoredDocIdsUtils;
import org.apache.lucene.index.IndexReader;

public class TotalFacetCounts {
    private int[][] totalCounts = null;
    private final TaxonomyReader taxonomy;
    private final FacetIndexingParams facetIndexingParams;
    private static final AtomicInteger atomicGen4Test = new AtomicInteger(1);
    final int gen4test;
    final CreationType createType4test;

    private TotalFacetCounts(TaxonomyReader taxonomy, FacetIndexingParams facetIndexingParams, int[][] counts, CreationType createType4Test) {
        this.taxonomy = taxonomy;
        this.facetIndexingParams = facetIndexingParams;
        this.totalCounts = counts;
        this.createType4test = createType4Test;
        this.gen4test = atomicGen4Test.incrementAndGet();
    }

    public void fillTotalCountsForPartition(int[] partitionArray, int partition) {
        int partitionSize = partitionArray.length;
        int[] countArray = this.totalCounts[partition];
        if (countArray == null) {
            countArray = new int[partitionSize];
            this.totalCounts[partition] = countArray;
        }
        int length = Math.min(partitionSize, countArray.length);
        System.arraycopy(countArray, 0, partitionArray, 0, length);
    }

    public int getTotalCount(int ordinal) {
        int partition = PartitionsUtils.partitionNumber(this.facetIndexingParams, ordinal);
        int offset = ordinal % PartitionsUtils.partitionSize(this.facetIndexingParams, this.taxonomy);
        return this.totalCounts[partition][offset];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static TotalFacetCounts loadFromFile(File inputFile, TaxonomyReader taxonomy, FacetIndexingParams facetIndexingParams) throws IOException {
        DataInputStream dis = new DataInputStream(new BufferedInputStream(new FileInputStream(inputFile)));
        try {
            int[][] counts = new int[dis.readInt()][];
            for (int i = 0; i < counts.length; ++i) {
                int size = dis.readInt();
                if (size < 0) {
                    counts[i] = null;
                    continue;
                }
                counts[i] = new int[size];
                for (int j = 0; j < size; ++j) {
                    counts[i][j] = dis.readInt();
                }
            }
            TotalFacetCounts totalFacetCounts = new TotalFacetCounts(taxonomy, facetIndexingParams, counts, CreationType.Loaded);
            return totalFacetCounts;
        }
        finally {
            dis.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void storeToFile(File outputFile, TotalFacetCounts tfc) throws IOException {
        DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(outputFile)));
        try {
            dos.writeInt(tfc.totalCounts.length);
            for (int[] counts : tfc.totalCounts) {
                if (counts == null) {
                    dos.writeInt(-1);
                    continue;
                }
                dos.writeInt(counts.length);
                for (int i : counts) {
                    dos.writeInt(i);
                }
            }
        }
        finally {
            dos.close();
        }
    }

    static TotalFacetCounts compute(IndexReader indexReader, TaxonomyReader taxonomy, final FacetIndexingParams facetIndexingParams, final CategoryListCache clCache) throws IOException {
        int partitionSize = PartitionsUtils.partitionSize(facetIndexingParams, taxonomy);
        final int[][] counts = new int[(int)Math.ceil((float)taxonomy.getSize() / (float)partitionSize)][partitionSize];
        FacetSearchParams newSearchParams = new FacetSearchParams(facetIndexingParams);
        StandardFacetsAccumulator fe = new StandardFacetsAccumulator(newSearchParams, indexReader, taxonomy){

            @Override
            protected HashMap<CategoryListIterator, Aggregator> getCategoryListMap(FacetArrays facetArrays, int partition) throws IOException {
                CountingAggregator aggregator = new CountingAggregator(counts[partition]);
                HashMap<CategoryListIterator, Aggregator> map = new HashMap<CategoryListIterator, Aggregator>();
                for (CategoryListParams clp : facetIndexingParams.getAllCategoryListParams()) {
                    CategoryListIterator cli = TotalFacetCounts.clIteraor(clCache, clp, this.indexReader, partition);
                    map.put(cli, aggregator);
                }
                return map;
            }
        };
        fe.setComplementThreshold(Double.POSITIVE_INFINITY);
        ((FacetsAccumulator)fe).accumulate(ScoredDocIdsUtils.createAllDocsScoredDocIDs(indexReader));
        return new TotalFacetCounts(taxonomy, facetIndexingParams, counts, CreationType.Computed);
    }

    static CategoryListIterator clIteraor(CategoryListCache clCache, CategoryListParams clp, IndexReader indexReader, int partition) throws IOException {
        CategoryListData cld;
        if (clCache != null && (cld = clCache.get(clp)) != null) {
            return cld.iterator(partition);
        }
        return clp.createCategoryListIterator(indexReader, partition);
    }

    static enum CreationType {
        Computed,
        Loaded;

    }
}

