/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.search.params;

import org.apache.lucene.facet.search.FacetArrays;
import org.apache.lucene.facet.search.aggregator.Aggregator;
import org.apache.lucene.facet.search.aggregator.ComplementCountingAggregator;
import org.apache.lucene.facet.search.aggregator.CountingAggregator;
import org.apache.lucene.facet.search.params.FacetRequest;
import org.apache.lucene.facet.taxonomy.CategoryPath;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;
import org.apache.lucene.index.IndexReader;

public class CountFacetRequest
extends FacetRequest {
    public CountFacetRequest(CategoryPath path, int num) {
        super(path, num);
    }

    @Override
    public Aggregator createAggregator(boolean useComplements, FacetArrays arrays, IndexReader reader, TaxonomyReader taxonomy) {
        int[] a = arrays.getIntArray();
        if (useComplements) {
            return new ComplementCountingAggregator(a);
        }
        return new CountingAggregator(a);
    }

    @Override
    public double getValueOf(FacetArrays arrays, int ordinal) {
        return arrays.getIntArray()[ordinal];
    }

    @Override
    public boolean supportsComplements() {
        return true;
    }

    @Override
    public boolean requireDocumentScore() {
        return false;
    }
}

