/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.taxonomy.directory;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.core.KeywordAnalyzer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.facet.taxonomy.CategoryPath;
import org.apache.lucene.facet.taxonomy.TaxonomyWriter;
import org.apache.lucene.facet.taxonomy.directory.ParentArray;
import org.apache.lucene.facet.taxonomy.writercache.TaxonomyWriterCache;
import org.apache.lucene.facet.taxonomy.writercache.cl2o.Cl2oTaxonomyWriterCache;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LogByteSizeMergePolicy;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.ReaderManager;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.index.TieredMergePolicy;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.Version;

public class DirectoryTaxonomyWriter
implements TaxonomyWriter {
    public static final String INDEX_CREATE_TIME = "index.create.time";
    private final Directory dir;
    private final IndexWriter indexWriter;
    private final TaxonomyWriterCache cache;
    private final AtomicInteger cacheMisses = new AtomicInteger(0);
    private String createTime;
    private char delimiter = (char)63305;
    private SinglePositionTokenStream parentStream = new SinglePositionTokenStream("p");
    private Field parentStreamField;
    private Field fullPathField;
    private int cacheMissesUntilFill = 11;
    private boolean shouldFillCache = true;
    private volatile boolean cacheIsComplete;
    private volatile ReaderManager readerManager;
    private volatile boolean shouldRefreshReaderManager;
    private volatile boolean isClosed = false;
    private volatile ParentArray parentArray;
    private volatile int nextID;

    private static Map<String, String> readCommitData(Directory dir) throws IOException {
        SegmentInfos infos = new SegmentInfos();
        infos.read(dir);
        return infos.getUserData();
    }

    public void setDelimiter(char delimiter) {
        this.ensureOpen();
        this.delimiter = delimiter;
    }

    public static void unlock(Directory directory) throws IOException {
        IndexWriter.unlock((Directory)directory);
    }

    public DirectoryTaxonomyWriter(Directory directory, IndexWriterConfig.OpenMode openMode, TaxonomyWriterCache cache) throws IOException {
        Map<String, String> commitData;
        this.createTime = !DirectoryReader.indexExists((Directory)directory) || openMode == IndexWriterConfig.OpenMode.CREATE ? Long.toString(System.nanoTime()) : ((commitData = DirectoryTaxonomyWriter.readCommitData(directory)) != null ? commitData.get(INDEX_CREATE_TIME) : null);
        this.dir = directory;
        IndexWriterConfig config = this.createIndexWriterConfig(openMode);
        this.indexWriter = this.openIndexWriter(this.dir, config);
        assert (!(this.indexWriter.getConfig().getMergePolicy() instanceof TieredMergePolicy)) : "for preserving category docids, merging none-adjacent segments is not allowed";
        FieldType ft = new FieldType(TextField.TYPE_NOT_STORED);
        ft.setOmitNorms(true);
        this.parentStreamField = new Field("$payloads$", (TokenStream)this.parentStream, ft);
        this.fullPathField = new StringField("$full_path$", "", Field.Store.YES);
        this.nextID = this.indexWriter.maxDoc();
        if (cache == null) {
            cache = DirectoryTaxonomyWriter.defaultTaxonomyWriterCache();
        }
        this.cache = cache;
        if (this.nextID == 0) {
            this.cacheIsComplete = true;
            this.addCategory(new CategoryPath());
        } else {
            this.cacheIsComplete = false;
        }
    }

    protected IndexWriter openIndexWriter(Directory directory, IndexWriterConfig config) throws IOException {
        return new IndexWriter(directory, config);
    }

    protected IndexWriterConfig createIndexWriterConfig(IndexWriterConfig.OpenMode openMode) {
        return new IndexWriterConfig(Version.LUCENE_40, (Analyzer)new KeywordAnalyzer()).setOpenMode(openMode).setMergePolicy((MergePolicy)new LogByteSizeMergePolicy());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initReaderManager() throws IOException {
        if (this.readerManager == null) {
            DirectoryTaxonomyWriter directoryTaxonomyWriter = this;
            synchronized (directoryTaxonomyWriter) {
                this.ensureOpen();
                if (this.readerManager == null) {
                    this.readerManager = new ReaderManager(this.indexWriter, false);
                    this.shouldRefreshReaderManager = false;
                }
            }
        }
    }

    public DirectoryTaxonomyWriter(Directory directory, IndexWriterConfig.OpenMode openMode) throws IOException {
        this(directory, openMode, DirectoryTaxonomyWriter.defaultTaxonomyWriterCache());
    }

    public static TaxonomyWriterCache defaultTaxonomyWriterCache() {
        return new Cl2oTaxonomyWriterCache(1024, 0.15f, 3);
    }

    public DirectoryTaxonomyWriter(Directory d) throws IOException {
        this(d, IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
    }

    @Override
    public synchronized void close() throws IOException {
        if (!this.isClosed) {
            this.indexWriter.commit(this.combinedCommitData(null));
            this.doClose();
        }
    }

    private void doClose() throws IOException {
        this.indexWriter.close();
        this.isClosed = true;
        this.closeResources();
    }

    protected synchronized void closeResources() throws IOException {
        if (this.readerManager != null) {
            this.readerManager.close();
            this.readerManager = null;
        }
        if (this.cache != null) {
            this.cache.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized int findCategory(CategoryPath categoryPath) throws IOException {
        int res = this.cache.get(categoryPath);
        if (res >= 0 || this.cacheIsComplete) {
            return res;
        }
        this.cacheMisses.incrementAndGet();
        this.perhapsFillCache();
        res = this.cache.get(categoryPath);
        if (res >= 0 || this.cacheIsComplete) {
            return res;
        }
        this.initReaderManager();
        int doc = -1;
        DirectoryReader reader = (DirectoryReader)this.readerManager.acquire();
        try {
            BytesRef catTerm = new BytesRef((CharSequence)categoryPath.toString(this.delimiter));
            int base = 0;
            for (AtomicReader r : reader.getSequentialSubReaders()) {
                DocsEnum docs = r.termDocsEnum(null, "$full_path$", catTerm, 0);
                if (docs != null) {
                    doc = docs.nextDoc() + base;
                    break;
                }
                base += r.maxDoc();
            }
        }
        finally {
            this.readerManager.release((Object)reader);
        }
        if (doc > 0) {
            this.addToCache(categoryPath, doc);
        }
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int findCategory(CategoryPath categoryPath, int prefixLen) throws IOException {
        int res = this.cache.get(categoryPath, prefixLen);
        if (res >= 0 || this.cacheIsComplete) {
            return res;
        }
        this.cacheMisses.incrementAndGet();
        this.perhapsFillCache();
        res = this.cache.get(categoryPath, prefixLen);
        if (res >= 0 || this.cacheIsComplete) {
            return res;
        }
        this.initReaderManager();
        int doc = -1;
        DirectoryReader reader = (DirectoryReader)this.readerManager.acquire();
        try {
            BytesRef catTerm = new BytesRef((CharSequence)categoryPath.toString(this.delimiter, prefixLen));
            int base = 0;
            for (AtomicReader r : reader.getSequentialSubReaders()) {
                DocsEnum docs = r.termDocsEnum(null, "$full_path$", catTerm, 0);
                if (docs != null) {
                    doc = docs.nextDoc() + base;
                    break;
                }
                base += r.maxDoc();
            }
        }
        finally {
            this.readerManager.release((Object)reader);
        }
        if (doc > 0) {
            this.addToCache(categoryPath, prefixLen, doc);
        }
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int addCategory(CategoryPath categoryPath) throws IOException {
        this.ensureOpen();
        int res = this.cache.get(categoryPath);
        if (res < 0) {
            DirectoryTaxonomyWriter directoryTaxonomyWriter = this;
            synchronized (directoryTaxonomyWriter) {
                res = this.findCategory(categoryPath);
                if (res < 0) {
                    res = this.internalAddCategory(categoryPath, categoryPath.length());
                }
            }
        }
        return res;
    }

    private int internalAddCategory(CategoryPath categoryPath, int length) throws IOException {
        int parent;
        if (length > 1) {
            parent = this.findCategory(categoryPath, length - 1);
            if (parent < 0) {
                parent = this.internalAddCategory(categoryPath, length - 1);
            }
        } else {
            parent = length == 1 ? 0 : -1;
        }
        int id = this.addCategoryDocument(categoryPath, length, parent);
        return id;
    }

    protected final void ensureOpen() {
        if (this.isClosed) {
            throw new AlreadyClosedException("The taxonomy writer has already been closed");
        }
    }

    private int addCategoryDocument(CategoryPath categoryPath, int length, int parent) throws IOException {
        this.parentStream.set(Math.max(parent + 1, 1));
        Document d = new Document();
        d.add((IndexableField)this.parentStreamField);
        this.fullPathField.setStringValue(categoryPath.toString(this.delimiter, length));
        d.add((IndexableField)this.fullPathField);
        this.indexWriter.addDocument((Iterable)d);
        int id = this.nextID++;
        this.shouldRefreshReaderManager = true;
        this.addToCache(categoryPath, length, id);
        this.getParentArray().add(id, parent);
        return id;
    }

    private void addToCache(CategoryPath categoryPath, int id) throws IOException {
        if (this.cache.put(categoryPath, id)) {
            this.refreshReaderManager();
            this.cacheIsComplete = false;
        }
    }

    private void addToCache(CategoryPath categoryPath, int prefixLen, int id) throws IOException {
        if (this.cache.put(categoryPath, prefixLen, id)) {
            this.refreshReaderManager();
            this.cacheIsComplete = false;
        }
    }

    private synchronized void refreshReaderManager() throws IOException {
        if (this.shouldRefreshReaderManager && this.readerManager != null) {
            this.readerManager.maybeRefresh();
            this.shouldRefreshReaderManager = false;
        }
    }

    public synchronized void commit() throws IOException {
        this.ensureOpen();
        this.indexWriter.commit(this.combinedCommitData(null));
    }

    private Map<String, String> combinedCommitData(Map<String, String> userData) {
        HashMap<String, String> m = new HashMap<String, String>();
        if (userData != null) {
            m.putAll(userData);
        }
        if (this.createTime != null) {
            m.put(INDEX_CREATE_TIME, this.createTime);
        }
        return m;
    }

    public synchronized void commit(Map<String, String> commitUserData) throws IOException {
        this.ensureOpen();
        this.indexWriter.commit(this.combinedCommitData(commitUserData));
    }

    public synchronized void prepareCommit() throws IOException {
        this.ensureOpen();
        this.indexWriter.prepareCommit(this.combinedCommitData(null));
    }

    public synchronized void prepareCommit(Map<String, String> commitUserData) throws IOException {
        this.ensureOpen();
        this.indexWriter.prepareCommit(this.combinedCommitData(commitUserData));
    }

    @Override
    public int getSize() {
        this.ensureOpen();
        return this.nextID;
    }

    public void setCacheMissesUntilFill(int i) {
        this.ensureOpen();
        this.cacheMissesUntilFill = i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void perhapsFillCache() throws IOException {
        if (this.cacheMisses.get() < this.cacheMissesUntilFill) {
            return;
        }
        if (!this.shouldFillCache) {
            return;
        }
        this.shouldFillCache = false;
        this.initReaderManager();
        boolean aborted = false;
        DirectoryReader reader = (DirectoryReader)this.readerManager.acquire();
        try {
            CategoryPath cp = new CategoryPath();
            TermsEnum termsEnum = null;
            DocsEnum docsEnum = null;
            int base = 0;
            for (AtomicReader r : reader.getSequentialSubReaders()) {
                Terms terms = r.terms("$full_path$");
                if (terms != null) {
                    termsEnum = terms.iterator(termsEnum);
                    while (termsEnum.next() != null) {
                        if (!this.cache.isFull()) {
                            BytesRef t = termsEnum.term();
                            cp.clear();
                            cp.add(t.utf8ToString(), this.delimiter);
                            docsEnum = termsEnum.docs(null, docsEnum, 0);
                            boolean res = this.cache.put(cp, docsEnum.nextDoc() + base);
                            assert (!res) : "entries should not have been evicted from the cache";
                            continue;
                        }
                        aborted = true;
                        break;
                    }
                }
                if (aborted) {
                    break;
                }
                base += r.maxDoc();
            }
        }
        finally {
            this.readerManager.release((Object)reader);
        }
        boolean bl = this.cacheIsComplete = !aborted;
        if (this.cacheIsComplete) {
            DirectoryTaxonomyWriter directoryTaxonomyWriter = this;
            synchronized (directoryTaxonomyWriter) {
                this.readerManager.close();
                this.readerManager = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ParentArray getParentArray() throws IOException {
        if (this.parentArray == null) {
            DirectoryTaxonomyWriter directoryTaxonomyWriter = this;
            synchronized (directoryTaxonomyWriter) {
                if (this.parentArray == null) {
                    this.initReaderManager();
                    this.parentArray = new ParentArray();
                    DirectoryReader reader = (DirectoryReader)this.readerManager.acquire();
                    try {
                        this.parentArray.refresh((IndexReader)reader);
                    }
                    finally {
                        this.readerManager.release((Object)reader);
                    }
                }
            }
        }
        return this.parentArray;
    }

    @Override
    public int getParent(int ordinal) throws IOException {
        this.ensureOpen();
        if (ordinal >= this.nextID) {
            throw new ArrayIndexOutOfBoundsException("requested ordinal is bigger than the largest ordinal in the taxonomy");
        }
        return this.getParentArray().getArray()[ordinal];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTaxonomy(Directory taxoDir, OrdinalMap map) throws IOException {
        this.ensureOpen();
        DirectoryReader r = DirectoryReader.open((Directory)taxoDir);
        try {
            int size = r.numDocs();
            OrdinalMap ordinalMap = map;
            ordinalMap.setSize(size);
            CategoryPath cp = new CategoryPath();
            int base = 0;
            TermsEnum te = null;
            DocsEnum docs = null;
            for (AtomicReader ar : r.getSequentialSubReaders()) {
                Terms terms = ar.terms("$full_path$");
                te = terms.iterator(te);
                while (te.next() != null) {
                    String value = te.term().utf8ToString();
                    cp.clear();
                    cp.add(value, '\uf749');
                    int ordinal = this.findCategory(cp);
                    if (ordinal < 0) {
                        ordinal = this.addCategory(cp);
                    }
                    docs = te.docs(null, docs, 0);
                    ordinalMap.addMapping(docs.nextDoc() + base, ordinal);
                }
                base += ar.maxDoc();
            }
            ordinalMap.addDone();
        }
        finally {
            r.close();
        }
    }

    public synchronized void rollback() throws IOException {
        this.ensureOpen();
        this.indexWriter.rollback();
        this.doClose();
    }

    public synchronized void replaceTaxonomy(Directory taxoDir) throws IOException {
        this.indexWriter.deleteAll();
        this.indexWriter.addIndexes(new Directory[]{taxoDir});
        this.shouldRefreshReaderManager = true;
        this.nextID = this.indexWriter.maxDoc();
        this.cache.clear();
        this.cacheIsComplete = false;
        this.shouldFillCache = true;
        this.createTime = Long.toString(System.nanoTime());
    }

    public Directory getDirectory() {
        return this.dir;
    }

    public static final class DiskOrdinalMap
    implements OrdinalMap {
        File tmpfile;
        DataOutputStream out;
        int[] map = null;

        public DiskOrdinalMap(File tmpfile) throws FileNotFoundException {
            this.tmpfile = tmpfile;
            this.out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(tmpfile)));
        }

        @Override
        public void addMapping(int origOrdinal, int newOrdinal) throws IOException {
            this.out.writeInt(origOrdinal);
            this.out.writeInt(newOrdinal);
        }

        @Override
        public void setSize(int taxonomySize) throws IOException {
            this.out.writeInt(taxonomySize);
        }

        @Override
        public void addDone() throws IOException {
            if (this.out != null) {
                this.out.close();
                this.out = null;
            }
        }

        @Override
        public int[] getMap() throws IOException {
            if (this.map != null) {
                return this.map;
            }
            this.addDone();
            DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(this.tmpfile)));
            this.map = new int[in.readInt()];
            for (int i = 0; i < this.map.length; ++i) {
                int newordinal;
                int origordinal = in.readInt();
                this.map[origordinal] = newordinal = in.readInt();
            }
            in.close();
            if (!this.tmpfile.delete()) {
                this.tmpfile.deleteOnExit();
            }
            return this.map;
        }
    }

    public static final class MemoryOrdinalMap
    implements OrdinalMap {
        int[] map;

        @Override
        public void setSize(int taxonomySize) {
            this.map = new int[taxonomySize];
        }

        @Override
        public void addMapping(int origOrdinal, int newOrdinal) {
            this.map[origOrdinal] = newOrdinal;
        }

        @Override
        public void addDone() {
        }

        @Override
        public int[] getMap() {
            return this.map;
        }
    }

    public static interface OrdinalMap {
        public void setSize(int var1) throws IOException;

        public void addMapping(int var1, int var2) throws IOException;

        public void addDone() throws IOException;

        public int[] getMap() throws IOException;
    }

    private static class SinglePositionTokenStream
    extends TokenStream {
        private CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
        private PositionIncrementAttribute posIncrAtt = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);
        private boolean returned;

        public SinglePositionTokenStream(String word) {
            this.termAtt.setEmpty().append(word);
            this.returned = true;
        }

        public void set(int val) {
            this.posIncrAtt.setPositionIncrement(val);
            this.returned = false;
        }

        public boolean incrementToken() throws IOException {
            if (this.returned) {
                return false;
            }
            this.returned = true;
            return true;
        }
    }
}

