/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.taxonomy.directory;

import java.io.IOException;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DocsAndPositionsEnum;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;

class ParentArray {
    private volatile int[] prefetchParentOrdinal = null;

    ParentArray() {
    }

    public int[] getArray() {
        return this.prefetchParentOrdinal;
    }

    void refresh(IndexReader indexReader) throws IOException {
        int first;
        int num = indexReader.maxDoc();
        if (this.prefetchParentOrdinal == null) {
            this.prefetchParentOrdinal = new int[num];
            if (num > 0) {
                this.prefetchParentOrdinal[0] = -1;
            }
            first = 1;
        } else {
            first = this.prefetchParentOrdinal.length;
            if (first == num) {
                return;
            }
            int[] newarray = new int[num];
            System.arraycopy(this.prefetchParentOrdinal, 0, newarray, 0, this.prefetchParentOrdinal.length);
            this.prefetchParentOrdinal = newarray;
        }
        Bits liveDocs = MultiFields.getLiveDocs((IndexReader)indexReader);
        DocsAndPositionsEnum positions = MultiFields.getTermPositionsEnum((IndexReader)indexReader, (Bits)liveDocs, (String)"$payloads$", (BytesRef)new BytesRef((CharSequence)"p"), (int)2);
        if ((positions == null || positions.advance(first) == Integer.MAX_VALUE) && first < num) {
            throw new CorruptIndexException("Missing parent data for category " + first);
        }
        for (int i = first; i < num; ++i) {
            if (positions.docID() == i) {
                if (positions.freq() == 0) {
                    throw new CorruptIndexException("Missing parent data for category " + i);
                }
                this.prefetchParentOrdinal[i] = positions.nextPosition();
                if (positions.nextDoc() != Integer.MAX_VALUE) continue;
                if (i + 1 >= num) break;
                throw new CorruptIndexException("Missing parent data for category " + (i + 1));
            }
            throw new CorruptIndexException("Missing parent data for category " + i);
        }
    }

    void add(int ordinal, int parentOrdinal) {
        if (ordinal >= this.prefetchParentOrdinal.length) {
            int[] newarray = new int[ordinal * 2 + 1];
            System.arraycopy(this.prefetchParentOrdinal, 0, newarray, 0, this.prefetchParentOrdinal.length);
            this.prefetchParentOrdinal = newarray;
        }
        this.prefetchParentOrdinal[ordinal] = parentOrdinal;
    }
}

