/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.facet.search.CategoryListIterator;

public class MultiCategoryListIterator
implements CategoryListIterator {
    private final CategoryListIterator[] iterators;
    private final List<CategoryListIterator> validIterators;
    private final List<CategoryListIterator> perDocValidIterators;

    public MultiCategoryListIterator(CategoryListIterator ... iterators) {
        this.iterators = iterators;
        this.validIterators = new ArrayList<CategoryListIterator>();
        this.perDocValidIterators = new ArrayList<CategoryListIterator>();
    }

    @Override
    public boolean init() throws IOException {
        for (CategoryListIterator cli : this.iterators) {
            if (!cli.init()) continue;
            this.validIterators.add(cli);
        }
        return !this.validIterators.isEmpty();
    }

    @Override
    public long nextCategory() throws IOException {
        while (!this.perDocValidIterators.isEmpty()) {
            long value = this.perDocValidIterators.get(0).nextCategory();
            if (value <= Integer.MAX_VALUE) {
                return value;
            }
            this.perDocValidIterators.remove(0);
        }
        return 0x100000000L;
    }

    @Override
    public boolean skipTo(int docId) throws IOException {
        this.perDocValidIterators.clear();
        for (CategoryListIterator cli : this.validIterators) {
            if (!cli.skipTo(docId)) continue;
            this.perDocValidIterators.add(cli);
        }
        return !this.perDocValidIterators.isEmpty();
    }
}

