/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.io.IOException;
import java.io.InputStream;

public class UnsafeByteArrayInputStream
extends InputStream {
    private byte[] buffer;
    private int markIndex;
    private int upperLimit;
    private int index;

    public UnsafeByteArrayInputStream() {
        this.index = 0;
        this.upperLimit = 0;
        this.markIndex = 0;
    }

    public UnsafeByteArrayInputStream(byte[] buffer) {
        this.reInit(buffer, 0, buffer.length);
    }

    public UnsafeByteArrayInputStream(byte[] buffer, int startPos, int endPos) {
        this.reInit(buffer, startPos, endPos);
    }

    @Override
    public void mark(int readlimit) {
        this.markIndex = this.index;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    public void reInit(byte[] buffer) {
        this.reInit(buffer, 0, buffer.length);
    }

    public void reInit(byte[] buffer, int startPos, int endPos) {
        this.buffer = buffer;
        this.markIndex = startPos;
        this.upperLimit = endPos;
        this.index = this.markIndex;
    }

    @Override
    public int available() throws IOException {
        return this.upperLimit - this.index;
    }

    @Override
    public int read() throws IOException {
        return this.index < this.upperLimit ? this.buffer[this.index++] & 0xFF : -1;
    }

    @Override
    public void reset() throws IOException {
        this.index = this.markIndex;
    }
}

