/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.encoding;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.lucene.util.encoding.FourFlagsIntEncoder;
import org.apache.lucene.util.encoding.IntDecoder;
import org.apache.lucene.util.encoding.NOnesIntDecoder;

public class NOnesIntEncoder
extends FourFlagsIntEncoder {
    private int n;
    private int onesCounter = 0;

    public NOnesIntEncoder(int n) {
        this.n = n;
    }

    @Override
    public void close() throws IOException {
        while (this.onesCounter-- > 0) {
            super.encode(1);
        }
        super.close();
    }

    @Override
    public void encode(int value) throws IOException {
        if (value == 1) {
            if (++this.onesCounter == this.n) {
                super.encode(2);
                this.onesCounter = 0;
            }
            return;
        }
        while (this.onesCounter > 0) {
            --this.onesCounter;
            super.encode(1);
        }
        super.encode(value + 1);
    }

    @Override
    public IntDecoder createMatchingDecoder() {
        return new NOnesIntDecoder(this.n);
    }

    @Override
    public void reInit(OutputStream out) {
        super.reInit(out);
        this.onesCounter = 0;
    }

    @Override
    public String toString() {
        return "NOnes (" + this.n + ") (" + super.toString() + ")";
    }
}

