/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.associations;

import java.io.IOException;
import org.apache.lucene.facet.associations.CategoryAssociation;
import org.apache.lucene.facet.search.PayloadIterator;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.util.BytesRef;

public abstract class AssociationsPayloadIterator<T extends CategoryAssociation> {
    private final PayloadIterator pi;
    private final T association;
    private boolean hasAssociations = false;

    public AssociationsPayloadIterator(String field, T association) throws IOException {
        this.pi = new PayloadIterator(new Term(field, association.getCategoryListID()));
        this.association = association;
    }

    public final boolean setNextReader(AtomicReaderContext context) throws IOException {
        this.hasAssociations = this.pi.setNextReader(context);
        return this.hasAssociations;
    }

    protected final boolean setNextDoc(int docID) throws IOException {
        if (!this.hasAssociations) {
            return false;
        }
        BytesRef bytes = this.pi.getPayload(docID);
        if (bytes == null) {
            return false;
        }
        ByteArrayDataInput in = new ByteArrayDataInput(bytes.bytes, bytes.offset, bytes.length);
        while (!in.eof()) {
            int ordinal = in.readInt();
            this.association.deserialize(in);
            this.handleAssociation(ordinal, this.association);
        }
        return true;
    }

    protected abstract void handleAssociation(int var1, T var2);
}

