/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.index;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.facet.index.CategoryListBuilder;
import org.apache.lucene.facet.index.categorypolicy.OrdinalPolicy;
import org.apache.lucene.facet.index.params.CategoryListParams;
import org.apache.lucene.facet.index.params.FacetIndexingParams;
import org.apache.lucene.facet.taxonomy.CategoryPath;
import org.apache.lucene.facet.taxonomy.TaxonomyWriter;
import org.apache.lucene.facet.util.PartitionsUtils;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.encoding.IntEncoder;

public class CountingListBuilder
implements CategoryListBuilder {
    private final OrdinalsEncoder ordinalsEncoder;
    private final TaxonomyWriter taxoWriter;
    private final OrdinalPolicy ordinalPolicy;

    public CountingListBuilder(CategoryListParams categoryListParams, FacetIndexingParams indexingParams, TaxonomyWriter taxoWriter) {
        this.taxoWriter = taxoWriter;
        this.ordinalPolicy = indexingParams.getOrdinalPolicy();
        this.ordinalsEncoder = indexingParams.getPartitionSize() == Integer.MAX_VALUE ? new NoPartitionsOrdinalsEncoder(categoryListParams) : new PerPartitionOrdinalsEncoder(indexingParams, categoryListParams);
    }

    @Override
    public Map<String, BytesRef> build(IntsRef ordinals, Iterable<CategoryPath> categories) throws IOException {
        int upto = ordinals.length;
        for (int i = 0; i < upto; ++i) {
            int ordinal = ordinals.ints[i];
            int parent = this.taxoWriter.getParent(ordinal);
            while (parent > 0) {
                if (this.ordinalPolicy.shouldAdd(parent)) {
                    ordinals.ints[ordinals.length++] = parent;
                }
                parent = this.taxoWriter.getParent(parent);
            }
        }
        return this.ordinalsEncoder.encode(ordinals);
    }

    private static final class PerPartitionOrdinalsEncoder
    extends OrdinalsEncoder {
        private final FacetIndexingParams indexingParams;
        private final CategoryListParams categoryListParams;
        private final int partitionSize;
        private final HashMap<String, IntEncoder> partitionEncoder = new HashMap();

        PerPartitionOrdinalsEncoder(FacetIndexingParams indexingParams, CategoryListParams categoryListParams) {
            this.indexingParams = indexingParams;
            this.categoryListParams = categoryListParams;
            this.partitionSize = indexingParams.getPartitionSize();
        }

        public HashMap<String, BytesRef> encode(IntsRef ordinals) {
            HashMap<String, IntsRef> partitionOrdinals = new HashMap<String, IntsRef>();
            for (int i = 0; i < ordinals.length; ++i) {
                int ordinal = ordinals.ints[i];
                String name = PartitionsUtils.partitionNameByOrdinal(this.indexingParams, this.categoryListParams, ordinal);
                IntsRef partitionOrds = (IntsRef)partitionOrdinals.get(name);
                if (partitionOrds == null) {
                    partitionOrds = new IntsRef(32);
                    partitionOrdinals.put(name, partitionOrds);
                    this.partitionEncoder.put(name, this.categoryListParams.createEncoder());
                }
                partitionOrds.ints[partitionOrds.length++] = ordinal % this.partitionSize;
            }
            HashMap<String, BytesRef> partitionBytes = new HashMap<String, BytesRef>();
            for (Map.Entry e : partitionOrdinals.entrySet()) {
                String name = (String)e.getKey();
                IntEncoder encoder = this.partitionEncoder.get(name);
                BytesRef bytes = new BytesRef(128);
                encoder.encode((IntsRef)e.getValue(), bytes);
                partitionBytes.put(name, bytes);
            }
            return partitionBytes;
        }
    }

    private static final class NoPartitionsOrdinalsEncoder
    extends OrdinalsEncoder {
        private final IntEncoder encoder;
        private final String name;

        NoPartitionsOrdinalsEncoder(CategoryListParams categoryListParams) {
            this.name = categoryListParams.getTerm().text();
            this.encoder = categoryListParams.createEncoder();
        }

        @Override
        public Map<String, BytesRef> encode(IntsRef ordinals) {
            BytesRef bytes = new BytesRef(128);
            this.encoder.encode(ordinals, bytes);
            return Collections.singletonMap(this.name, bytes);
        }
    }

    private static abstract class OrdinalsEncoder {
        OrdinalsEncoder() {
        }

        public abstract Map<String, BytesRef> encode(IntsRef var1);
    }
}

