/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.search;

import java.io.IOException;
import org.apache.lucene.facet.search.CategoryListIterator;
import org.apache.lucene.facet.search.PayloadIterator;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.encoding.IntDecoder;

public class PayloadCategoryListIteraor
implements CategoryListIterator {
    private final IntDecoder decoder;
    private final Term term;
    private final PayloadIterator pi;
    private final int hashCode;

    public PayloadCategoryListIteraor(Term term, IntDecoder decoder) throws IOException {
        this.pi = new PayloadIterator(term);
        this.decoder = decoder;
        this.hashCode = term.hashCode();
        this.term = term;
    }

    public boolean equals(Object other) {
        if (!(other instanceof PayloadCategoryListIteraor)) {
            return false;
        }
        PayloadCategoryListIteraor that = (PayloadCategoryListIteraor)other;
        if (this.hashCode != that.hashCode) {
            return false;
        }
        return this.term.equals((Object)that.term);
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public boolean setNextReader(AtomicReaderContext context) throws IOException {
        return this.pi.setNextReader(context);
    }

    @Override
    public void getOrdinals(int docID, IntsRef ints) throws IOException {
        ints.length = 0;
        BytesRef payload = this.pi.getPayload(docID);
        if (payload != null) {
            this.decoder.decode(payload, ints);
        }
    }
}

