/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.search;

import java.io.IOException;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.DocsAndPositionsEnum;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.BytesRef;

public class PayloadIterator {
    private TermsEnum reuseTE;
    private DocsAndPositionsEnum dpe;
    private boolean hasMore;
    private int curDocID;
    private final Term term;

    public PayloadIterator(Term term) throws IOException {
        this.term = term;
    }

    public boolean setNextReader(AtomicReaderContext context) throws IOException {
        Terms terms;
        this.hasMore = false;
        Fields fields = context.reader().fields();
        if (fields != null && (terms = fields.terms(this.term.field())) != null) {
            this.reuseTE = terms.iterator(this.reuseTE);
            if (this.reuseTE.seekExact(this.term.bytes(), true)) {
                this.dpe = this.reuseTE.docsAndPositions(null, this.dpe, 2);
                if (this.dpe != null && (this.curDocID = this.dpe.nextDoc()) != Integer.MAX_VALUE) {
                    this.hasMore = true;
                }
            }
        }
        return this.hasMore;
    }

    public BytesRef getPayload(int docID) throws IOException {
        if (!this.hasMore) {
            return null;
        }
        if (this.curDocID > docID) {
            return null;
        }
        if (this.curDocID < docID) {
            this.curDocID = this.dpe.advance(docID);
            if (this.curDocID != docID) {
                if (this.curDocID == Integer.MAX_VALUE) {
                    this.hasMore = false;
                }
                return null;
            }
        }
        assert (this.dpe.freq() == 1) : "expecting freq=1 (got " + this.dpe.freq() + ") term=" + this.term + " doc=" + this.curDocID;
        int pos = this.dpe.nextPosition();
        assert (pos != -1) : "no positions for term=" + this.term + " doc=" + this.curDocID;
        return this.dpe.getPayload();
    }
}

