/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.search.aggregator.associations;

import java.io.IOException;
import org.apache.lucene.facet.associations.CategoryFloatAssociation;
import org.apache.lucene.facet.associations.FloatAssociationsPayloadIterator;
import org.apache.lucene.facet.index.params.CategoryListParams;
import org.apache.lucene.facet.search.aggregator.Aggregator;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.collections.IntToFloatMap;

public class AssociationFloatSumAggregator
implements Aggregator {
    protected final String field;
    protected final float[] sumArray;
    protected final FloatAssociationsPayloadIterator associations;

    public AssociationFloatSumAggregator(float[] sumArray) throws IOException {
        this(CategoryListParams.DEFAULT_TERM.field(), sumArray);
    }

    public AssociationFloatSumAggregator(String field, float[] sumArray) throws IOException {
        this.field = field;
        this.associations = new FloatAssociationsPayloadIterator(field, new CategoryFloatAssociation());
        this.sumArray = sumArray;
    }

    @Override
    public void aggregate(int docID, float score, IntsRef ordinals) throws IOException {
        IntToFloatMap values = this.associations.getAssociations(docID);
        if (values != null) {
            for (int i = 0; i < ordinals.length; ++i) {
                int ord = ordinals.ints[i];
                if (!values.containsKey(ord)) continue;
                int n = ord;
                this.sumArray[n] = this.sumArray[n] + values.get(ord);
            }
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        AssociationFloatSumAggregator that = (AssociationFloatSumAggregator)obj;
        return that.field.equals(this.field) && that.sumArray == this.sumArray;
    }

    public int hashCode() {
        return this.field.hashCode();
    }

    @Override
    public boolean setNextReader(AtomicReaderContext context) throws IOException {
        return this.associations.setNextReader(context);
    }
}

