/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.search.params;

import java.util.Arrays;
import java.util.List;
import org.apache.lucene.facet.index.params.FacetIndexingParams;
import org.apache.lucene.facet.search.cache.CategoryListCache;
import org.apache.lucene.facet.search.params.FacetRequest;

public class FacetSearchParams {
    protected final FacetIndexingParams indexingParams;
    protected final List<FacetRequest> facetRequests;

    public FacetSearchParams(FacetRequest ... facetRequests) {
        this(Arrays.asList(facetRequests), FacetIndexingParams.ALL_PARENTS);
    }

    public FacetSearchParams(List<FacetRequest> facetRequests) {
        this(facetRequests, FacetIndexingParams.ALL_PARENTS);
    }

    public FacetSearchParams(List<FacetRequest> facetRequests, FacetIndexingParams indexingParams) {
        if (facetRequests == null || facetRequests.size() == 0) {
            throw new IllegalArgumentException("at least one FacetRequest must be defined");
        }
        this.indexingParams = indexingParams;
        this.facetRequests = facetRequests;
    }

    public CategoryListCache getCategoryListCache() {
        return null;
    }

    public FacetIndexingParams getFacetIndexingParams() {
        return this.indexingParams;
    }

    public List<FacetRequest> getFacetRequests() {
        return this.facetRequests;
    }

    public String toString() {
        int TAB = 9;
        int NEWLINE = 10;
        StringBuilder sb = new StringBuilder("IndexingParams: ");
        sb.append('\n').append('\t').append(this.getFacetIndexingParams());
        sb.append('\n').append("FacetRequests:");
        for (FacetRequest facetRequest : this.getFacetRequests()) {
            sb.append('\n').append('\t').append(facetRequest);
        }
        return sb.toString();
    }
}

