/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.util;

import org.apache.lucene.facet.index.params.CategoryListParams;
import org.apache.lucene.facet.index.params.FacetIndexingParams;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;

public final class PartitionsUtils {
    public static final int partitionOffset(FacetIndexingParams iParams, int partitionNumber, TaxonomyReader taxonomyReader) {
        return partitionNumber * PartitionsUtils.partitionSize(iParams, taxonomyReader);
    }

    public static final int partitionSize(FacetIndexingParams indexingParams, TaxonomyReader taxonomyReader) {
        return Math.min(indexingParams.getPartitionSize(), taxonomyReader.getSize());
    }

    public static final int partitionNumber(FacetIndexingParams iParams, int ordinal) {
        return ordinal / iParams.getPartitionSize();
    }

    public static final String partitionNameByOrdinal(FacetIndexingParams iParams, CategoryListParams clParams, int ordinal) {
        int partition = PartitionsUtils.partitionNumber(iParams, ordinal);
        return PartitionsUtils.partitionName(clParams, partition);
    }

    public static final String partitionName(CategoryListParams clParams, int partition) {
        String term = clParams.getTerm().text();
        if (partition == 0) {
            return term;
        }
        return term + partition;
    }
}

