/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.encoding;

import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.encoding.IntDecoder;

public class EightFlagsIntDecoder
extends IntDecoder {
    private static final byte[][] DECODE_TABLE = new byte[256][8];

    @Override
    public void decode(BytesRef buf, IntsRef values) {
        values.length = 0;
        values.offset = 0;
        int upto = buf.offset + buf.length;
        int offset = buf.offset;
        while (offset < upto) {
            int indicator = buf.bytes[offset++] & 0xFF;
            int ordinal = 0;
            int capacityNeeded = values.length + 8;
            if (values.ints.length < capacityNeeded) {
                values.grow(capacityNeeded);
            }
            block1: while (ordinal != 8) {
                if (DECODE_TABLE[indicator][ordinal++] == 0) {
                    if (offset == upto) {
                        return;
                    }
                    int value = 0;
                    while (true) {
                        byte b;
                        if ((b = buf.bytes[offset++]) >= 0) {
                            values.ints[values.length++] = (value << 7 | b) + 2;
                            continue block1;
                        }
                        value = value << 7 | b & 0x7F;
                    }
                }
                values.ints[values.length++] = 1;
            }
        }
    }

    public String toString() {
        return "EightFlags(VInt8)";
    }

    static {
        int i = 256;
        while (i != 0) {
            --i;
            int j = 8;
            while (j != 0) {
                EightFlagsIntDecoder.DECODE_TABLE[i][--j] = (byte)(i >>> j & 1);
            }
        }
    }
}

